/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.chatapi.wechat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import me.xuxiaoxiao.xtools.common.http.executor.impl.XRequest;

final class WeChatTools {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    WeChatTools() {
    }

    public static String fileType(File file) {
        switch (WeChatTools.fileSuffix(file)) {
            case "bmp": 
            case "png": 
            case "jpeg": 
            case "jpg": {
                return "pic";
            }
            case "mp4": {
                return "video";
            }
        }
        return "doc";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fileSuffix(File file) {
        try (FileInputStream is = new FileInputStream(file);){
            String fileCode;
            byte[] b = new byte[3];
            is.read(b, 0, b.length);
            switch (fileCode = WeChatTools.bytesToHex(b)) {
                case "ffd8ff": {
                    String string = "jpg";
                    return string;
                }
                case "89504e": {
                    String string = "png";
                    return string;
                }
                case "474946": {
                    String string = "gif";
                    return string;
                }
            }
            if (fileCode.startsWith("424d")) {
                String string = "bmp";
                return string;
            }
            if (file.getName().lastIndexOf(46) > 0) {
                String string = file.getName().substring(file.getName().lastIndexOf(46) + 1);
                return string;
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            chars[i << 1] = HEX[b >>> 4 & 0xF];
            chars[(i << 1) + 1] = HEX[b & 0xF];
        }
        return new String(chars);
    }

    public static final class Slice
    extends XRequest.MultipartContent.Part {
        public String fileName;
        public String fileMime;
        public int count;

        public Slice(String name, String fileName, String fileMime, byte[] slice, int count) {
            super(name, (Object)slice);
            this.fileName = fileName;
            this.fileMime = fileMime;
            this.count = count;
        }

        public String[] headers() throws IOException {
            String disposition = String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", this.name, URLEncoder.encode(this.fileName, "utf-8"));
            String type = String.format("Content-Type: %s", this.fileMime);
            return new String[]{disposition, type};
        }

        public long partLength() {
            return this.count;
        }

        public void partWrite(OutputStream doStream) throws IOException {
            doStream.write((byte[])this.value, 0, this.count);
        }
    }
}

