/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.chatapi.wechat;

import java.util.HashMap;
import me.xuxiaoxiao.chatapi.wechat.entity.contact.WXContact;
import me.xuxiaoxiao.chatapi.wechat.entity.contact.WXGroup;
import me.xuxiaoxiao.chatapi.wechat.entity.contact.WXUser;
import me.xuxiaoxiao.chatapi.wechat.protocol.RspInit;

final class WeChatContacts {
    private final HashMap<String, WXContact> contacts = new HashMap();
    private final HashMap<String, WXUser> friends = new HashMap();
    private final HashMap<String, WXGroup> groups = new HashMap();
    private WXUser me;

    WeChatContacts() {
    }

    private static <T extends WXContact> T parseContact(String host, RspInit.User contact) {
        if (contact.UserName.startsWith("@@")) {
            WXGroup group = new WXGroup();
            group.id = contact.UserName;
            group.name = contact.NickName;
            group.namePY = contact.PYInitial;
            group.nameQP = contact.PYQuanPin;
            group.avatarUrl = String.format("https://%s%s", host, contact.HeadImgUrl);
            group.contactFlag = contact.ContactFlag;
            group.isDetail = false;
            group.isOwner = contact.IsOwner > 0;
            group.members = new HashMap();
            for (RspInit.User user : contact.MemberList) {
                WXGroup.Member member = new WXGroup.Member();
                member.id = user.UserName;
                member.name = user.NickName;
                member.display = user.DisplayName;
                group.members.put(member.id, member);
            }
            return (T)group;
        }
        WXUser user = new WXUser();
        user.id = contact.UserName;
        user.name = contact.NickName;
        user.namePY = contact.PYInitial;
        user.nameQP = contact.PYQuanPin;
        user.avatarUrl = String.format("https://%s%s", host, contact.HeadImgUrl);
        user.contactFlag = contact.ContactFlag;
        user.gender = contact.Sex;
        user.signature = contact.Signature;
        user.remark = contact.RemarkName;
        user.remarkPY = contact.RemarkPYInitial;
        user.remarkQP = contact.RemarkPYQuanPin;
        user.province = contact.Province;
        user.city = contact.City;
        user.verifyFlag = contact.VerifyFlag;
        return (T)user;
    }

    WXUser getMe() {
        return this.me;
    }

    WXUser getFriend(String id) {
        return this.friends.get(id);
    }

    HashMap<String, WXUser> getFriends() {
        return this.friends;
    }

    WXGroup getGroup(String id) {
        return this.groups.get(id);
    }

    HashMap<String, WXGroup> getGroups() {
        return this.groups;
    }

    WXContact getContact(String userId) {
        return this.contacts.get(userId);
    }

    void setMe(String host, RspInit.User userMe) {
        this.me = (WXUser)WeChatContacts.parseContact(host, userMe);
        this.contacts.put(this.me.id, this.me);
    }

    void putContact(String host, RspInit.User userContact) {
        Object contact = WeChatContacts.parseContact(host, userContact);
        this.contacts.put(((WXContact)contact).id, (WXContact)contact);
        if (contact instanceof WXGroup) {
            WXGroup group = (WXGroup)contact;
            this.groups.put(group.id, group);
        } else {
            WXUser user = (WXUser)contact;
            if ((user.contactFlag & 1) > 0) {
                this.friends.put(user.id, user);
            }
        }
    }

    WXContact rmvContact(String userId) {
        this.groups.remove(userId);
        this.friends.remove(userId);
        return this.contacts.remove(userId);
    }
}

