/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import me.xuxiaoxiao.xtools.common.code.XCodeTools;
import me.xuxiaoxiao.xtools.common.config.XConfigTools;
import me.xuxiaoxiao.xtools.common.config.configs.XConfigs;
import me.xuxiaoxiao.xtools.common.http.XHttpTools;
import me.xuxiaoxiao.xtools.common.http.executor.XHttpExecutor;
import me.xuxiaoxiao.xtools.common.log.XLogTools;
import me.xuxiaoxiao.xtools.common.time.XTimeTools;

public final class XTools {
    public static final String CFG_PREFIX = "me.xuxiaoxiao$xtools-common$";

    private XTools() {
    }

    public static String md5(String str) {
        try {
            return XCodeTools.hash("MD5", str.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String md5(File file) {
        try {
            return XCodeTools.hash("MD5", file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sha1(String str) {
        try {
            return XCodeTools.hash("SHA-1", str.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String sha1(File file) {
        try {
            return XCodeTools.hash("SHA-1", file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static XHttpExecutor.Response http(XHttpExecutor.Request request) {
        return XHttpTools.http(XHttpTools.EXECUTOR, request);
    }

    public static XHttpExecutor.Response http(XHttpExecutor executor, XHttpExecutor.Request request) {
        return XHttpTools.http(executor, request);
    }

    public static boolean strEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean strBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String strJoin(Collection<String> strSet, String glue) {
        StringBuilder sbStr = new StringBuilder();
        for (String str : strSet) {
            if (sbStr.length() > 0) {
                sbStr.append(glue);
            }
            sbStr.append(str);
        }
        return sbStr.toString();
    }

    public static String strJoin(Map<?, ?> strMap, String glueInner, String glueOuter) {
        StringBuilder sbStr = new StringBuilder();
        for (Object key : strMap.keySet()) {
            if (sbStr.length() > 0) {
                sbStr.append(glueOuter);
            }
            sbStr.append(key).append(glueInner).append(strMap.get(key));
        }
        return sbStr.toString();
    }

    public static File strToFile(String str, String path, String charset) throws IOException {
        File file = new File(path);
        try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(file));){
            outStream.write(str.getBytes(charset));
            outStream.flush();
            File file2 = file;
            return file2;
        }
    }

    public static String fileToStr(File file, String charset) throws IOException {
        try (FileInputStream fInStream = new FileInputStream(file);){
            String string = XTools.streamToStr(fInStream, charset);
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    public static File fileToFile(File file, String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String streamToStr(InputStream inStream, String charset) throws IOException {
        int count;
        char[] buffer = new char[1024];
        StringBuilder sbStr = new StringBuilder();
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, charset));
        while ((count = bufReader.read(buffer)) > 0) {
            sbStr.append(buffer, 0, count);
        }
        return sbStr.toString();
    }

    public static File streamToFile(InputStream inStream, String path) throws IOException {
        byte[] buffer = new byte[1024];
        File file = new File(path);
        BufferedInputStream bufInStream = new BufferedInputStream(inStream);
        try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(file));){
            int count;
            while ((count = bufInStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, count);
            }
            outStream.flush();
        }
        return file;
    }

    public static void streamToStream(InputStream inStream, OutputStream outStream) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        BufferedInputStream bufInStream = new BufferedInputStream(inStream);
        BufferedOutputStream bufOutStream = new BufferedOutputStream(outStream);
        while ((count = bufInStream.read(buffer)) > 0) {
            bufOutStream.write(buffer, 0, count);
        }
        bufOutStream.flush();
    }

    public static int dateType(Date date) {
        return XTimeTools.dateType(date);
    }

    public static String dateFormat(String format, Date date) {
        return XTimeTools.dateFormat(format, date);
    }

    public static Date dateParse(String format, String dateStr) {
        return XTimeTools.dateParse(format, dateStr);
    }

    public static Date date(Date base, int offset) {
        return XTimeTools.date(base, offset);
    }

    public static Date dateByWeek(Date base, int weekOffset, int dayIndex) {
        return XTimeTools.dateByWeek(base, weekOffset, dayIndex);
    }

    public static Date dateByMonth(Date base, int monthOffset, int dayIndex) {
        return XTimeTools.dateByMonth(base, monthOffset, dayIndex);
    }

    public static Date dateBySeason(Date base, int seasonOffset, int dayIndex) {
        return XTimeTools.dateBySeason(base, seasonOffset, dayIndex);
    }

    public static Date dateByYear(Date base, int yearOffset, int dayIndex) {
        return XTimeTools.dateByYear(base, yearOffset, dayIndex);
    }

    public static Date weekByMonth(Date base, int monthOffset, int weekIndex) {
        return XTimeTools.weekByMonth(base, monthOffset, weekIndex);
    }

    public static Date weekBySeason(Date base, int seasonOffset, int weekIndex) {
        return XTimeTools.weekBySeason(base, seasonOffset, weekIndex);
    }

    public static Date weekByYear(Date base, int yearOffset, int weekIndex) {
        return XTimeTools.weekByYear(base, yearOffset, weekIndex);
    }

    public static Date monthBySeason(Date base, int seasonOffset, int monthIndex) {
        return XTimeTools.monthBySeason(base, seasonOffset, monthIndex);
    }

    public static Date monthByYear(Date base, int yearOffset, int monthIndex) {
        return XTimeTools.monthByYear(base, yearOffset, monthIndex);
    }

    public static Date seasonByYear(Date base, int yearOffset, int seasonIndex) {
        return XTimeTools.seasonByYear(base, yearOffset, seasonIndex);
    }

    public static int dateInWeek(Date base) {
        return XTimeTools.dateInWeek(base);
    }

    public static int dateInMonth(Date base) {
        return XTimeTools.dateInMonth(base);
    }

    public static int dateInSeason(Date base) {
        return XTimeTools.dateInSeason(base);
    }

    public static int dateInYear(Date base) {
        return XTimeTools.dateInYear(base);
    }

    public static int weekInMonth(Date base) {
        return XTimeTools.weekInMonth(base);
    }

    public static int weekInSeason(Date base) {
        return XTimeTools.weekInSeason(base);
    }

    public static int weekInYear(Date base) {
        return XTimeTools.weekInYear(base);
    }

    public static int monthInSeason(Date base) {
        return XTimeTools.monthInSeason(base);
    }

    public static int monthInYear(Date base) {
        return XTimeTools.monthInYear(base);
    }

    public static int seasonInYear(Date base) {
        return XTimeTools.seasonInYear(base);
    }

    public static String solarToLunar(Date solarDate) {
        return XTimeTools.solarToLunar(solarDate);
    }

    public static Date lunarToSolar(String lunarDate) {
        return XTimeTools.lunarToSolar(lunarDate);
    }

    public static boolean sysWindows() {
        return System.getProperties().getProperty("os.name").toLowerCase().contains("windows");
    }

    public static boolean sysMacOS() {
        String osName = System.getProperties().getProperty("os.name").toLowerCase();
        return osName.contains("mac") && !osName.contains("x");
    }

    public static boolean sysMacOSX() {
        String osName = System.getProperties().getProperty("os.name").toLowerCase();
        return osName.contains("mac") && osName.contains("x");
    }

    public static boolean sysLinux() {
        String osName = System.getProperties().getProperty("os.name").toLowerCase();
        return osName.contains("linux");
    }

    public static void cfgSet(String key, String val) {
        XConfigTools.X_CONFIGS.cfgSet(key, val);
    }

    public static String cfgGet(String key) {
        return XConfigTools.X_CONFIGS.cfgGet(key);
    }

    public static String cfgDef(String key, String def) {
        return XConfigTools.X_CONFIGS.cfgDef(key, def);
    }

    public static void cfgWatch(String prefix, XConfigs.Watcher watcher) {
        XConfigTools.X_CONFIGS.watcherAdd(prefix, watcher);
    }

    public static void logE(String tag, String error, Object ... args) {
        XLogTools.LOGGER.logE(tag, error, args);
    }

    public static void logE(String tag, Throwable throwable, String error, Object ... args) {
        XLogTools.LOGGER.logE(tag, throwable, error, args);
    }

    public static void logW(String tag, String warning, Object ... args) {
        XLogTools.LOGGER.logW(tag, warning, args);
    }

    public static void logW(String tag, Throwable throwable, String warning, Object ... args) {
        XLogTools.LOGGER.logW(tag, throwable, warning, args);
    }

    public static void logN(String tag, String notice, Object ... args) {
        XLogTools.LOGGER.logN(tag, notice, args);
    }

    public static void logD(String tag, String detail, Object ... args) {
        XLogTools.LOGGER.logD(tag, detail, args);
    }
}

