/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common.http;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import me.xuxiaoxiao.xtools.common.XTools;
import me.xuxiaoxiao.xtools.common.config.XConfigTools;
import me.xuxiaoxiao.xtools.common.http.executor.XHttpExecutor;
import me.xuxiaoxiao.xtools.common.http.executor.impl.XHttpExecutorImpl;
import me.xuxiaoxiao.xtools.common.http.executor.impl.XResponse;

public final class XHttpTools {
    public static final String CFG_EXECUTOR = "me.xuxiaoxiao$xtools-common$http.executor";
    public static final String CFG_EXECUTOR_DEFAULT = XHttpExecutorImpl.class.getName();
    public static final XHttpExecutor EXECUTOR = (XHttpExecutor)XConfigTools.supply(XTools.cfgDef("me.xuxiaoxiao$xtools-common$http.executor", CFG_EXECUTOR_DEFAULT).trim());

    private XHttpTools() {
    }

    public static XHttpExecutor.Response http(XHttpExecutor executor, XHttpExecutor.Request request) {
        try {
            return XHttpTools.execute(executor, request);
        }
        catch (Exception e) {
            return new XResponse(null, null);
        }
    }

    public static XHttpExecutor.Response execute(XHttpExecutor executor, XHttpExecutor.Request request) throws Exception {
        XHttpExecutor.Interceptor[] interceptors = executor.getInterceptors();
        if (interceptors != null && interceptors.length > 0) {
            for (XHttpExecutor.Interceptor interceptor : interceptors) {
                executor = (XHttpExecutor)Proxy.newProxyInstance(XHttpTools.class.getClassLoader(), new Class[]{XHttpExecutor.class}, (InvocationHandler)new ExecuteHandler(executor, interceptor));
            }
        }
        return executor.execute(request);
    }

    private static class ExecuteHandler
    implements InvocationHandler {
        XHttpExecutor target;
        XHttpExecutor.Interceptor interceptor;

        public ExecuteHandler(XHttpExecutor target, XHttpExecutor.Interceptor interceptor) {
            this.target = target;
            this.interceptor = interceptor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (XHttpExecutor.class.equals(method.getDeclaringClass())) {
                return this.interceptor.intercept(this.target, (XHttpExecutor.Request)args[0]);
            }
            return method.invoke((Object)this.target, args);
        }
    }
}

