/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common.http.executor.impl;

import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import me.xuxiaoxiao.xtools.common.XTools;
import me.xuxiaoxiao.xtools.common.config.XConfigTools;
import me.xuxiaoxiao.xtools.common.http.executor.XHttpExecutor;
import me.xuxiaoxiao.xtools.common.http.executor.impl.XResponse;

public class XHttpExecutorImpl
implements XHttpExecutor {
    public static final String CFG_CONNECT_TIMEOUT = "me.xuxiaoxiao$xtools-common$http.connectTimeout";
    public static final String CFG_CONNECT_TIMEOUT_DEFAULT = "20000";
    public static final String CFG_READ_TIMEOUT = "me.xuxiaoxiao$xtools-common$http.readTimeout";
    public static final String CFG_READ_TIMEOUT_DEFAULT = "60000";
    public static final String CFG_FOLLOW_REDIRECT = "me.xuxiaoxiao$xtools-common$http.followRedirect";
    public static final String CFG_FOLLOW_REDIRECT_DEFAULT = "false";
    public static final String CFG_CHUNK_LENGTH = "me.xuxiaoxiao$xtools-common$http.chunkLength";
    public static final String CFG_CHUNK_LENGTH_DEFAULT = "262144";
    public static final String CFG_COOKIE_MANAGER = "me.xuxiaoxiao$xtools-common$http.cookieManager";
    public static final String CFG_COOKIE_MANAGER_DEFAULT = XCookieManager.class.getName();
    public static final String CFG_INTERCEPTORS = "me.xuxiaoxiao$xtools-common$http.interceptors";
    public static final String CFG_INTERCEPTORS_DEFAULT = "";
    public static final String CFG_HOSTNAME_VERIFIER = "me.xuxiaoxiao$xtools-common$http.hostnameVerifier";
    public static final String CFG_HOSTNAME_VERIFIER_DEFAULT = XHostnameVerifier.class.getName();
    public static final String CFG_SSL_ALGORITHM = "me.xuxiaoxiao$xtools-common$http.ssl.algorithm";
    public static final String CFG_SSL_ALGORITHM_DEFAULT = "TLS";
    public static final String CFG_SSL_KEY_MANAGERS = "me.xuxiaoxiao$xtools-common$http.ssl.keyManagers";
    public static final String CFG_SSL_KEY_MANAGERS_DEFAULT = "";
    public static final String CFG_SSL_TRUST_MANAGERS = "me.xuxiaoxiao$xtools-common$http.ssl.trustManagers";
    public static final String CFG_SSL_TRUST_MANAGERS_DEFAULT = "";
    public static final String CFG_SSL_SECURE_RANDOM = "me.xuxiaoxiao$xtools-common$http.ssl.secureRandom";
    public static final String CFG_SSL_SECURE_RANDOM_DEFAULT = "";
    private int connectTimeout;
    private int readTimeout;
    private int chunkLength;
    private boolean followRedirect;
    private CookieManager cookieManager;
    private XHttpExecutor.Interceptor[] interceptors;
    private HostnameVerifier hostnameVerifier;
    private SSLContext sslContext;

    public XHttpExecutorImpl() {
        this.defaultConnectTimeout();
        this.defaultReadTimeout();
        this.defaultChunkLength();
        this.defaultFollowRedirect();
        this.defaultCookieManager();
        this.defaultHostnameVerifier();
        this.defaultInterceptors();
        this.defaultSSL();
    }

    public void defaultConnectTimeout() {
        this.connectTimeout = Integer.valueOf(XTools.cfgDef(CFG_CONNECT_TIMEOUT, CFG_CONNECT_TIMEOUT_DEFAULT).trim());
    }

    public void defaultReadTimeout() {
        this.readTimeout = Integer.valueOf(XTools.cfgDef(CFG_READ_TIMEOUT, CFG_READ_TIMEOUT_DEFAULT).trim());
    }

    public void defaultChunkLength() {
        this.chunkLength = Integer.valueOf(XTools.cfgDef(CFG_CHUNK_LENGTH, CFG_CHUNK_LENGTH_DEFAULT).trim());
    }

    public void defaultFollowRedirect() {
        this.followRedirect = Boolean.valueOf(XTools.cfgDef(CFG_FOLLOW_REDIRECT, CFG_FOLLOW_REDIRECT_DEFAULT).trim());
    }

    private void defaultCookieManager() {
        this.cookieManager = (CookieManager)XConfigTools.supply(XTools.cfgDef(CFG_COOKIE_MANAGER, CFG_COOKIE_MANAGER_DEFAULT).trim());
    }

    private void defaultHostnameVerifier() {
        this.hostnameVerifier = (HostnameVerifier)XConfigTools.supply(XTools.cfgDef(CFG_HOSTNAME_VERIFIER, CFG_HOSTNAME_VERIFIER_DEFAULT).trim());
    }

    private void defaultInterceptors() {
        String interceptorsStr = XTools.cfgDef(CFG_INTERCEPTORS, "");
        if (!XTools.strBlank(interceptorsStr)) {
            String[] array = interceptorsStr.split(",");
            XHttpExecutor.Interceptor[] interceptors = new XHttpExecutor.Interceptor[array.length];
            for (int i = 0; i < array.length; ++i) {
                interceptors[i] = (XHttpExecutor.Interceptor)XConfigTools.supply(array[i].trim());
            }
            this.setInterceptors(interceptors);
        } else {
            this.setInterceptors(new XHttpExecutor.Interceptor[0]);
        }
    }

    private void defaultSSL() {
        try {
            this.sslContext = SSLContext.getInstance(XTools.cfgDef(CFG_SSL_ALGORITHM, CFG_SSL_ALGORITHM_DEFAULT));
            KeyManager[] keyManagers = null;
            String keyManagersStr = XTools.cfgDef(CFG_SSL_KEY_MANAGERS, "");
            if (!XTools.strBlank(keyManagersStr)) {
                String[] array = keyManagersStr.split(",");
                keyManagers = new KeyManager[array.length];
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    keyManagers[i] = (KeyManager)XConfigTools.supply(array[i].trim());
                }
            }
            TrustManager[] trustManagers = null;
            String trustManagersStr = XTools.cfgDef(CFG_SSL_TRUST_MANAGERS, "");
            if (!XTools.strBlank(trustManagersStr)) {
                String[] array = trustManagersStr.split(",");
                trustManagers = new TrustManager[array.length];
                int len = array.length;
                for (int i = 0; i < len; ++i) {
                    trustManagers[i] = (TrustManager)XConfigTools.supply(array[i].trim());
                }
            }
            SecureRandom secureRandom = null;
            String secureRandomStr = XTools.cfgDef(CFG_SSL_SECURE_RANDOM, "").trim();
            if (!XTools.strBlank(secureRandomStr)) {
                secureRandom = (SecureRandom)XConfigTools.supply(secureRandomStr);
            }
            this.sslContext.init(keyManagers, trustManagers, secureRandom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void addCookie(URI uri, HttpCookie cookie) {
        this.cookieManager.getCookieStore().add(uri, cookie);
    }

    @Override
    public List<HttpCookie> getCookies(URI uri) {
        return this.cookieManager.getCookieStore().get(uri);
    }

    @Override
    public List<HttpCookie> getCookies() {
        return this.cookieManager.getCookieStore().getCookies();
    }

    @Override
    public void rmvCookies(URI uri, HttpCookie cookie) {
        this.cookieManager.getCookieStore().remove(uri, cookie);
    }

    @Override
    public void rmvCookies() {
        this.cookieManager.getCookieStore().removeAll();
    }

    public void setChunkLength(int chunkLength) {
        this.chunkLength = chunkLength;
    }

    public int getChunkLength() {
        return this.chunkLength;
    }

    public void setFollowRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
    }

    public boolean getFollowRedirect() {
        return this.followRedirect;
    }

    @Override
    public void setInterceptors(XHttpExecutor.Interceptor ... interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public XHttpExecutor.Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    protected HttpURLConnection connect(XHttpExecutor.Request request) throws Exception {
        String url = request.getUrl();
        if (url.toLowerCase().startsWith("http://")) {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(this.getConnectTimeout());
            connection.setReadTimeout(this.getReadTimeout());
            connection.setInstanceFollowRedirects(this.getFollowRedirect());
            return connection;
        }
        if (url.toLowerCase().startsWith("https://")) {
            HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
            connection.setSSLSocketFactory(this.getSSLContext().getSocketFactory());
            connection.setHostnameVerifier(this.getHostnameVerifier());
            connection.setConnectTimeout(this.getConnectTimeout());
            connection.setReadTimeout(this.getReadTimeout());
            connection.setInstanceFollowRedirects(this.getFollowRedirect());
            return connection;
        }
        throw new IllegalArgumentException("XHttpExecutorImpl\u4ec5\u652f\u6301HTTP\u534f\u8bae\u548cHTTPS\u534f\u8bae");
    }

    @Override
    public XHttpExecutor.Response execute(XHttpExecutor.Request request) throws Exception {
        HttpURLConnection connection = this.connect(request);
        connection.setRequestMethod(request.getMethod());
        List<XHttpExecutor.KeyValue> headers = request.getHeaders();
        if (headers != null) {
            for (XHttpExecutor.KeyValue keyValue : headers) {
                connection.addRequestProperty(keyValue.key, String.valueOf(keyValue.value));
            }
        }
        if (this.cookieManager != null) {
            Map<String, List<String>> cookiesList = this.cookieManager.get(connection.getURL().toURI(), new HashMap<String, List<String>>());
            for (String cookieType : cookiesList.keySet()) {
                StringBuilder sbCookie = new StringBuilder();
                for (String cookieStr : cookiesList.get(cookieType)) {
                    if (sbCookie.length() > 0) {
                        sbCookie.append(';');
                    }
                    sbCookie.append(cookieStr);
                }
                if (sbCookie.length() <= 0) continue;
                connection.setRequestProperty(cookieType, sbCookie.toString());
            }
        }
        if ("POST".equals(request.getMethod()) || "PUT".equals(request.getMethod())) {
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            XHttpExecutor.Content content = request.getContent();
            if (content != null) {
                if (content.contentLength() < 0L) {
                    connection.setChunkedStreamingMode(this.getChunkLength());
                }
                try (DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());){
                    content.contentWrite(dataOutputStream);
                }
            }
        }
        InputStream inStream = connection.getInputStream();
        if (this.cookieManager != null) {
            this.cookieManager.put(connection.getURL().toURI(), connection.getHeaderFields());
        }
        return new XResponse(connection, inStream);
    }

    public static class XHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    public static class XCookieManager
    extends CookieManager {
        public XCookieManager() {
            super(null, CookiePolicy.ACCEPT_ALL);
        }
    }
}

