/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common.log;

import me.xuxiaoxiao.xtools.common.XTools;
import me.xuxiaoxiao.xtools.common.config.XConfigTools;
import me.xuxiaoxiao.xtools.common.config.configs.XConfigs;
import me.xuxiaoxiao.xtools.common.log.logger.XLogger;
import me.xuxiaoxiao.xtools.common.log.logger.impl.XLoggerImpl;

public class XLogTools {
    public static final String CFG_LOGGER = "me.xuxiaoxiao$xtools-common$log.logger";
    public static final String CFG_LOGGER_DEFAULT = XLoggerImpl.class.getName();
    public static final String CFG_LEVEL = "me.xuxiaoxiao$xtools-common$log.level";
    public static final String CFG_LEVEL_DEFAULT = "detail";
    private static final String TAG_LEVEL_PREFIX = "me.xuxiaoxiao$xtools-common$log.level.";
    public static final XLogger LOGGER = (XLogger)XConfigTools.supply(XTools.cfgDef("me.xuxiaoxiao$xtools-common$log.logger", CFG_LOGGER_DEFAULT).trim());

    static {
        LOGGER.setLevel(XTools.cfgDef(CFG_LEVEL, CFG_LEVEL_DEFAULT));
        XConfigTools.X_CONFIGS.cfgIterate(new XConfigs.Iteration(){

            @Override
            public boolean iterate(String key, String value) {
                String tag;
                if (key.startsWith(XLogTools.TAG_LEVEL_PREFIX) && !XTools.strBlank(tag = key.substring(XLogTools.TAG_LEVEL_PREFIX.length())) && !XTools.strBlank(value)) {
                    LOGGER.setLevel(tag, value.trim());
                }
                return false;
            }
        });
        XTools.cfgWatch(CFG_LEVEL, new XConfigs.Watcher(){

            @Override
            public void onCfgAdd(XConfigs configs, String key, String val) {
                if (key.equals(XLogTools.CFG_LEVEL)) {
                    LOGGER.setLevel(val.trim());
                } else {
                    LOGGER.setLevel(key.substring(XLogTools.TAG_LEVEL_PREFIX.length()), val.trim());
                }
            }

            @Override
            public void onCfgDel(XConfigs configs, String key, String val) {
                LOGGER.setLevel(key.substring(XLogTools.TAG_LEVEL_PREFIX.length()), null);
            }

            @Override
            public void onCfgChange(XConfigs configs, String key, String valOld, String valNew) {
                if (key.equals(XLogTools.CFG_LEVEL)) {
                    LOGGER.setLevel(valNew.trim());
                } else {
                    LOGGER.setLevel(key.substring(XLogTools.TAG_LEVEL_PREFIX.length()), valNew.trim());
                }
            }
        });
    }
}

