/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common.log.logger.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import me.xuxiaoxiao.xtools.common.XTools;
import me.xuxiaoxiao.xtools.common.config.XConfigTools;
import me.xuxiaoxiao.xtools.common.log.logger.XLogger;

public class XLoggerImpl
implements XLogger {
    private static final String TAG = "xlog";
    public static final String CFG_HANDLERS = "me.xuxiaoxiao$xtools-common$log.handlers";
    public static final String CFG_HANDLERS_DEFAULT = XConsoleHandler.class.getName() + "," + XFileHandler.class.getName();
    public static final String CFG_FORMATTER = "me.xuxiaoxiao$xtools-common$log.formatter";
    public static final String CFG_FORMATTER_DEFAULT = XLogFormatter.class.getName();
    public static final String CFG_CONSOLE_LEVEL = "me.xuxiaoxiao$xtools-common$log.console.level";
    public static final String CFG_CONSOLE_LEVEL_DEFAULT = "detail";
    public static final String CFG_FILE = "me.xuxiaoxiao$xtools-common$log.file";
    public static final String CFG_FILE_DEFAULT = "xlogger.log";
    public static final String CFG_FILE_APPEND = "me.xuxiaoxiao$xtools-common$log.file.append";
    public static final String CFG_FILE_APPEND_DEFAULT = "true";
    public static final String CFG_FILE_LEVEL = "me.xuxiaoxiao$xtools-common$log.file.level";
    public static final String CFG_FILE_LEVEL_DEFAULT = "warning";
    private final Logger root = Logger.getLogger("xlog");
    private final Map<String, Level> levels = new ConcurrentHashMap<String, Level>();

    public XLoggerImpl() {
        this.root.setUseParentHandlers(false);
        this.defaultHandlers();
    }

    @Override
    public void logE(String tag, String error, Object ... args) {
        Logger logger = this.prepareLogger(tag);
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, XLoggerImpl.buildMsg(null, error, args), tag);
        }
    }

    @Override
    public void logE(String tag, Throwable throwable, String error, Object ... args) {
        Logger logger = this.prepareLogger(tag);
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, XLoggerImpl.buildMsg(throwable, error, args), tag);
        }
    }

    @Override
    public void logW(String tag, String warning, Object ... args) {
        Logger logger = this.prepareLogger(tag);
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, XLoggerImpl.buildMsg(null, warning, args), tag);
        }
    }

    @Override
    public void logW(String tag, Throwable throwable, String warning, Object ... args) {
        Logger logger = this.prepareLogger(tag);
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, XLoggerImpl.buildMsg(throwable, warning, args), tag);
        }
    }

    @Override
    public void logN(String tag, String notice, Object ... args) {
        Logger logger = this.prepareLogger(tag);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, XLoggerImpl.buildMsg(null, notice, args), tag);
        }
    }

    @Override
    public void logN(String tag, Throwable throwable, String notice, Object ... args) {
        Logger logger = this.prepareLogger(tag);
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, XLoggerImpl.buildMsg(throwable, notice, args), tag);
        }
    }

    @Override
    public void logD(String tag, String detail, Object ... args) {
        Logger logger = this.prepareLogger(tag);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, XLoggerImpl.buildMsg(null, detail, args), tag);
        }
    }

    @Override
    public void logD(String tag, Throwable throwable, String detail, Object ... args) {
        Logger logger = this.prepareLogger(tag);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, XLoggerImpl.buildMsg(throwable, detail, args), tag);
        }
    }

    @Override
    public void setLevel(String level) {
        this.root.setLevel(XLoggerImpl.strToLevel(level));
    }

    @Override
    public String getLevel() {
        return XLoggerImpl.levelToStr(this.root.getLevel());
    }

    @Override
    public void setLevel(String tag, String level) {
        if (!XTools.strEmpty(tag)) {
            if (!XTools.strEmpty(level)) {
                this.levels.put(tag, XLoggerImpl.strToLevel(level));
            } else {
                this.levels.remove(tag);
            }
        }
    }

    @Override
    public String getLevel(String tag) {
        return XLoggerImpl.levelToStr(this.levels.get(tag));
    }

    @Override
    public void addHandler(XLogger.Handler handler) {
        this.root.addHandler(new HHandler(handler));
    }

    @Override
    public XLogger.Handler[] getHandlers() {
        Handler[] handlers = this.root.getHandlers();
        ArrayList<XLogger.Handler> handlerList = new ArrayList<XLogger.Handler>(handlers.length);
        for (Handler handler : handlers) {
            if (!(handler instanceof HHandler)) continue;
            handlerList.add(((HHandler)handler).handler);
        }
        return handlerList.toArray(new XLogger.Handler[0]);
    }

    private Logger prepareLogger(String tag) {
        Logger logger = Logger.getLogger("xlog." + tag);
        if (tag.lastIndexOf(46) > 0) {
            logger.setParent(this.prepareLogger(tag.substring(0, tag.lastIndexOf(46))));
        }
        if (this.levels.containsKey(tag)) {
            logger.setLevel(this.levels.get(tag));
        } else {
            logger.setLevel(Level.ALL);
        }
        return logger;
    }

    private static String buildMsg(Throwable throwable, String msg, Object ... args) {
        StringBuilder sbMsg = new StringBuilder(String.format(msg, args));
        if (throwable != null) {
            sbMsg.append('\n').append(throwable.getMessage());
            for (StackTraceElement element : throwable.getStackTrace()) {
                sbMsg.append('\n').append(element.toString());
            }
        }
        return sbMsg.toString();
    }

    private static Level strToLevel(String level) {
        switch (level) {
            case "off": {
                return Level.OFF;
            }
            case "error": {
                return Level.SEVERE;
            }
            case "warning": {
                return Level.WARNING;
            }
            case "notice": {
                return Level.INFO;
            }
        }
        return Level.ALL;
    }

    private static String levelToStr(Level level) {
        if (level.equals(Level.OFF)) {
            return "off";
        }
        if (level.equals(Level.SEVERE)) {
            return "error";
        }
        if (level.equals(Level.WARNING)) {
            return CFG_FILE_LEVEL_DEFAULT;
        }
        if (level.equals(Level.INFO)) {
            return "notice";
        }
        return CFG_CONSOLE_LEVEL_DEFAULT;
    }

    private void defaultHandlers() {
        String handlersStr = XTools.cfgDef(CFG_HANDLERS, CFG_HANDLERS_DEFAULT);
        if (!XTools.strBlank(handlersStr)) {
            for (String handlerClass : handlersStr.split(",")) {
                this.addHandler((XLogger.Handler)XConfigTools.supply(handlerClass.trim()));
            }
        }
    }

    public static class XFileHandler
    implements XLogger.Handler {
        private Handler handler;

        public XFileHandler() {
            try {
                this.handler = new FileHandler(XTools.cfgDef(XLoggerImpl.CFG_FILE, XLoggerImpl.CFG_FILE_DEFAULT).trim(), Boolean.valueOf(XTools.cfgDef(XLoggerImpl.CFG_FILE_APPEND, XLoggerImpl.CFG_FILE_APPEND_DEFAULT).trim()));
                this.handler.setLevel(XLoggerImpl.strToLevel(XTools.cfgDef(XLoggerImpl.CFG_FILE_LEVEL, XLoggerImpl.CFG_FILE_LEVEL_DEFAULT).trim()));
                this.handler.setFormatter((Formatter)XConfigTools.supply(XTools.cfgDef(XLoggerImpl.CFG_FORMATTER, CFG_FORMATTER_DEFAULT).trim()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setLevel(String level) {
            this.handler.setLevel(XLoggerImpl.strToLevel(level));
        }

        @Override
        public String getLevel() {
            return XLoggerImpl.levelToStr(this.handler.getLevel());
        }

        @Override
        public void record(String level, String tag, String msg) {
            LogRecord logRecord = new LogRecord(XLoggerImpl.strToLevel(level), msg);
            logRecord.setParameters(new Object[]{tag});
            this.handler.publish(logRecord);
        }
    }

    public static class XConsoleHandler
    implements XLogger.Handler {
        private Handler handler = new ConsoleHandler();

        public XConsoleHandler() {
            this.handler.setLevel(XLoggerImpl.strToLevel(XTools.cfgDef(XLoggerImpl.CFG_CONSOLE_LEVEL, XLoggerImpl.CFG_CONSOLE_LEVEL_DEFAULT).trim()));
            this.handler.setFormatter((Formatter)XConfigTools.supply(XTools.cfgDef(XLoggerImpl.CFG_FORMATTER, CFG_FORMATTER_DEFAULT).trim()));
        }

        @Override
        public void setLevel(String level) {
            this.handler.setLevel(XLoggerImpl.strToLevel(level));
        }

        @Override
        public String getLevel() {
            return XLoggerImpl.levelToStr(this.handler.getLevel());
        }

        @Override
        public void record(String level, String tag, String msg) {
            LogRecord logRecord = new LogRecord(XLoggerImpl.strToLevel(level), msg);
            logRecord.setParameters(new Object[]{tag});
            this.handler.publish(logRecord);
        }
    }

    private static class HHandler
    extends Handler {
        private final XLogger.Handler handler;

        public HHandler(XLogger.Handler handler) {
            this.handler = handler;
        }

        @Override
        public void publish(LogRecord record) {
            this.handler.record(XLoggerImpl.levelToStr(record.getLevel()), (String)record.getParameters()[0], record.getMessage());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public Level getLevel() {
            return XLoggerImpl.strToLevel(this.handler.getLevel());
        }

        @Override
        public synchronized void setLevel(Level newLevel) throws SecurityException {
            this.handler.setLevel(XLoggerImpl.levelToStr(newLevel));
        }
    }

    public static class XLogFormatter
    extends Formatter {
        private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

        private char levelChar(Level level) {
            if (level.equals(Level.SEVERE)) {
                return 'E';
            }
            if (level.equals(Level.WARNING)) {
                return 'W';
            }
            if (level.equals(Level.INFO)) {
                return 'N';
            }
            return 'D';
        }

        @Override
        public String format(LogRecord record) {
            String time = XTools.dateFormat(TIME_FORMAT, new Date(record.getMillis()));
            String tag = record.getParameters() == null || record.getParameters()[0] == null ? XLoggerImpl.TAG : String.valueOf(record.getParameters()[0]);
            return String.format("%s | %s | %s | %s | %s\n", time, Character.valueOf(this.levelChar(record.getLevel())), Thread.currentThread().getName(), tag, record.getMessage());
        }
    }
}

