/*
 * Decompiled with CFR 0.152.
 */
package me.xuxiaoxiao.xtools.common.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.xuxiaoxiao.xtools.common.XTools;
import me.xuxiaoxiao.xtools.common.time.XHolidayDb;
import me.xuxiaoxiao.xtools.common.time.XLunarDb;

public final class XTimeTools {
    public static final int MONDAY = 0;
    public static final int TUESDAY = 1;
    public static final int WEDNESDAY = 2;
    public static final int THURSDAY = 3;
    public static final int FRIDAY = 4;
    public static final int SATURDAY = 5;
    public static final int SUNDAY = 6;
    public static final int WORKDAY = 1;
    public static final int RESTDAY = 2;
    public static final int HOLIDAY = 3;
    public static final long DAY_MILLIS = 86400000L;
    public static final long WEEK_MILLIS = 604800000L;
    public static final String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_YMD = "yyyy-MM-dd";
    public static final String FORMAT_HMS = "HH:mm:ss";
    public static final String FORMAT_EEEE = "EEEE";
    private static final ThreadLocal<HashMap<String, SimpleDateFormat>> DATE_FORMATS = new ThreadLocal();

    public static String dateFormat(String format, Date date) {
        SimpleDateFormat dateFormat;
        Objects.requireNonNull(format);
        Objects.requireNonNull(date);
        HashMap<String, SimpleDateFormat> formats = DATE_FORMATS.get();
        if (formats == null) {
            formats = new HashMap();
            DATE_FORMATS.set(formats);
        }
        if ((dateFormat = formats.get(format)) == null) {
            dateFormat = new SimpleDateFormat(format);
            formats.put(format, dateFormat);
        }
        return dateFormat.format(date);
    }

    public static Date dateParse(String format, String dateStr) {
        SimpleDateFormat dateFormat;
        Objects.requireNonNull(format);
        Objects.requireNonNull(dateStr);
        HashMap<String, SimpleDateFormat> formats = DATE_FORMATS.get();
        if (formats == null) {
            formats = new HashMap();
            DATE_FORMATS.set(formats);
        }
        if ((dateFormat = formats.get(format)) == null) {
            dateFormat = new SimpleDateFormat(format);
            formats.put(format, dateFormat);
        }
        try {
            return dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(String.format("\u65e5\u671f:%s \u4e0d\u7b26\u5408\u683c\u5f0f:%s", dateStr, format));
        }
    }

    public static int dateType(Date date) {
        Objects.requireNonNull(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5) - 1;
        try {
            Integer[] holidays;
            Integer[] integerArray = holidays = (Integer[])XHolidayDb.class.getDeclaredField("HOLIDAY_" + year).get(null);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int typeMD = integerArray[i];
                if ((month << 8 | day) != (typeMD & 0xFFF)) continue;
                return typeMD >> 12;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return XTimeTools.dateInWeek(date) < 5 ? 1 : 2;
    }

    public static Date date(Date base, int offset) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        return XTimeTools.dateParse(FORMAT_YMD, XTimeTools.dateFormat(FORMAT_YMD, new Date(baseTime + (long)offset * 86400000L)));
    }

    public static Date dateByWeek(Date base, int weekOffset, int dayIndex) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime + (long)weekOffset * 604800000L);
        if (calendar.get(7) == 1) {
            return XTimeTools.date(calendar.getTime(), dayIndex - 6);
        }
        calendar.set(7, 2);
        return XTimeTools.date(calendar.getTime(), dayIndex);
    }

    public static Date dateByMonth(Date base, int monthOffset, int dayIndex) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        calendar.add(2, monthOffset);
        calendar.set(5, dayIndex + 1);
        return XTimeTools.date(calendar.getTime(), 0);
    }

    public static Date dateBySeason(Date base, int seasonOffset, int dayIndex) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        calendar.set(2, (calendar.get(2) / 3 + seasonOffset) * 3);
        calendar.set(5, dayIndex + 1);
        return XTimeTools.date(calendar.getTime(), 0);
    }

    public static Date dateByYear(Date base, int yearOffset, int dayIndex) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        calendar.add(1, yearOffset);
        calendar.set(6, dayIndex + 1);
        return XTimeTools.date(calendar.getTime(), 0);
    }

    public static Date weekByMonth(Date base, int monthOffset, int weekIndex) {
        Date date = XTimeTools.dateByMonth(base, monthOffset, 0);
        while (XTimeTools.dateInWeek(date) != 0) {
            date = new Date(date.getTime() + 86400000L);
        }
        return new Date(date.getTime() + (long)weekIndex * 604800000L);
    }

    public static Date weekBySeason(Date base, int seasonOffset, int weekIndex) {
        Date date = XTimeTools.dateBySeason(base, seasonOffset, 0);
        while (XTimeTools.dateInWeek(date) != 0) {
            date = new Date(date.getTime() + 86400000L);
        }
        return new Date(date.getTime() + (long)weekIndex * 604800000L);
    }

    public static Date weekByYear(Date base, int yearOffset, int weekIndex) {
        Date date = XTimeTools.dateByYear(base, yearOffset, 0);
        while (XTimeTools.dateInWeek(date) != 0) {
            date = new Date(date.getTime() + 86400000L);
        }
        return new Date(date.getTime() + (long)weekIndex * 604800000L);
    }

    public static Date monthBySeason(Date base, int seasonOffset, int monthIndex) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        calendar.set(2, (calendar.get(2) / 3 + seasonOffset) * 3 + monthIndex);
        calendar.set(5, 1);
        return XTimeTools.date(calendar.getTime(), 0);
    }

    public static Date monthByYear(Date base, int yearOffset, int monthIndex) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        calendar.add(1, yearOffset);
        calendar.set(2, monthIndex);
        calendar.set(5, 1);
        return XTimeTools.date(calendar.getTime(), 0);
    }

    public static Date seasonByYear(Date base, int yearOffset, int seasonIndex) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        calendar.add(1, yearOffset);
        calendar.set(2, seasonIndex * 3);
        calendar.set(5, 1);
        return XTimeTools.date(calendar.getTime(), 0);
    }

    public static int dateInWeek(Date base) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        switch (calendar.get(7)) {
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
        }
        return -1;
    }

    public static int dateInMonth(Date base) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        return calendar.get(5) - 1;
    }

    public static int dateInSeason(Date base) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        calendar.set(2, calendar.get(2) / 3 * 3);
        calendar.set(5, 1);
        return (int)((XTimeTools.date(new Date(baseTime), 0).getTime() - XTimeTools.date(calendar.getTime(), 0).getTime()) / 86400000L);
    }

    public static int dateInYear(Date base) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        return calendar.get(6) - 1;
    }

    public static int weekInMonth(Date base) {
        Date weekMonday = XTimeTools.dateByWeek(base, 0, 0);
        Date monthMonday = XTimeTools.dateByMonth(base, 0, 0);
        while (XTimeTools.dateInWeek(monthMonday) != 0) {
            monthMonday = new Date(monthMonday.getTime() + 86400000L);
        }
        if (weekMonday.compareTo(monthMonday) >= 0) {
            return (int)((weekMonday.getTime() - monthMonday.getTime()) / 604800000L);
        }
        Date lastMonthMonday = XTimeTools.dateByMonth(base, -1, 0);
        while (XTimeTools.dateInWeek(lastMonthMonday) != 0) {
            lastMonthMonday = new Date(lastMonthMonday.getTime() + 86400000L);
        }
        return (int)((lastMonthMonday.getTime() - weekMonday.getTime()) / 604800000L);
    }

    public static int weekInSeason(Date base) {
        Date weekMonday = XTimeTools.dateByWeek(base, 0, 0);
        Date seasonMonday = XTimeTools.dateBySeason(base, 0, 0);
        while (XTimeTools.dateInWeek(seasonMonday) != 0) {
            seasonMonday = new Date(seasonMonday.getTime() + 86400000L);
        }
        if (weekMonday.compareTo(seasonMonday) >= 0) {
            return (int)((weekMonday.getTime() - seasonMonday.getTime()) / 604800000L);
        }
        Date lastSeasonMonday = XTimeTools.dateBySeason(base, -1, 0);
        while (XTimeTools.dateInWeek(lastSeasonMonday) != 0) {
            lastSeasonMonday = new Date(lastSeasonMonday.getTime() + 86400000L);
        }
        return (int)((lastSeasonMonday.getTime() - weekMonday.getTime()) / 604800000L);
    }

    public static int weekInYear(Date base) {
        Date weekMonday = XTimeTools.dateByWeek(base, 0, 0);
        Date yearMonday = XTimeTools.dateByYear(base, 0, 0);
        while (XTimeTools.dateInWeek(yearMonday) != 0) {
            yearMonday = new Date(yearMonday.getTime() + 86400000L);
        }
        if (weekMonday.compareTo(yearMonday) >= 0) {
            return (int)((weekMonday.getTime() - yearMonday.getTime()) / 604800000L);
        }
        Date lastYearMonday = XTimeTools.dateByYear(base, -1, 0);
        while (XTimeTools.dateInWeek(lastYearMonday) != 0) {
            lastYearMonday = new Date(lastYearMonday.getTime() + 86400000L);
        }
        return (int)((lastYearMonday.getTime() - weekMonday.getTime()) / 604800000L);
    }

    public static int monthInSeason(Date base) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        return calendar.get(2) - calendar.get(2) / 3 * 3;
    }

    public static int monthInYear(Date base) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        return calendar.get(2);
    }

    public static int seasonInYear(Date base) {
        long baseTime = base != null ? base.getTime() : System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(baseTime);
        return calendar.get(2) / 3;
    }

    public static String solarToLunar(Date solarDate) {
        Date maxDate;
        Date minDate;
        try {
            minDate = ((SimpleDateFormat)XLunarDb.TL_LUNAR.get()).parse("1901-02-19");
            maxDate = ((SimpleDateFormat)XLunarDb.TL_LUNAR.get()).parse("2101-01-29");
        }
        catch (ParseException e) {
            throw new RuntimeException("\u89e3\u6790\u65e5\u671f\u51fa\u9519");
        }
        if (solarDate.before(minDate) || !solarDate.before(maxDate)) {
            throw new IllegalStateException("\u8981\u8f6c\u6362\u7684\u516c\u5386\u8d85\u51fa\u8303\u56f4");
        }
        int dayBetween = (int)((solarDate.getTime() - minDate.getTime()) / 86400000L);
        int lunarYear = 0;
        for (int i = 1901; i < 2101; ++i) {
            int yearDays = XLunarDb.lunarYearDays(i);
            if (dayBetween - yearDays < 0) {
                lunarYear = i;
                break;
            }
            dayBetween -= yearDays;
        }
        int lunarMonth = 0;
        boolean lunarLeap = false;
        int leapMonth = XLunarDb.LUNAR_INFO[lunarYear - 1901] & 0xF;
        for (int i = 1; i <= 12; ++i) {
            int monthDays = XLunarDb.lunarMonthDays(lunarYear, i, false);
            if (dayBetween - monthDays < 0) {
                lunarMonth = i;
                lunarLeap = false;
                break;
            }
            dayBetween -= monthDays;
            if (i != leapMonth) continue;
            monthDays = XLunarDb.lunarMonthDays(lunarYear, leapMonth, true);
            if (dayBetween - monthDays < 0) {
                lunarMonth = leapMonth;
                lunarLeap = true;
                break;
            }
            dayBetween -= monthDays;
        }
        int lunarDay = dayBetween + 1;
        StringBuilder sbLunar = new StringBuilder();
        sbLunar.append(lunarYear).append("\u5e74");
        if (lunarLeap) {
            sbLunar.append("\u95f0");
        }
        sbLunar.append(XLunarDb.LUNAR_MONTH[lunarMonth - 1]).append("\u6708");
        if (lunarDay == 10) {
            sbLunar.append("\u521d\u5341");
        } else if (lunarDay == 20) {
            sbLunar.append("\u4e8c\u5341");
        } else if (lunarDay == 30) {
            sbLunar.append("\u4e09\u5341");
        } else {
            switch (lunarDay / 10) {
                case 0: {
                    sbLunar.append("\u521d");
                    break;
                }
                case 1: {
                    sbLunar.append("\u5341");
                    break;
                }
                default: {
                    sbLunar.append("\u5eff");
                }
            }
            sbLunar.append(XLunarDb.LUNAR_DAY[lunarDay % 10 - 1]);
        }
        return sbLunar.toString();
    }

    public static Date lunarToSolar(String lunarDate) {
        int i;
        int lunarDay;
        Matcher matcher = Pattern.compile("((19|20|21)\\d{2})\u5e74(\u95f0)?([\u6b63\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u51ac\u814a])\u6708(([\u521d\u5341\u5eff])([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d])|\u521d\u5341|\u4e8c\u5341|\u4e09\u5341)").matcher(lunarDate);
        if (!matcher.matches()) {
            throw new RuntimeException("\u519c\u5386\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u4f8b1\uff1a1992\u5e74\u516b\u6708\u521d\u516d\u3002\u4f8b2\uff1a2033\u5e74\u95f0\u51ac\u6708\u5eff\u516b\u3002");
        }
        String strYear = matcher.group(1);
        String strMonth = matcher.group(4);
        String strDay = matcher.group(5);
        String strLeap = matcher.group(3);
        int lunarYear = Integer.valueOf(strYear);
        int lunarMonth = 0;
        for (int i2 = 0; i2 < XLunarDb.LUNAR_MONTH.length; ++i2) {
            if (!XLunarDb.LUNAR_MONTH[i2].equals(strMonth)) continue;
            lunarMonth = i2 + 1;
            break;
        }
        if ("\u521d\u5341".equals(strDay)) {
            lunarDay = 10;
        } else if ("\u4e8c\u5341".equals(strDay)) {
            lunarDay = 20;
        } else if ("\u4e09\u5341".equals(strDay)) {
            lunarDay = 30;
        } else {
            String strTen = String.valueOf(strDay.charAt(0));
            String strOne = String.valueOf(strDay.charAt(1));
            switch (strTen) {
                case "\u521d": {
                    lunarDay = 0;
                    break;
                }
                case "\u5341": {
                    lunarDay = 10;
                    break;
                }
                default: {
                    lunarDay = 20;
                }
            }
            for (i = 0; i < XLunarDb.LUNAR_DAY.length; ++i) {
                if (!XLunarDb.LUNAR_DAY[i].equals(strOne)) continue;
                lunarDay = lunarDay + i + 1;
                break;
            }
        }
        boolean lunarLeap = !XTools.strEmpty(strLeap);
        XLunarDb.checkLunarDate(lunarYear, lunarMonth, lunarDay, lunarLeap);
        int dayBetween = 0;
        for (i = 1901; i < lunarYear; ++i) {
            dayBetween += XLunarDb.lunarYearDays(i);
        }
        int leapMonth = XLunarDb.LUNAR_INFO[lunarYear - 1901] & 0xF;
        for (int i3 = 1; i3 < lunarMonth; ++i3) {
            dayBetween += XLunarDb.lunarMonthDays(lunarYear, i3, false);
            if (i3 != leapMonth) continue;
            dayBetween += XLunarDb.lunarMonthDays(lunarYear, leapMonth, true);
        }
        if (leapMonth == lunarMonth && lunarLeap) {
            dayBetween += XLunarDb.lunarMonthDays(lunarYear, leapMonth, false);
        }
        dayBetween += lunarDay - 1;
        try {
            Date minDate = ((SimpleDateFormat)XLunarDb.TL_LUNAR.get()).parse("1901-02-19");
            System.out.println(minDate);
            System.out.println(minDate.getTime());
            return new Date(minDate.getTime() + (long)dayBetween * 86400000L);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u89e3\u6790\u65e5\u671f\u51fa\u9519");
        }
    }
}

