/*
 * Decompiled with CFR 0.152.
 */
package me.yanaga.querydsl.args.core.single;

import com.google.common.base.Preconditions;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.SimpleExpression;
import java.io.Serializable;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.yanaga.querydsl.args.core.Arguments;

public abstract class AbstractSingleArgument<T extends SimpleExpression<V>, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final V value;

    protected AbstractSingleArgument(V value) {
        this.value = value;
    }

    public void append(BooleanBuilder builder, Function<V, BooleanExpression> function) {
        Preconditions.checkNotNull((Object)builder);
        Preconditions.checkNotNull(function);
        if (this.value != null) {
            builder.and((Predicate)function.apply(this.value));
        }
    }

    protected void append(BooleanBuilder builder, BiFunction<T, V, BooleanExpression> operation, T path, T ... paths) {
        Arguments.append((BooleanBuilder)builder, this.value, operation, path, paths);
    }

    protected void append(BooleanBuilder builder, T path, T ... paths) {
        Arguments.append((BooleanBuilder)builder, this.value, this.getDefaultOperation(), path, paths);
    }

    BiFunction<T, V, BooleanExpression> getDefaultOperation() {
        return SimpleExpression::eq;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "";
    }
}

