/*
 * Decompiled with CFR 0.152.
 */
package me.yanaga.querydsl.args.jsf;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import me.yanaga.querydsl.args.core.single.SingleBigDecimalArgument;

@FacesConverter(forClass=SingleBigDecimalArgument.class)
public class SingleBigDecimalArgumentConverter
implements Converter {
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            try {
                return SingleBigDecimalArgument.of((BigDecimal)new BigDecimal(value.trim()));
            }
            catch (NumberFormatException ex) {
                throw new ConverterException("Invalid Number.", (Throwable)ex);
            }
        }
        return SingleBigDecimalArgument.of();
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value != null) {
            return value.toString();
        }
        return null;
    }
}

