/*
 * Decompiled with CFR 0.152.
 */
package me.yanaga.querydsl.args.jsf;

import com.google.common.base.Strings;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import me.yanaga.querydsl.args.core.single.SingleLocalDateArgument;
import me.yanaga.querydsl.args.jsf.AbstractTemporalArgumentConverter;

@FacesConverter(forClass=SingleLocalDateArgument.class)
public class SingleLocalDateArgumentConverter
extends AbstractTemporalArgumentConverter {
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        DateTimeFormatter pattern = this.getPattern(component);
        if (!Strings.isNullOrEmpty((String)value)) {
            try {
                return SingleLocalDateArgument.of((LocalDate)LocalDate.parse(value.trim(), pattern));
            }
            catch (DateTimeParseException ex) {
                throw new ConverterException("Invalid Date", (Throwable)ex);
            }
        }
        return SingleLocalDateArgument.of();
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value != null) {
            DateTimeFormatter pattern = this.getPattern(component);
            SingleLocalDateArgument argument = (SingleLocalDateArgument)value;
            return argument.format(pattern);
        }
        return null;
    }

    @Override
    DateTimeFormatter getDefaultPattern() {
        return DateTimeFormatter.ISO_LOCAL_DATE;
    }
}

