/*
 * Decompiled with CFR 0.152.
 */
package me.yanaga.querydsl.args.jsf;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import me.yanaga.querydsl.args.core.single.SingleLocalDateTimeArgument;
import me.yanaga.querydsl.args.jsf.AbstractTemporalArgumentConverter;

@FacesConverter(forClass=SingleLocalDateTimeArgument.class)
public class SingleLocalDateTimeArgumentConverter
extends AbstractTemporalArgumentConverter {
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        DateTimeFormatter pattern = this.getPattern(component);
        if (!Strings.isNullOrEmpty((String)value)) {
            try {
                return SingleLocalDateTimeArgument.of((LocalDateTime)LocalDateTime.parse(value.trim(), pattern));
            }
            catch (DateTimeParseException ex) {
                throw new ConverterException("Invalid Date", (Throwable)ex);
            }
        }
        return SingleLocalDateTimeArgument.of();
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value != null) {
            DateTimeFormatter pattern = this.getPattern(component);
            SingleLocalDateTimeArgument argument = (SingleLocalDateTimeArgument)value;
            return argument.format(pattern);
        }
        return null;
    }

    @Override
    DateTimeFormatter getDefaultPattern() {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    }
}

