
package com.zing.zalo.zalosdk.oauth;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.hardware.SensorManager;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.Gravity;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.zing.zalo.zalosdk.common.Constant;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.oauth.dialog.PaymentProcessingDialog;

public class WebDialog extends Dialog {
    public static final String EXTRA_OAUTH_CODE = "oauthCodeaa";
	public static final String EXTRA_QUERY = "querystring";
	public static final String EXTRA_REQUEST_BODY = "bodyrequest";
	 private final static String UTF8 = "UTF-8";
    private static final String LOG_TAG = "WebDialog";
    private static final String DISPLAY_TOUCH = "touch";
    private static final int API_EC_DIALOG_CANCEL = 4201;
    static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;

    // width below which there are no extra margins
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    // width beyond which we're always using the MIN_SCALE_FACTOR
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    // height below which there are no extra margins
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    // height beyond which we're always using the MIN_SCALE_FACTOR
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;

    // the minimum scaling factor for the web dialog (50% of screen size)
    private static final double MIN_SCALE_FACTOR = 0.5;
    // translucent border around the webview
    private static final int BACKGROUND_GRAY = 0xCC000000;
    private static final int BACKGROUND_WHITE = 0xFFFFFF;
    
    public static final int DEFAULT_THEME = android.R.style.Theme_Translucent_NoTitleBar;

    private String url;
    private String query;
    private String queryBody;
    private String code;
    private OnCompleteListener onCompleteListener;
    ZaloPluginCallback zFeedCallback;
    private WebView webView;
    private PaymentProcessingDialog spinner;
    private ImageView crossImageView;
    private FrameLayout contentFrameLayout;
    private boolean listenerCalled = false;
    private boolean isDetached = false;
    private boolean isDismissed = false;

    //for cookie
    CookieSyncManager cookieSyncManager;
    CookieManager cookieManager;
    private static final Pattern WZUIN = Pattern.compile("(wzuin=[\\d\\w]*)");
    /**
     * Interface that implements a listener to be called when the user's interaction with the
     * dialog completes, whether because the dialog finished successfully, or it was cancelled,
     * or an error was encountered.
     */
    public interface OnCompleteListener {
        /**
         * Called when the dialog completes.
         *
         * @param values on success, contains the values returned by the dialog
         * @param error  on an error, contains an exception describing the error
         */
        void onComplete(Bundle values);
    }

    /**
     * Constructor which can be used to display a dialog with an already-constructed URL.
     *
     * @param context the context to use to display the dialog
     * @param url     the URL of the Web Dialog to display; no validation is done on this URL, but it should
     *                be a valid URL pointing to a Facebook Web Dialog
     */
    public WebDialog(Context context, String url) {
        this(context, url, DEFAULT_THEME);
    }

    /**
     * Constructor which can be used to display a dialog with an already-constructed URL and a custom theme.
     *
     * @param context the context to use to display the dialog
     * @param url     the URL of the Web Dialog to display; no validation is done on this URL, but it should
     *                be a valid URL pointing to a Facebook Web Dialog
     * @param theme   identifier of a theme to pass to the Dialog class
     */
    public WebDialog(Context context, String url, int theme) {
        super(context, theme);
        this.url = url;
    }

    /**
     * Constructor which will construct the URL of the Web dialog based on the specified parameters.
     *
     * @param context    the context to use to display the dialog
     * @param action     the portion of the dialog URL following "dialog/"
     * @param parameters parameters which will be included as part of the URL
     * @param theme      identifier of a theme to pass to the Dialog class
     * @param listener the listener to notify, or null if no notification is desired
     */
    public WebDialog(Context context, String action, Bundle parameters, int theme, OnCompleteListener listener) {
        super(context, theme);

        if (parameters == null) {
            parameters = new Bundle();
        }

        
        this.query = parameters.getString(EXTRA_QUERY);
        this.queryBody = parameters.getString(EXTRA_REQUEST_BODY);
        this.query = query == null ? "" : query;
        this.code = parameters.getString(EXTRA_OAUTH_CODE);
        this.url = Constant.ZPLUGIN_FEED_URL + "?" + this.query;

        onCompleteListener = listener;
//        Log.i("debuglog", "feed: url: " + url);
//        Log.i("debuglog", "feed: queryBody post data: " + queryBody);
    }

    /**
     * Sets the listener which will be notified when the dialog finishes.
     *
     * @param verticalListener the listener to notify, or null if no notification is desired
     */
//    public void setOnCompleteListener(OnCompleteListener listener) {
//        onCompleteListener = listener;
//    }
    
    public void setFeedCallBackListener(ZaloPluginCallback callback){
    	zFeedCallback = callback;
    }
    
    
    /**
     * Gets the listener which will be notified when the dialog finishes.
     *
     * @return the listener, or null if none has been specified
     */
    public OnCompleteListener getOnCompleteListener() {
        return onCompleteListener;
    }

    @Override
    public void dismiss() {
        if (isDismissed) {
            // Some paths may cause dismiss() to be called recursively. Break the loop here.
            return;
        }
        isDismissed = true;

        if (myOrientationEventListener != null) myOrientationEventListener.disable();
        
        // If dismiss() was called without sending a result to the listener, let's default to a "cancel" result.
        // This will be the case when the user taps the OS-back-button, or the cross-image, or outside the loading
        // interstitial.
        if (!listenerCalled) {
            sendCancelToListener();
        }

        if (webView != null) {
            webView.stopLoading();
        }
        if (!isDetached) {
            if (spinner.isShowing()) {
                spinner.dismiss();
            }
            super.dismiss();
        }
    }

    @Override
    public void onDetachedFromWindow() {
        isDetached = true;
        super.onDetachedFromWindow();
    }

    @Override
    public void onAttachedToWindow() {
        isDetached = false;
        super.onAttachedToWindow();
    }

    int oldWidth = 0;
    OrientationEventListener myOrientationEventListener;
    
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        spinner = new PaymentProcessingDialog(getContext(), new PaymentProcessingDialog.OnCloseListener() {
            @Override
            public void onClose() {

            }
        });
        spinner.requestWindowFeature(Window.FEATURE_NO_TITLE);
//        spinner.setMessage("Loading");
        spinner.setOnCancelListener(new OnCancelListener() {
            @Override
            public void onCancel(DialogInterface dialogInterface) {
                dismiss();

            }
        });

        requestWindowFeature(Window.FEATURE_NO_TITLE);
        
        contentFrameLayout = new FrameLayout(getContext());

        // First calculate how big the frame layout should be
        calculateSize();
        getWindow().setGravity(Gravity.CENTER);

        // resize the dialog if the soft keyboard comes up
        getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);

        /* Create the 'x' image, but don't add to the contentFrameLayout layout yet
         * at this point, we only need to know its drawable width and height
         * to place the webview
         */
        createCrossImage();

        /* Now we know 'x' drawable width and height,
         * layout the webview and add it the contentFrameLayout layout
         */
        int crossWidth = crossImageView.getDrawable().getIntrinsicWidth();

//        setUpWebView(crossWidth / 2 + 1);
        setUpWebView(0);
        /* Finally add the 'x' image to the contentFrameLayout layout and
        * add contentFrameLayout to the Dialog view
        */
        ViewGroup.LayoutParams param = new ViewGroup.LayoutParams(
                ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        contentFrameLayout.addView(crossImageView, param);

        setContentView(contentFrameLayout);
        crossImageView.bringToFront();
        
        myOrientationEventListener = new OrientationEventListener(getContext(), SensorManager.SENSOR_DELAY_NORMAL) {
            public void onOrientationChanged(int arg0) {
            	if ( arg0 > 350 || arg0<10){
            		//portrail
            		updateLayout();
            	} else if (arg0 < 100 && arg0 > 80){
            		//landscape
            		updateLayout();
            	} else if (arg0 >170 && arg0 < 190){
            		//portrail
            		updateLayout();
            	} else if (arg0 > 260 && arg0 < 280){
            		//landscape
            		updateLayout();
            	}
            }
        };
        if (myOrientationEventListener.canDetectOrientation()) myOrientationEventListener.enable();
        else myOrientationEventListener = null; // Orientation detection not supported
        
        this.setOnCancelListener(new OnCancelListener() {
			@Override
			public void onCancel(DialogInterface dialog) {

			}
		});
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        lp.dimAmount = 0.7f;
    }

   private void updateLayout(){
	   if (oldWidth != getScreenWidth()){
		   calculateSize();
   		   oldWidth = getScreenWidth();
   	   }
   }


    protected boolean isListenerCalled() {
        return listenerCalled;
    }

    protected WebView getWebView() {
        return webView;
    }

    private int getScreenWidth(){
    	 WindowManager wm = (WindowManager) getContext().getSystemService(Context.WINDOW_SERVICE);
         Display display = wm.getDefaultDisplay();
         DisplayMetrics metrics = new DisplayMetrics();
         display.getMetrics(metrics);
         return metrics.widthPixels;
    }
    
    private void calculateSize() {
        WindowManager wm = (WindowManager) getContext().getSystemService(Context.WINDOW_SERVICE);
        Display display = wm.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        // always use the portrait dimensions to do the scaling calculations so we always get a portrait shaped
        // web dialog
        int width = metrics.widthPixels;//metrics.widthPixels < metrics.heightPixels ? metrics.widthPixels : metrics.heightPixels;
        int height = metrics.heightPixels;//metrics.widthPixels < metrics.heightPixels ? metrics.heightPixels : metrics.widthPixels;
        int dialogWidth = width;//width*4/5;
        int dialogHeight = height;//height*4/5;
        if (Utilities.isTablet(getContext())){
        	dialogHeight = dialogHeight * 2/3;
        	if (Utilities.isPortait(getContext())){
        		dialogWidth = dialogWidth * 2/3;
        		if (dialogWidth < 300){
        			dialogWidth = 300;
        		}
        		if (dialogHeight < 400){
        			dialogHeight = 400;
        		}
        	} else {
        		dialogWidth = dialogWidth * 1/2;
        		if (dialogWidth < 400){
        			dialogWidth = 400;
        		}
        		if (dialogHeight < 300){
        			dialogHeight = 300;
        		}
        	}
        	getWindow().setLayout(dialogWidth, dialogHeight);
        } else {
            getWindow().setLayout(dialogWidth, dialogHeight-80);
//        	getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        }
    }

    /**
     * Returns a scaled size (either width or height) based on the parameters passed.
     * @param screenSize a pixel dimension of the screen (either width or height)
     * @param density density of the screen
     * @param noPaddingSize the size at which there's no padding for the dialog
     * @param maxPaddingSize the size at which to apply maximum padding for the dialog
     * @return a scaled size.
     */
    private int getScaledSize(int screenSize, float density, int noPaddingSize, int maxPaddingSize) {
        int scaledSize = (int) ((float) screenSize / density);
        double scaleFactor;
        if (scaledSize <= noPaddingSize) {
            scaleFactor = 1.0;
        } else if (scaledSize >= maxPaddingSize) {
            scaleFactor = MIN_SCALE_FACTOR;
        } else {
            // between the noPadding and maxPadding widths, we take a linear reduction to go from 100%
            // of screen size down to MIN_SCALE_FACTOR
            scaleFactor = MIN_SCALE_FACTOR +
                    ((double) (maxPaddingSize - scaledSize))
                            / ((double) (maxPaddingSize - noPaddingSize))
                            * (1.0 - MIN_SCALE_FACTOR);
        }
        return (int) (screenSize * scaleFactor);
    }

    protected void sendSuccessToListener(Bundle values) {
        if (onCompleteListener != null && !listenerCalled) {
            listenerCalled = true;
            onCompleteListener.onComplete(values);

            dismiss();
        }
    }

    protected void sendErrorToListener(Throwable error) {
        if (onCompleteListener != null && !listenerCalled) {
            listenerCalled = true;
            onCompleteListener.onComplete(null);
            dismiss();
        }
    }

    protected void sendCancelToListener() {
        sendErrorToListener(null);
    }

    private void createCrossImage() {
        crossImageView = new ImageView(getContext());
        // Dismiss the dialog when user click on the 'x'
        crossImageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();

            }
        });
        Drawable crossDrawable = getContext().getResources().getDrawable(R.drawable.ic_close_web);
        crossImageView.setImageDrawable(crossDrawable);
        /* 'x' should not be visible while webview is loading
         * make it visible only after webview has fully loaded
         */
        crossImageView.setVisibility(View.INVISIBLE);
        crossImageView.setPadding(convertDpToPixel(7, getContext()), convertDpToPixel(7, getContext()), 0, 0);
    }

    public static int convertDpToPixel(float dp, Context context){
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * (metrics.densityDpi / 160f);
        return (int)px;
    }

    private void setupCookie() {
        cookieSyncManager = CookieSyncManager.createInstance(getContext());
        cookieManager = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.setAcceptThirdPartyCookies(webView, true);
        }else {
            cookieManager.setAcceptCookie(true);
        }
        String baseUrl = "https://plugin.zaloapp.com";
        String cookies = cookieManager.getCookie(baseUrl);
        Log.i("debuglog", "cookie: " + cookies);
//        if(cookies != null) {
//            Matcher matcher = WZUIN.matcher(cookies);
//            if(matcher.find()) {
//                String wzuin = matcher.group(1);
                cookieManager.removeAllCookie();
//                cookieManager.setCookie(baseUrl, wzuin);
                cookieManager.setCookie(baseUrl, "code="+code);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    cookieManager.flush();
                } else {
                    cookieSyncManager.sync();
                }
				Log.i("debuglog", "set cookie: " + "code="+code);
//            }
//        }


        cookies = cookieManager.getCookie(baseUrl);
        Log.i("debuglog", "cookies: " + cookies);
    }
    
    @SuppressLint("SetJavaScriptEnabled")
    private void setUpWebView(int margin) {
        LinearLayout webViewContainer = new LinearLayout(getContext());
        webView = new WebView(getContext()) {
            /* Prevent NPE on Motorola 2.2 devices
             * See https://groups.google.com/forum/?fromgroups=#!topic/android-developers/ktbwY2gtLKQ
             */
            @Override
            public void onWindowFocusChanged(boolean hasWindowFocus) {
                try {
                    super.onWindowFocusChanged(hasWindowFocus);
                } catch (NullPointerException e) {
                }
            }
        };
        webView.setVerticalScrollBarEnabled(false);
        webView.setHorizontalScrollBarEnabled(false);
        webView.setWebViewClient(new DialogWebViewClient());
        webView.getSettings().setJavaScriptEnabled(true);
        setupCookie();
        webView.postUrl(url, queryBody.getBytes());
//        Log.i("debuglog", "query:" + query);
//        Log.i("debuglog", "queryBody:" + queryBody);
        webView.setLayoutParams(new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.MATCH_PARENT));
        webView.setVisibility(View.INVISIBLE);
        webView.getSettings().setSavePassword(false);
        webView.getSettings().setSaveFormData(false);
		webView.getSettings().setDomStorageEnabled(true);
        webView.getSettings().setDatabaseEnabled(true);
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {
        	String databasePath = getContext().getDir("database", Context.MODE_PRIVATE).getPath(); 
        	webView.getSettings().setDatabasePath(databasePath);
        }
        webViewContainer.setPadding(margin, margin, margin, margin);
        webViewContainer.addView(webView);
        webViewContainer.setBackgroundColor(BACKGROUND_WHITE);
        contentFrameLayout.addView(webViewContainer);
    }

    private class DialogWebViewClient extends WebViewClient {
        @Override
        @SuppressWarnings("deprecation")
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
//            Utility.logd(LOG_TAG, "Redirect URL: " + url);
//            if (url.startsWith(WebDialog.this.expectedRedirectUrl)) {
//                Bundle values = parseResponseUri(url);
//
//                String error = values.getString("error");
//                if (error == null) {
//                    error = values.getString("error_type");
//                }
//
//                String errorMessage = values.getString("error_msg");
//                if (errorMessage == null) {
//                    errorMessage = values.getString("error_description");
//                }
//                String errorCodeString = values.getString("error_code");
//                int errorCode = FacebookRequestError.INVALID_ERROR_CODE;
//                if (!Utility.isNullOrEmpty(errorCodeString)) {
//                    try {
//                        errorCode = Integer.parseInt(errorCodeString);
//                    } catch (NumberFormatException ex) {
//                        errorCode = FacebookRequestError.INVALID_ERROR_CODE;
//                    }
//                }
//
//                if (Utility.isNullOrEmpty(error) && Utility
//                        .isNullOrEmpty(errorMessage) && errorCode == FacebookRequestError.INVALID_ERROR_CODE) {
//                    sendSuccessToListener(values);
//                } else if (error != null && (error.equals("access_denied") ||
//                        error.equals("OAuthAccessDeniedException"))) {
//                    sendCancelToListener();
//                } else if (errorCode == API_EC_DIALOG_CANCEL) {
//                    sendCancelToListener();
//                } else {
//                    FacebookRequestError requestError = new FacebookRequestError(errorCode, error, errorMessage);
//                    sendErrorToListener(new FacebookServiceException(requestError, errorMessage));
//                }
//                return true;
//            } else if (url.startsWith(WebDialog.CANCEL_URI)) {
//                sendCancelToListener();
//                return true;
//            } else if (url.contains(DISPLAY_TOUCH)) {
//                return false;
//            }
//            // launch non-dialog URLs in a full browser
//            getContext().startActivity(
//                    new Intent(Intent.ACTION_VIEW, Uri.parse(url)));
//            return true;
        	return super.shouldOverrideUrlLoading(view, url);
        }

        @Override
        public void onReceivedError(WebView view, int errorCode,
                String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            sendErrorToListener(null);
        }

        @Override
        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                super.onReceivedSslError(view, handler, error);
                handler.cancel();
                sendErrorToListener(null);
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (!isDetached) {
                spinner.show();
            }
//            android.util.Log.i("debuglog", "share webview: onPageStarted: " + url);
            if (url.contains(Constant.ZPLUGIN_FEED_URL_CALLBACK)) {
				view.stopLoading();
//				Log.i("debuglog", "00000");
				if (zFeedCallback != null) {
//					Log.i("debuglog", "11111");
//					- error_code
//					- error_message
//					- result_data
					  Uri u = Uri.parse(url);
				      Bundle b = parseUrlQueryString(u.getQuery());
				      
				      boolean isSuccess = false;
				      int error_code = 0;
				      String error_msg = "";
				      String data;
				      
				      String strErrorCode = b.getString("error_code");
				      if (!TextUtils.isEmpty(strErrorCode)){
				    	  try{
				    		  error_code = Integer.parseInt(strErrorCode);
				    	  }
				    	  catch(Exception ex){
				    		  error_code = 0;
				    	  }
				      }
				      if (error_code == 0){
				    	  isSuccess = true;
				      }
				      
				      error_msg = b.getString("error_message");
				      data = b.getString("result_data");
//				      Log.i("debuglog", "222222");
					  zFeedCallback.onResult(isSuccess, error_code, error_msg, data);
				}
			}
        }

        public Bundle parseUrlQueryString(String queryString) {
            Bundle params = new Bundle();
            if (!TextUtils.isEmpty(queryString)) {
                String array[] = queryString.split("&");
                for (String parameter : array) {
                    String keyValuePair[] = parameter.split("=");

                    try {
                        if (keyValuePair.length == 2) {
                            params.putString(
                                    URLDecoder.decode(keyValuePair[0], UTF8),
                                    URLDecoder.decode(keyValuePair[1], UTF8));
                        } else if (keyValuePair.length == 1) {
                            params.putString(
                                    URLDecoder.decode(keyValuePair[0], UTF8),
                                    "");
                        }
                    } catch (UnsupportedEncodingException e) {
                        
                    }
                }
            }
            return params;
        }
        
        @Override
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
//            Log.i("debuglog", "---onPageFinished : "+ url);
            if (!isDetached) {
                spinner.dismiss();
            }
            /*
             * Once web view is fully loaded, set the contentFrameLayout background to be transparent
             * and make visible the 'x' image.
             */
            contentFrameLayout.setBackgroundColor(Color.TRANSPARENT);
            webView.setVisibility(View.VISIBLE);
            crossImageView.setVisibility(View.VISIBLE);
        }
    }

    private static class BuilderBase<CONCRETE extends BuilderBase<?>> {
        private Context context;
        private String applicationId;
        private String action;
        private int theme = DEFAULT_THEME;
        private OnCompleteListener listener;
        private Bundle parameters;

        protected BuilderBase(Context context, String action) {
//            Session activeSession = Session.getActiveSession();
//            if (activeSession != null && activeSession.isOpened()) {
//                this.session = activeSession;
//            } else {
//                String applicationId = Utility.getMetadataApplicationId(context);
//                if (applicationId != null) {
//                    this.applicationId = applicationId;
//                } else {
//                    throw new FacebookException("Attempted to create a builder without an open" +
//                            " Active Session or a valid default Application ID.");
//                }
//            }
            finishInit(context, action, null);
        }

        protected BuilderBase(Context context, /*Session session, */String action, Bundle parameters) {
//            Validate.notNull(session, "session");
//            if (!session.isOpened()) {
//                throw new FacebookException("Attempted to use a Session that was not open.");
//            }
//            this.session = session;

            finishInit(context, action, parameters);
        }

        protected BuilderBase(Context context, String applicationId, String action, Bundle parameters) {
//            if (applicationId == null) {
//                applicationId = Utility.getMetadataApplicationId(context);
//            }
//            Validate.notNullOrEmpty(applicationId, "applicationId");
//            this.applicationId = applicationId;

            finishInit(context, action, parameters);
        }

        /**
         * Sets a theme identifier which will be passed to the underlying Dialog.
         *
         * @param theme a theme identifier which will be passed to the Dialog class
         * @return the builder
         */
        public CONCRETE setTheme(int theme) {
            this.theme = theme;
            @SuppressWarnings("unchecked")
            CONCRETE result = (CONCRETE) this;
            return result;
        }

        /**
         * Sets the listener which will be notified when the dialog finishes.
         *
         * @param listener the listener to notify, or null if no notification is desired
         * @return the builder
         */
        public CONCRETE setOnCompleteListener(OnCompleteListener listener) {
            this.listener = listener;
            @SuppressWarnings("unchecked")
            CONCRETE result = (CONCRETE) this;
            return result;
        }

        /**
         * Constructs a WebDialog using the parameters provided. The dialog is not shown,
         * but is ready to be shown by calling Dialog.show().
         *
         * @return the WebDialog
         */
        public WebDialog build() {
//            if (session != null && session.isOpened()) {
//                parameters.putString(ServerProtocol.DIALOG_PARAM_APP_ID, session.getApplicationId());
//                parameters.putString(ServerProtocol.DIALOG_PARAM_ACCESS_TOKEN, session.getAccessToken());
//            } else {
//                parameters.putString(ServerProtocol.DIALOG_PARAM_APP_ID, applicationId);
//            }

            return new WebDialog(context, action, parameters, theme, listener);
        }

        protected String getApplicationId() {
            return applicationId;
        }

        protected Context getContext() {
            return context;
        }

        protected int getTheme() {
            return theme;
        }

        protected Bundle getParameters() {
            return parameters;
        }

        protected WebDialog.OnCompleteListener getListener() {
            return listener;
        }

        private void finishInit(Context context, String action, Bundle parameters) {
            this.context = context;
            this.action = action;
            if (parameters != null) {
                this.parameters = parameters;
            } else {
                this.parameters = new Bundle();
            }
        }
    }

    /**
     * Provides a builder that allows construction of an arbitrary Facebook web dialog.
     */
    public static class Builder extends BuilderBase<Builder> {
        /**
         * Constructor that builds a dialog using either the active session, or the application
         * id specified in the application/meta-data.
         *
         * @param context the Context within which the dialog will be shown.
         * @param action the portion of the dialog URL following www.facebook.com/dialog/.
         *               See https://developers.facebook.com/docs/reference/dialogs/ for details.
         */
        public Builder(Context context, String action) {
            super(context, action);
        }

        /**
         * Constructor that builds a dialog for an authenticated user.
         *
         * @param context the Context within which the dialog will be shown.
         * @param session the Session representing an authenticating user to use for
         *                showing the dialog; must not be null, and must be opened.
         * @param action the portion of the dialog URL following www.facebook.com/dialog/.
         *               See https://developers.facebook.com/docs/reference/dialogs/ for details.
         * @param parameters a Bundle containing parameters to pass as part of the URL.
         */
        public Builder(Context context, /*Session session, */String action, Bundle parameters) {
            super(context, /*session, */action, parameters);
        }

        /**
         * Constructor that builds a dialog without an authenticated user.
         *
         * @param context the Context within which the dialog will be shown.
         * @param applicationId the application ID to be included in the dialog URL.
         * @param action the portion of the dialog URL following www.facebook.com/dialog/.
         *               See https://developers.facebook.com/docs/reference/dialogs/ for details.
         * @param parameters a Bundle containing parameters to pass as part of the URL.
         */
        public Builder(Context context, String applicationId, String action, Bundle parameters) {
            super(context, applicationId, action, parameters);
        }
    }

    /**
     * Provides a builder that allows construction of the parameters for showing
     * the <a href="https://developers.facebook.com/docs/reference/dialogs/feed">Feed Dialog</a>.
     */
    public static class FeedDialogBuilder extends BuilderBase<FeedDialogBuilder> {
        private static final String FEED_DIALOG = "feed";
        private static final String FROM_PARAM = "from";
        private static final String TO_PARAM = "to";
        private static final String LINK_PARAM = "link";
        private static final String PICTURE_PARAM = "picture";
        private static final String SOURCE_PARAM = "source";
        private static final String NAME_PARAM = "name";
        private static final String CAPTION_PARAM = "caption";
        private static final String DESCRIPTION_PARAM = "description";

        /**
         * Constructor that builds a Feed Dialog using either the active session, or the application
         * ID specified in the application/meta-data.
         *
         * @param context the Context within which the dialog will be shown.
         */
        public FeedDialogBuilder(Context context) {
            super(context, FEED_DIALOG);
        }

        /**
         * Constructor that builds a Feed Dialog using the provided session.
         *
         * @param context the Context within which the dialog will be shown.
         * @param session the Session representing an authenticating user to use for
         *                showing the dialog; must not be null, and must be opened.
         */
//        public FeedDialogBuilder(Context context/*, Session session*/) {
//            super(context, session, FEED_DIALOG, null);
//        }

        /**
         * Constructor that builds a Feed Dialog using the provided session and parameters.
         *
         * @param context    the Context within which the dialog will be shown.
//         * @param session    the Session representing an authenticating user to use for
//         *                   showing the dialog; must not be null, and must be opened.
         * @param parameters a Bundle containing parameters to pass as part of the
         *                   dialog URL. No validation is done on these parameters; it is
         *                   the caller's responsibility to ensure they are valid. For more information,
         *                   see <a href="https://developers.facebook.com/docs/reference/dialogs/feed/">
         *                   https://developers.facebook.com/docs/reference/dialogs/feed/</a>.
         */
        public FeedDialogBuilder(Context context, /*Session session,*/ Bundle parameters) {
            super(context, /*session,*/ FEED_DIALOG, parameters);
        }

        /**
         * Constructor that builds a Feed Dialog using the provided application ID and parameters.
         *
         * @param context       the Context within which the dialog will be shown.
         * @param applicationId the application ID to use. If null, the application ID specified in the
         *                      application/meta-data will be used instead.
         * @param parameters    a Bundle containing parameters to pass as part of the
         *                      dialog URL. No validation is done on these parameters; it is
         *                      the caller's responsibility to ensure they are valid. For more information,
         *                      see <a href="https://developers.facebook.com/docs/reference/dialogs/feed/">
         *                      https://developers.facebook.com/docs/reference/dialogs/feed/</a>.
         */
        public FeedDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, FEED_DIALOG, parameters);
        }

        /**
         * Sets the ID of the profile that is posting to Facebook. If none is specified,
         * the default is "me". This profile must be either the authenticated user or a
         * Page that the user is an administrator of.
         *
         * @param id Facebook ID of the profile to post from
         * @return the builder
         */
        public FeedDialogBuilder setFrom(String id) {
            getParameters().putString(FROM_PARAM, id);
            return this;
        }

        /**
         * Sets the ID of the profile that the story will be published to. If not specified, it
         * will default to the same profile that the story is being published from. The ID must be a friend who also
         * uses your app.
         *
         * @param id Facebook ID of the profile to post to
         * @return the builder
         */
        public FeedDialogBuilder setTo(String id) {
            getParameters().putString(TO_PARAM, id);
            return this;
        }

        /**
         * Sets the URL of a link to be shared.
         *
         * @param link the URL
         * @return the builder
         */
        public FeedDialogBuilder setLink(String link) {
            getParameters().putString(LINK_PARAM, link);
            return this;
        }

        /**
         * Sets the URL of a picture to be shared.
         *
         * @param picture the URL of the picture
         * @return the builder
         */
        public FeedDialogBuilder setPicture(String picture) {
            getParameters().putString(PICTURE_PARAM, picture);
            return this;
        }

        /**
         * Sets the URL of a media file attached to this post. If this is set, any picture
         * set via setPicture will be ignored.
         *
         * @param source the URL of the media file
         * @return the builder
         */
        public FeedDialogBuilder setSource(String source) {
            getParameters().putString(SOURCE_PARAM, source);
            return this;
        }

        /**
         * Sets the name of the URL being shared. This method only has effect if setLink is called.
         *
         * @param name the name
         * @return the builder
         */
        public FeedDialogBuilder setName(String name) {
            getParameters().putString(NAME_PARAM, name);
            return this;
        }

        /**
         * Sets the caption of the URL being shared. This method only has effect if setLink is called.
         *
         * @param caption the caption
         * @return the builder
         */
        public FeedDialogBuilder setCaption(String caption) {
            getParameters().putString(CAPTION_PARAM, caption);
            return this;
        }

        /**
         * Sets the description of the URL being shared. This method only has effect if setLink is called.
         *
         * @param description the description
         * @return the builder
         */
        public FeedDialogBuilder setDescription(String description) {
            getParameters().putString(DESCRIPTION_PARAM, description);
            return this;
        }
    }

    /**
     * Provides a builder that allows construction of the parameters for showing
     * the <a href="https://developers.facebook.com/docs/reference/dialogs/requests">Requests Dialog</a>.
     */
    public static class RequestsDialogBuilder extends BuilderBase<RequestsDialogBuilder> {
        private static final String APPREQUESTS_DIALOG = "apprequests";
        private static final String MESSAGE_PARAM = "message";
        private static final String TO_PARAM = "to";
        private static final String DATA_PARAM = "data";
        private static final String TITLE_PARAM = "title";

        /**
         * Constructor that builds a Requests Dialog using either the active session, or the application
         * ID specified in the application/meta-data.
         *
         * @param context the Context within which the dialog will be shown.
         */
        public RequestsDialogBuilder(Context context) {
            super(context, APPREQUESTS_DIALOG);
        }

        /**
         * Constructor that builds a Requests Dialog using the provided session.
         *
         * @param context the Context within which the dialog will be shown.
         * @param session the Session representing an authenticating user to use for
         *                showing the dialog; must not be null, and must be opened.
         */
//        public RequestsDialogBuilder(Context context, Session session) {
//            super(context, session, APPREQUESTS_DIALOG, null);
//        }

        /**
         * Constructor that builds a Requests Dialog using the provided session and parameters.
         *
         * @param context    the Context within which the dialog will be shown.
         * @param session    the Session representing an authenticating user to use for
         *                   showing the dialog; must not be null, and must be opened.
         * @param parameters a Bundle containing parameters to pass as part of the
         *                   dialog URL. No validation is done on these parameters; it is
         *                   the caller's responsibility to ensure they are valid. For more information,
         *                   see <a href="https://developers.facebook.com/docs/reference/dialogs/requests/">
         *                   https://developers.facebook.com/docs/reference/dialogs/requests/</a>.
         */
//        public RequestsDialogBuilder(Context context, Session session, Bundle parameters) {
//            super(context, session, APPREQUESTS_DIALOG, parameters);
//        }

        /**
         * Constructor that builds a Requests Dialog using the provided application ID and parameters.
         *
         * @param context       the Context within which the dialog will be shown.
         * @param applicationId the application ID to use. If null, the application ID specified in the
         *                      application/meta-data will be used instead.
         * @param parameters    a Bundle containing parameters to pass as part of the
         *                      dialog URL. No validation is done on these parameters; it is
         *                      the caller's responsibility to ensure they are valid. For more information,
         *                      see <a href="https://developers.facebook.com/docs/reference/dialogs/requests/">
         *                      https://developers.facebook.com/docs/reference/dialogs/requests/</a>.
         */
        public RequestsDialogBuilder(Context context, String applicationId, Bundle parameters) {
            super(context, applicationId, APPREQUESTS_DIALOG, parameters);
        }

        /**
         * Sets the string users receiving the request will see. The maximum length
         * is 60 characters.
         *
         * @param message the message
         * @return the builder
         */
        public RequestsDialogBuilder setMessage(String message) {
            getParameters().putString(MESSAGE_PARAM, message);
            return this;
        }

        /**
         * Sets the user ID or user name the request will be sent to. If this is not
         * specified, a friend selector will be displayed and the user can select up
         * to 50 friends.
         *
         * @param id the id or user name to send the request to
         * @return the builder
         */
        public RequestsDialogBuilder setTo(String id) {
            getParameters().putString(TO_PARAM, id);
            return this;
        }

        /**
         * Sets optional data which can be used for tracking; maximum length is 255
         * characters.
         *
         * @param data the data
         * @return the builder
         */
        public RequestsDialogBuilder setData(String data) {
            getParameters().putString(DATA_PARAM, data);
            return this;
        }

        /**
         * Sets an optional title for the dialog; maximum length is 50 characters.
         *
         * @param title the title
         * @return the builder
         */
        public RequestsDialogBuilder setTitle(String title) {
            getParameters().putString(TITLE_PARAM, title);
            return this;
        }
    }
}
