package com.zing.zalo.zalosdk.oauth.model;

import com.zing.zalo.zalosdk.ZaloOAuthResultCode;

public class ErrorResponse {

    private String errorDescription;
    private String errorReason;
    private String errorMsg;
    private String fromSource;
    private int errorCode;
    private int extCode;

    public ErrorResponse(int errorCode, String errorMsg) {
        this.errorCode = ZaloOAuthResultCode.findById(errorCode);
        this.errorMsg = errorMsg;
        this.extCode = errorCode;
    }

    public ErrorResponse(int errorCode, String errorMsg, String errorReason, String errorDescription, String fromSource) {
        this.errorDescription = errorDescription;
        this.errorMsg = errorMsg;
        this.fromSource = fromSource;
        this.errorReason = errorReason;
        this.errorCode = ZaloOAuthResultCode.findById(errorCode);
        this.extCode = errorCode;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public String getErrorDescription() {
        return errorDescription;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public String getErrorReason() {
        return errorReason;
    }

    public String getFromSource() {
        return fromSource;
    }

    public int getExtCode() {
        return extCode;
    }
}
