package com.zing.zalo.zalosdk.payment.direct;

import android.content.Context;
import android.content.res.Configuration;
import android.telephony.TelephonyManager;

import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.type.FromSourceType;
import com.zing.zalo.zalosdk.core.type.LangType;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Locale;

/**
 * Created by CPU10329-local on 7/6/2017.
 */

public class Utils {

    private static LangType language = null;

    public static String getLanguage(Context context){
//        Locale current = context.getResources().getConfiguration().locale;
        if (language != null){
            Log.i("debuglog", "AAAA----current.getLanguage() : " + language);
//            Log.i("debuglog", "default-------locale langauge : " + Locale.getDefault().getLanguage());

            if (language == LangType.MY){
                return "my";
            }
            else if (language != LangType.VN){
                return "en";
            } else {
                return "vi";
            }

//            if (Locale.getDefault().getLanguage().equalsIgnoreCase("en")){
//                return "en";
//            }
//            else if (!Locale.getDefault().getLanguage().equalsIgnoreCase("vi")){
//                return "my";
//            } else {
//                return "vi";
//            }
        }
        return Locale.getDefault().getLanguage();
    }

    public static void showAlertDialog(Context context, String mess, String okTile, PaymentAlertDialog.OnOkListener listener,
                                       PaymentAlertDialog.OnCancelListener cancelListener) {
        PaymentAlertDialog alertDlg = new PaymentAlertDialog(context, listener, cancelListener);
        alertDlg.setOkButtonTitle(okTile);
        alertDlg.showAlert(mess);
    }

    public static void showAlertDialog(Context context, String mess, PaymentAlertDialog.OnOkListener listener) {
        PaymentAlertDialog alertDlg = new PaymentAlertDialog(context, listener);
        alertDlg.showAlert(mess);

    }


    public static void setLanguage(Context context, LangType _language){
        language = _language;
    }

    public static String getExtInfo(JSONObject appExtInfo, boolean encode) throws UnsupportedEncodingException, JSONException {
        JSONObject sdkExtInfo = ZaloSDK.Instance.getBaseAppInfo().prepareExtraInfo(FromSourceType.SDK.getCode());
        String info;
        if (appExtInfo == null) {
            info = sdkExtInfo.toString();
        } else {
            Iterator<String> iterator = sdkExtInfo.keys();
            while (iterator.hasNext()) {
                String key = iterator.next();
                appExtInfo.put(key, sdkExtInfo.get(key));
            }
            info = appExtInfo.toString();
        }
        return encode ? URLEncoder.encode(info, "UTF-8") : info;
    }

    public static String getExtInfo(JSONObject appExtInfo) throws UnsupportedEncodingException, JSONException {
        return getExtInfo(appExtInfo, true);
    }
}
