/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.oauth;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.auth.internal.b;
import com.zing.zalo.zalosdk.oauth.Utilities;
import com.zing.zalo.zalosdk.oauth.ZaloPluginCallback;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public class WebDialog
extends Dialog {
    public static final String EXTRA_OAUTH_CODE = "oauthCodeaa";
    public static final String EXTRA_QUERY = "querystring";
    public static final String EXTRA_REQUEST_BODY = "bodyrequest";
    private static final String UTF8 = "UTF-8";
    private static final String LOG_TAG = "WebDialog";
    private static final String DISPLAY_TOUCH = "touch";
    private static final int API_EC_DIALOG_CANCEL = 4201;
    static final boolean DISABLE_SSL_CHECK_FOR_TESTING = false;
    private static final int NO_PADDING_SCREEN_WIDTH = 480;
    private static final int MAX_PADDING_SCREEN_WIDTH = 800;
    private static final int NO_PADDING_SCREEN_HEIGHT = 800;
    private static final int MAX_PADDING_SCREEN_HEIGHT = 1280;
    private static final double MIN_SCALE_FACTOR = 0.5;
    private static final int BACKGROUND_GRAY = -872415232;
    private static final int BACKGROUND_WHITE = 0xFFFFFF;
    public static final int DEFAULT_THEME = 0x1030010;
    private static final Pattern WZUIN = Pattern.compile("(wzuin=[\\d\\w]*)");
    private String url;
    private String query;
    private String queryBody;
    private String code;
    private OnCompleteListener onCompleteListener;
    ZaloPluginCallback zFeedCallback;
    private WebView webView;
    private b spinner;
    private ImageView crossImageView;
    private FrameLayout contentFrameLayout;
    private boolean listenerCalled = false;
    private boolean isDetached = false;
    private boolean isDismissed = false;
    CookieSyncManager cookieSyncManager;
    CookieManager cookieManager;
    int oldWidth = 0;
    OrientationEventListener myOrientationEventListener;

    public WebDialog(Context context, String string) {
        this(context, string, 0x1030010);
    }

    public WebDialog(Context context, String string, int n) {
        super(context, n);
        this.url = string;
    }

    public WebDialog(Context object, String string, Bundle bundle, int n, OnCompleteListener onCompleteListener) {
        super(object, n);
        if (bundle == null) {
            Bundle bundle2;
            bundle = bundle2;
            bundle2 = new Bundle();
        }
        this.query = bundle.getString(EXTRA_QUERY);
        this.queryBody = bundle.getString(EXTRA_REQUEST_BODY);
        object = this.query;
        if (object == null) {
            object = "";
        }
        WebDialog webDialog = this;
        this.query = object;
        webDialog.code = bundle.getString(EXTRA_OAUTH_CODE);
        webDialog.url = "https://plugin.zaloapp.com/mobile-sharing?" + this.query;
        this.onCompleteListener = onCompleteListener;
    }

    private void updateLayout() {
        if (this.oldWidth != this.getScreenWidth()) {
            WebDialog webDialog = this;
            webDialog.calculateSize();
            webDialog.oldWidth = webDialog.getScreenWidth();
        }
    }

    private int getScreenWidth() {
        DisplayMetrics displayMetrics;
        Display display = ((WindowManager)webDialog.getContext().getSystemService("window")).getDefaultDisplay();
        WebDialog webDialog = displayMetrics;
        display.getMetrics(new DisplayMetrics());
        return ((DisplayMetrics)webDialog).widthPixels;
    }

    private void calculateSize() {
        WebDialog webDialog = this;
        Display display = ((WindowManager)webDialog.getContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        int n = displayMetrics.widthPixels;
        int n2 = displayMetrics.heightPixels;
        if (Utilities.isTablet(webDialog.getContext())) {
            n2 = n2 * 2 / 3;
            if (Utilities.isPortait(this.getContext())) {
                if ((n = n * 2 / 3) < 300) {
                    n = 300;
                }
                if (n2 < 400) {
                    n2 = 400;
                }
            } else {
                if ((n = n * 1 / 2) < 400) {
                    n = 400;
                }
                if (n2 < 300) {
                    n2 = 300;
                }
            }
            this.getWindow().setLayout(n, n2);
        } else {
            this.getWindow().setLayout(n, n2 - 80);
        }
    }

    private int getScaledSize(int n, float f2, int n2, int n3) {
        int n4 = (int)((float)n / f2);
        double d2 = n4 <= n2 ? 1.0 : (n4 >= n3 ? 0.5 : (double)(n3 - n4) / (double)(n3 - n2) * 0.5 + 0.5);
        return (int)((double)n * d2);
    }

    private void createCrossImage() {
        WebDialog webDialog = this;
        this.crossImageView = new ImageView(this.getContext());
        this.crossImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WebDialog.this.dismiss();
            }
        });
        Drawable drawable2 = webDialog.getContext().getResources().getDrawable(R.drawable.ic_close_web);
        webDialog.crossImageView.setImageDrawable(drawable2);
        webDialog.crossImageView.setVisibility(4);
        WebDialog webDialog2 = this;
        int n = WebDialog.convertDpToPixel(7.0f, webDialog2.getContext());
        drawable2 = webDialog2.getContext();
        webDialog.crossImageView.setPadding(n, WebDialog.convertDpToPixel(7.0f, (Context)drawable2), 0, 0);
    }

    public static int convertDpToPixel(float f2, Context context) {
        return (int)(f2 * ((float)context.getResources().getDisplayMetrics().densityDpi / 160.0f));
    }

    private void setupCookie() {
        Object object;
        this.cookieSyncManager = CookieSyncManager.createInstance((Context)this.getContext());
        this.cookieManager = object = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            object.setAcceptThirdPartyCookies(this.webView, true);
        } else {
            object.setAcceptCookie(true);
        }
        WebDialog webDialog = this;
        object = "https://plugin.zaloapp.com";
        Log.i((String)"debuglog", (String)("cookie: " + webDialog.cookieManager.getCookie((String)object)));
        webDialog.cookieManager.removeAllCookie();
        webDialog.cookieManager.setCookie((String)object, "code=" + this.code);
        if (Build.VERSION.SDK_INT >= 21) {
            this.cookieManager.flush();
        } else {
            this.cookieSyncManager.sync();
        }
        Log.i((String)"debuglog", (String)("set cookie: code=" + this.code));
        Log.i((String)"debuglog", (String)("cookies: " + this.cookieManager.getCookie((String)object)));
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setUpWebView(int n) {
        LinearLayout linearLayout;
        WebDialog webDialog = this;
        LinearLayout linearLayout2 = linearLayout;
        linearLayout = new LinearLayout(this.getContext());
        WebDialog webDialog2 = this;
        this.webView = new WebView(webDialog2.getContext()){

            public void onWindowFocusChanged(boolean bl) {
                try {
                    super.onWindowFocusChanged(bl);
                }
                catch (NullPointerException nullPointerException) {}
            }
        };
        this.webView.setVerticalScrollBarEnabled(false);
        webDialog.webView.setHorizontalScrollBarEnabled(false);
        webDialog.webView.setWebViewClient((WebViewClient)new DialogWebViewClient());
        webDialog.webView.getSettings().setJavaScriptEnabled(true);
        webDialog.setupCookie();
        webDialog.webView.postUrl(this.url, this.queryBody.getBytes());
        webDialog.webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        webDialog.webView.setVisibility(4);
        webDialog.webView.getSettings().setSavePassword(false);
        webDialog.webView.getSettings().setSaveFormData(false);
        webDialog.webView.getSettings().setDomStorageEnabled(true);
        webDialog.webView.getSettings().setDatabaseEnabled(true);
        if (Build.VERSION.SDK_INT < 19) {
            WebDialog webDialog3 = this;
            String string = webDialog3.getContext().getDir("database", 0).getPath();
            webDialog3.webView.getSettings().setDatabasePath(string);
        }
        LinearLayout linearLayout3 = linearLayout2;
        int n2 = n;
        linearLayout2.setPadding(n2, n2, n2, n2);
        linearLayout3.addView((View)this.webView);
        linearLayout3.setBackgroundColor(0xFFFFFF);
        this.contentFrameLayout.addView((View)linearLayout2);
    }

    public void setFeedCallBackListener(ZaloPluginCallback zaloPluginCallback) {
        this.zFeedCallback = zaloPluginCallback;
    }

    public OnCompleteListener getOnCompleteListener() {
        return this.onCompleteListener;
    }

    public void dismiss() {
        if (this.isDismissed) {
            return;
        }
        this.isDismissed = true;
        OrientationEventListener orientationEventListener = this.myOrientationEventListener;
        if (orientationEventListener != null) {
            orientationEventListener.disable();
        }
        if (!this.listenerCalled) {
            this.sendCancelToListener();
        }
        if ((orientationEventListener = this.webView) != null) {
            orientationEventListener.stopLoading();
        }
        if (!this.isDetached) {
            if (this.spinner.isShowing()) {
                this.spinner.dismiss();
            }
            super.dismiss();
        }
    }

    public void onDetachedFromWindow() {
        this.isDetached = true;
        super.onDetachedFromWindow();
    }

    public void onAttachedToWindow() {
        this.isDetached = false;
        super.onAttachedToWindow();
    }

    protected void onCreate(Bundle object) {
        OrientationEventListener orientationEventListener;
        ViewGroup.LayoutParams layoutParams;
        WebDialog webDialog = this;
        super.onCreate(object);
        this.spinner = new b(this.getContext(), new b.e(){

            @Override
            public void onClose() {
            }
        });
        this.spinner.requestWindowFeature(1);
        webDialog.spinner.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                WebDialog.this.dismiss();
            }
        });
        webDialog.requestWindowFeature(1);
        webDialog.contentFrameLayout = new FrameLayout(this.getContext());
        webDialog.calculateSize();
        webDialog.getWindow().setGravity(17);
        webDialog.getWindow().setSoftInputMode(16);
        webDialog.createCrossImage();
        webDialog.crossImageView.getDrawable().getIntrinsicWidth();
        webDialog.setUpWebView(0);
        object = layoutParams;
        layoutParams = new ViewGroup.LayoutParams(-2, -2);
        webDialog.contentFrameLayout.addView((View)this.crossImageView, (ViewGroup.LayoutParams)object);
        webDialog.setContentView((View)webDialog.contentFrameLayout);
        webDialog.crossImageView.bringToFront();
        object = orientationEventListener;
        WebDialog webDialog2 = this;
        webDialog.myOrientationEventListener = new OrientationEventListener(webDialog2.getContext(), 3){

            public void onOrientationChanged(int n) {
                if (n <= 350 && n >= 10) {
                    if (n < 100 && n > 80) {
                        WebDialog.this.updateLayout();
                    } else if (n > 170 && n < 190) {
                        WebDialog.this.updateLayout();
                    } else if (n > 260 && n < 280) {
                        WebDialog.this.updateLayout();
                    }
                } else {
                    WebDialog.this.updateLayout();
                }
            }
        };
        if (object.canDetectOrientation()) {
            this.myOrientationEventListener.enable();
        } else {
            this.myOrientationEventListener = null;
        }
        WebDialog webDialog3 = this;
        webDialog3.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
            }
        });
        webDialog3.getWindow().addFlags(2);
        webDialog3.getWindow().getAttributes().dimAmount = 0.7f;
    }

    protected boolean isListenerCalled() {
        return this.listenerCalled;
    }

    protected WebView getWebView() {
        return this.webView;
    }

    protected void sendSuccessToListener(Bundle bundle) {
        OnCompleteListener onCompleteListener = this.onCompleteListener;
        if (onCompleteListener != null && !this.listenerCalled) {
            this.listenerCalled = true;
            onCompleteListener.onComplete(bundle);
            this.dismiss();
        }
    }

    protected void sendErrorToListener(Throwable object) {
        object = this.onCompleteListener;
        if (object != null && !this.listenerCalled) {
            this.listenerCalled = true;
            object.onComplete(null);
            this.dismiss();
        }
    }

    protected void sendCancelToListener() {
        this.sendErrorToListener(null);
    }

    public static class RequestsDialogBuilder
    extends BuilderBase<RequestsDialogBuilder> {
        private static final String APPREQUESTS_DIALOG = "apprequests";
        private static final String MESSAGE_PARAM = "message";
        private static final String TO_PARAM = "to";
        private static final String DATA_PARAM = "data";
        private static final String TITLE_PARAM = "title";

        public RequestsDialogBuilder(Context context) {
            super(context, APPREQUESTS_DIALOG);
        }

        public RequestsDialogBuilder(Context context, String string, Bundle bundle) {
            super(context, string, APPREQUESTS_DIALOG, bundle);
        }

        public RequestsDialogBuilder setMessage(String string) {
            RequestsDialogBuilder requestsDialogBuilder = this;
            requestsDialogBuilder.getParameters().putString(MESSAGE_PARAM, string);
            return requestsDialogBuilder;
        }

        public RequestsDialogBuilder setTo(String string) {
            RequestsDialogBuilder requestsDialogBuilder = this;
            requestsDialogBuilder.getParameters().putString(TO_PARAM, string);
            return requestsDialogBuilder;
        }

        public RequestsDialogBuilder setData(String string) {
            RequestsDialogBuilder requestsDialogBuilder = this;
            requestsDialogBuilder.getParameters().putString(DATA_PARAM, string);
            return requestsDialogBuilder;
        }

        public RequestsDialogBuilder setTitle(String string) {
            RequestsDialogBuilder requestsDialogBuilder = this;
            requestsDialogBuilder.getParameters().putString(TITLE_PARAM, string);
            return requestsDialogBuilder;
        }
    }

    public static class FeedDialogBuilder
    extends BuilderBase<FeedDialogBuilder> {
        private static final String FEED_DIALOG = "feed";
        private static final String FROM_PARAM = "from";
        private static final String TO_PARAM = "to";
        private static final String LINK_PARAM = "link";
        private static final String PICTURE_PARAM = "picture";
        private static final String SOURCE_PARAM = "source";
        private static final String NAME_PARAM = "name";
        private static final String CAPTION_PARAM = "caption";
        private static final String DESCRIPTION_PARAM = "description";

        public FeedDialogBuilder(Context context) {
            super(context, FEED_DIALOG);
        }

        public FeedDialogBuilder(Context context, Bundle bundle) {
            super(context, FEED_DIALOG, bundle);
        }

        public FeedDialogBuilder(Context context, String string, Bundle bundle) {
            super(context, string, FEED_DIALOG, bundle);
        }

        public FeedDialogBuilder setFrom(String string) {
            FeedDialogBuilder feedDialogBuilder = this;
            feedDialogBuilder.getParameters().putString(FROM_PARAM, string);
            return feedDialogBuilder;
        }

        public FeedDialogBuilder setTo(String string) {
            FeedDialogBuilder feedDialogBuilder = this;
            feedDialogBuilder.getParameters().putString(TO_PARAM, string);
            return feedDialogBuilder;
        }

        public FeedDialogBuilder setLink(String string) {
            FeedDialogBuilder feedDialogBuilder = this;
            feedDialogBuilder.getParameters().putString(LINK_PARAM, string);
            return feedDialogBuilder;
        }

        public FeedDialogBuilder setPicture(String string) {
            FeedDialogBuilder feedDialogBuilder = this;
            feedDialogBuilder.getParameters().putString(PICTURE_PARAM, string);
            return feedDialogBuilder;
        }

        public FeedDialogBuilder setSource(String string) {
            FeedDialogBuilder feedDialogBuilder = this;
            feedDialogBuilder.getParameters().putString(SOURCE_PARAM, string);
            return feedDialogBuilder;
        }

        public FeedDialogBuilder setName(String string) {
            FeedDialogBuilder feedDialogBuilder = this;
            feedDialogBuilder.getParameters().putString(NAME_PARAM, string);
            return feedDialogBuilder;
        }

        public FeedDialogBuilder setCaption(String string) {
            FeedDialogBuilder feedDialogBuilder = this;
            feedDialogBuilder.getParameters().putString(CAPTION_PARAM, string);
            return feedDialogBuilder;
        }

        public FeedDialogBuilder setDescription(String string) {
            FeedDialogBuilder feedDialogBuilder = this;
            feedDialogBuilder.getParameters().putString(DESCRIPTION_PARAM, string);
            return feedDialogBuilder;
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        public Builder(Context context, String string) {
            super(context, string);
        }

        public Builder(Context context, String string, Bundle bundle) {
            super(context, string, bundle);
        }

        public Builder(Context context, String string, String string2, Bundle bundle) {
            super(context, string, string2, bundle);
        }
    }

    private static class BuilderBase<CONCRETE extends BuilderBase<?>> {
        private Context context;
        private String applicationId;
        private String action;
        private int theme;
        private OnCompleteListener listener;
        private Bundle parameters;

        protected BuilderBase(Context context, String string) {
            BuilderBase builderBase = this;
            builderBase.theme = 0x1030010;
            builderBase.finishInit(context, string, null);
        }

        protected BuilderBase(Context context, String string, Bundle bundle) {
            BuilderBase builderBase = this;
            builderBase.theme = 0x1030010;
            builderBase.finishInit(context, string, bundle);
        }

        protected BuilderBase(Context context, String string, String string2, Bundle bundle) {
            BuilderBase builderBase = this;
            builderBase.theme = 0x1030010;
            builderBase.finishInit(context, string2, bundle);
        }

        private void finishInit(Context context, String string, Bundle bundle) {
            BuilderBase builderBase = builderBase3;
            builderBase.context = context;
            builderBase.action = string;
            if (bundle != null) {
                builderBase3.parameters = bundle;
            } else {
                Bundle bundle2;
                BuilderBase builderBase2 = builderBase3;
                BuilderBase builderBase3 = bundle2;
                bundle2 = new Bundle();
                builderBase2.parameters = builderBase3;
            }
        }

        public CONCRETE setTheme(int n) {
            this.theme = n;
            return (CONCRETE)this;
        }

        public CONCRETE setOnCompleteListener(OnCompleteListener onCompleteListener) {
            this.listener = onCompleteListener;
            return (CONCRETE)this;
        }

        public WebDialog build() {
            BuilderBase builderBase = builderBase2;
            BuilderBase builderBase2 = builderBase.context;
            String string = builderBase.action;
            Bundle bundle = builderBase.parameters;
            int n = builderBase.theme;
            OnCompleteListener onCompleteListener = builderBase.listener;
            return new WebDialog((Context)builderBase2, string, bundle, n, onCompleteListener);
        }

        protected String getApplicationId() {
            return this.applicationId;
        }

        protected Context getContext() {
            return this.context;
        }

        protected int getTheme() {
            return this.theme;
        }

        protected Bundle getParameters() {
            return this.parameters;
        }

        protected OnCompleteListener getListener() {
            return this.listener;
        }
    }

    private class DialogWebViewClient
    extends WebViewClient {
        private DialogWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string) {
            return super.shouldOverrideUrlLoading(webView, string);
        }

        public void onReceivedError(WebView webView, int n, String string, String string2) {
            DialogWebViewClient dialogWebViewClient = this;
            super.onReceivedError(webView, n, string, string2);
            dialogWebViewClient.WebDialog.this.sendErrorToListener(null);
        }

        public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
            sslErrorHandler.cancel();
            WebDialog.this.sendErrorToListener(null);
        }

        public void onPageStarted(WebView object, String string, Bitmap bitmap) {
            DialogWebViewClient dialogWebViewClient = object2;
            super.onPageStarted(object, string, bitmap);
            if (!dialogWebViewClient.WebDialog.this.isDetached) {
                object2.WebDialog.this.spinner.show();
            }
            if (string.contains("plugin.zaloapp.com/webview/callback")) {
                object.stopLoading();
                if (object2.WebDialog.this.zFeedCallback != null) {
                    object = object2.parseUrlQueryString(Uri.parse((String)string).getQuery());
                    boolean bl = false;
                    int n = 0;
                    String string2 = object.getString("error_code");
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        try {
                            n = Integer.parseInt(string2);
                        }
                        catch (Exception exception) {
                            n = 0;
                        }
                    }
                    if (n == 0) {
                        bl = true;
                    }
                    DialogWebViewClient dialogWebViewClient2 = object2;
                    WebView webView = object;
                    Object object2 = webView.getString("error_message");
                    object = webView.getString("result_data");
                    dialogWebViewClient2.WebDialog.this.zFeedCallback.onResult(bl, n, (String)object2, (String)object);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Bundle parseUrlQueryString(String stringArray) {
            Bundle bundle;
            DialogWebViewClient dialogWebViewClient = bundle;
            bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)stringArray)) {
                stringArray = stringArray.split("&");
                int n = stringArray.length;
                for (int i2 = 0; i2 < n; ++i2) {
                    String[] stringArray2 = stringArray[i2].split("=");
                    try {
                        if (stringArray2.length == 2) {
                            String string = URLDecoder.decode(stringArray2[0], WebDialog.UTF8);
                            dialogWebViewClient.putString(string, URLDecoder.decode(stringArray2[1], WebDialog.UTF8));
                            continue;
                        }
                        if (stringArray2.length != 1) continue;
                        dialogWebViewClient.putString(URLDecoder.decode(stringArray2[0], WebDialog.UTF8), "");
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
            return dialogWebViewClient;
        }

        public void onPageFinished(WebView webView, String string) {
            DialogWebViewClient dialogWebViewClient = this;
            super.onPageFinished(webView, string);
            if (!dialogWebViewClient.WebDialog.this.isDetached) {
                WebDialog.this.spinner.dismiss();
            }
            DialogWebViewClient dialogWebViewClient2 = this;
            dialogWebViewClient2.WebDialog.this.contentFrameLayout.setBackgroundColor(0);
            dialogWebViewClient2.WebDialog.this.webView.setVisibility(0);
            dialogWebViewClient2.WebDialog.this.crossImageView.setVisibility(0);
        }
    }

    public static interface OnCompleteListener {
        public void onComplete(Bundle var1);
    }
}

