/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.devicetrackingsdk;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.ZPermissionManager;
import com.zing.zalo.devicetrackingsdk.model.DeviceIdInfo;
import com.zing.zalo.devicetrackingsdk.model.SDKIDInfo;
import com.zing.zalo.zalosdk.core.helper.Storage;
import com.zing.zalo.zalosdk.core.log.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.json.JSONException;
import org.json.JSONObject;

public class BaseAppInfoStorage
extends Storage {
    private static final String DID_FILE_NAME = "ddinfo2";
    private final String PREF_VIEWER;
    private final String PREF_SDK_ID;
    private final String PREF_PRIVATE_KEY;
    private final String PREF_TRACKING_APP_INSTALL_EXP_TIME;
    private DeviceIdInfo deviceIdInfo;
    private SDKIDInfo sdkIdInfo;

    public BaseAppInfoStorage(Context context) {
        super(context);
        SDKIDInfo sDKIDInfo;
        DeviceIdInfo deviceIdInfo;
        ((BaseAppInfoStorage)object).PREF_VIEWER = "PREFERECE_VIEWER";
        ((BaseAppInfoStorage)object).PREF_SDK_ID = "PREF_SDK_ID";
        ((BaseAppInfoStorage)object).PREF_PRIVATE_KEY = "PREF_PRIVATE_KEY";
        ((BaseAppInfoStorage)object).PREF_TRACKING_APP_INSTALL_EXP_TIME = "PREF_TRACKING_APP_INSTALL_EXP_TIME";
        Object object = deviceIdInfo;
        deviceIdInfo = new DeviceIdInfo();
        v1.deviceIdInfo = object;
        object = sDKIDInfo;
        sDKIDInfo = new SDKIDInfo();
        v1.sdkIdInfo = object;
    }

    private File prepareFileInExternalStore(String object, boolean bl) {
        File file;
        String string2 = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/com.google.android.zdt.data/" + (String)object;
        object = file;
        new File(string2).getParentFile().mkdirs();
        if (bl && ((File)object).exists()) {
            ((File)object).delete();
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToFile(Context object, String string2, String string3) {
        void var3_4;
        void var2_3;
        block5: {
            File file;
            void v1;
            BaseAppInfoStorage baseAppInfoStorage;
            try {
                if (!this.isExternalStorageWritable()) break block5;
                baseAppInfoStorage = this;
                v1 = var2_3;
                File file2 = this.prepareFileInExternalStore((String)var3_4, true);
                file = file2;
                file2.createNewFile();
            }
            catch (Exception exception) {
                Log.e(exception);
                break block5;
            }
            {
                baseAppInfoStorage.writeFileData((String)v1, file);
                return;
            }
        }
        try {
            File file;
            File file3 = Build.VERSION.SDK_INT >= 21 ? object.getNoBackupFilesDir() : object.getFilesDir();
            File file4 = file;
            file4(file3, (String)var3_4);
            this.writeFileData((String)var2_3, file4);
            return;
        }
        catch (Exception exception) {
            Log.e(exception);
            Log.v("can't write file " + (String)var3_4);
            return;
        }
    }

    private void writeFileData(String string2, File file) throws IOException {
        FileOutputStream fileOutputStream;
        FileOutputStream fileOutputStream2 = fileOutputStream;
        fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream2);
        outputStreamWriter.write(string2);
        outputStreamWriter.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFromFile(Context object, String string2) {
        File file;
        void var2_3;
        block6: {
            try {
                if (!objectArray2.isExternalStorageReadable()) break block6;
                file = objectArray2.prepareFileInExternalStore((String)var2_3, false);
            }
            catch (Exception exception) {
                Log.e(exception);
                break block6;
            }
            {
                if (!file.exists()) break block6;
                return super.readFileData(file).toString();
            }
        }
        try {
            File file2 = Build.VERSION.SDK_INT >= 21 ? object.getNoBackupFilesDir() : object.getFilesDir();
            File file3 = file;
            file3(file2, (String)var2_3);
            return super.readFileData(file3).toString();
        }
        catch (Exception exception) {
            Log.e(exception);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = var2_3;
            Log.v("ZDK", "file %s not found in internal storage", objectArray2);
        }
        Log.v("can't read file " + (String)var2_3);
        return null;
    }

    private StringBuilder readFileData(File object) throws IOException {
        String string2;
        StringBuilder stringBuilder;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        FileInputStream fileInputStream;
        FileInputStream fileInputStream2 = fileInputStream;
        fileInputStream = new FileInputStream((File)object);
        object = inputStreamReader;
        inputStreamReader = new InputStreamReader(fileInputStream2);
        BufferedReader bufferedReader2 = bufferedReader;
        bufferedReader = new BufferedReader((Reader)object);
        object = stringBuilder;
        stringBuilder = new StringBuilder(256);
        while ((string2 = bufferedReader2.readLine()) != null) {
            ((StringBuilder)object).append(string2);
        }
        fileInputStream2.close();
        return object;
    }

    public void loadDeviceId() {
        BaseAppInfoStorage baseAppInfoStorage = this;
        String string2 = baseAppInfoStorage.readFromFile(baseAppInfoStorage.context, DID_FILE_NAME);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            JSONObject jSONObject;
            BaseAppInfoStorage baseAppInfoStorage2;
            BaseAppInfoStorage baseAppInfoStorage3;
            try {
                BaseAppInfoStorage baseAppInfoStorage4 = this;
                baseAppInfoStorage3 = baseAppInfoStorage4;
                baseAppInfoStorage2 = baseAppInfoStorage4;
            }
            catch (JSONException jSONException) {}
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject(string2);
            baseAppInfoStorage3.deviceIdInfo.setDeviceId(jSONObject2.optString("deviceId"));
            baseAppInfoStorage2.deviceIdInfo.setDeviceIdExpiredTime(jSONObject2.optLong("expiredTime"));
        }
        Log.v("Loaded device info: " + this.deviceIdInfo.toString());
    }

    public void loadSDKId() {
        if (this.sdkIdInfo == null) {
            SDKIDInfo sDKIDInfo;
            SDKIDInfo sDKIDInfo2 = sDKIDInfo;
            sDKIDInfo = new SDKIDInfo();
            this.sdkIdInfo = sDKIDInfo2;
        }
        BaseAppInfoStorage baseAppInfoStorage = this;
        baseAppInfoStorage.sdkIdInfo.setSdkId(this.localPref.getString("PREF_SDK_ID", ""));
        baseAppInfoStorage.sdkIdInfo.setPrivateKey(this.localPref.getString("PREF_PRIVATE_KEY", ""));
        Log.v("Loaded sdk info: " + this.sdkIdInfo.toString());
    }

    public String getSDKId() {
        return this.sdkIdInfo.getSdkId();
    }

    public String getPrivateKey() {
        return this.sdkIdInfo.getPrivateKey();
    }

    public String getDeviceId() {
        return this.deviceIdInfo.getDeviceId();
    }

    public long getDeviceIdExpiredTime() {
        return this.deviceIdInfo.getDeviceIdExpiredTime();
    }

    public void setDeviceId(String string2, long l) {
        BaseAppInfoStorage baseAppInfoStorage = this;
        baseAppInfoStorage.deviceIdInfo.setDeviceId(string2);
        baseAppInfoStorage.deviceIdInfo.setDeviceIdExpiredTime(l);
        baseAppInfoStorage.writeToFile(baseAppInfoStorage.context, "{\"deviceId\":\"" + string2 + "\",\"expiredTime\":\"" + l + "\"}", DID_FILE_NAME);
        Log.v("write device info: " + this.deviceIdInfo.toString());
    }

    public void setSDKId(String string2, String string3) {
        BaseAppInfoStorage baseAppInfoStorage = this;
        baseAppInfoStorage.setString("PREF_SDK_ID", string2);
        baseAppInfoStorage.setString("PREF_PRIVATE_KEY", string3);
        baseAppInfoStorage.loadSDKId();
        Log.v("write sdkid info: " + this.sdkIdInfo.toString());
    }

    public long getTrackingAppInstallExpireTime() {
        return this.getLong("PREF_TRACKING_APP_INSTALL_EXP_TIME");
    }

    public void setTrackingAppInstallExpireTime(long l) {
        this.setLong("PREF_TRACKING_APP_INSTALL_EXP_TIME", l);
    }

    public boolean ispreInstalled() {
        block5: {
            block6: {
                try {
                    if (!((BaseAppInfoStorage)((Object)file)).isExternalStorageReadable()) break block5;
                }
                catch (Exception exception) {
                    return false;
                }
                BaseAppInfoStorage baseAppInfoStorage = file;
                File file = baseAppInfoStorage.prepareFileInExternalStore(baseAppInfoStorage.context.getPackageName(), false);
                if (!file.exists()) break block6;
                return true;
            }
            file.createNewFile();
            return false;
        }
        return false;
    }

    public boolean isExternalStorageWritable() {
        if (!ZPermissionManager.isPermissionGranted(this.context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            return false;
        }
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public boolean isExternalStorageReadable() {
        if (!ZPermissionManager.isPermissionGranted(((Storage)((Object)string2)).context, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            return false;
        }
        String string2 = Environment.getExternalStorageState();
        return "mounted".equals(string2) || "mounted_ro".equals(string2);
        {
        }
    }

    public String getViewer() {
        return this.getString("PREFERECE_VIEWER");
    }
}

