/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.devicetrackingsdk;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.Api;
import com.zing.zalo.devicetrackingsdk.BaseAppInfoStorage;
import com.zing.zalo.zalosdk.core.log.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class DeviceTracking
implements Handler.Callback {
    static final int ACT_LOAD = 16384;
    static final int ACT_GEN = 16385;
    static final int ACT_GEN_SDK_ID = 16386;
    private static DeviceTracking baseAppInfoInstance = new DeviceTracking();
    private BaseAppInfoStorage storage;
    private Context context;
    private HandlerThread thread;
    private Handler handler;
    public boolean isInitialized;
    private boolean isGeneratingDeviceId;
    private boolean isGeneratingSDKId;
    private List<GetInfoListener> infoListeners;
    private String appID;
    Api api;

    public static DeviceTracking getInstance() {
        return baseAppInfoInstance;
    }

    DeviceTracking() {
        Api api;
        ArrayList arrayList;
        Object object = arrayList;
        arrayList = new ArrayList();
        v1.infoListeners = object;
        object = api;
        api = new Api();
        v1.api = object;
    }

    DeviceTracking(Api api, Handler handler) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.infoListeners = arrayList2;
        v1.api = api;
        v1.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callbackAndResetListener(String string2) {
        DeviceTracking deviceTracking = iterator;
        synchronized (deviceTracking) {
            block8: {
                ArrayList<GetInfoListener> arrayList;
                if (deviceTracking.infoListeners == null) break block8;
                if (((DeviceTracking)((Object)iterator)).infoListeners.size() == 0) break block8;
                ArrayList<GetInfoListener> arrayList2 = arrayList;
                DeviceTracking deviceTracking2 = iterator;
                arrayList2(((DeviceTracking)((Object)iterator)).infoListeners);
                deviceTracking2.infoListeners.clear();
                // ** MonitorExit[v2] (shouldn't be in output)
                Iterator<GetInfoListener> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((GetInfoListener)iterator.next()).onGetDeviceIdComplete(string2);
                }
                return;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    private boolean hasDeviceId() {
        if (((DeviceTracking)this).isInitialized && (this = ((DeviceTracking)this).storage) != null) {
            return (this = ((BaseAppInfoStorage)this).getDeviceId()) != null && !((String)this).equals("");
        }
        return false;
    }

    private boolean isDeviceIdValid() {
        BaseAppInfoStorage baseAppInfoStorage;
        if (((DeviceTracking)((Object)string2)).isInitialized && (baseAppInfoStorage = ((DeviceTracking)((Object)string2)).storage) != null) {
            DeviceTracking deviceTracking = string2;
            String string2 = baseAppInfoStorage.getDeviceId();
            return deviceTracking.storage.getDeviceIdExpiredTime() > System.currentTimeMillis() && string2 != null && !string2.equals("");
        }
        return false;
    }

    private synchronized void sendMessage(int n) {
        Message message;
        if (this.handler == null) {
            this.thread = new HandlerThread("zdt-device-tracker", 5);
            this.thread.start();
            this.handler = new Handler(this.thread.getLooper(), (Handler.Callback)this);
        }
        if ((message = this.handler.obtainMessage(n)) != null) {
            this.handler.sendMessage(message);
        }
    }

    private void loadDeviceId() {
        DeviceTracking deviceTracking = this;
        deviceTracking.storage.loadDeviceId();
        if (deviceTracking.isDeviceIdValid()) {
            DeviceTracking deviceTracking2 = this;
            deviceTracking2.callbackAndResetListener(deviceTracking2.storage.getDeviceId());
        } else {
            this.generateDeviceIdIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateSDKIdIfNeeded() {
        Object object = this.storage.getPrivateKey();
        if (!TextUtils.isEmpty((CharSequence)this.storage.getSDKId()) && !TextUtils.isEmpty((CharSequence)object)) {
            return;
        }
        DeviceTracking deviceTracking = this;
        synchronized (deviceTracking) {
            if (deviceTracking.isGeneratingSDKId) {
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            DeviceTracking deviceTracking2 = this;
            DeviceTracking deviceTracking3 = deviceTracking2;
            DeviceTracking deviceTracking4 = deviceTracking2;
            DeviceTracking deviceTracking5 = deviceTracking2;
            deviceTracking2.isGeneratingSDKId = true;
            // ** MonitorExit[v1] (shouldn't be in output)
            try {
                deviceTracking4.api.viewer = this.storage.getViewer();
                Object object2 = object = deviceTracking5.api.getSdkId(this.context);
                object = ((Api.SDKIdResponse)object2).sdkId;
                deviceTracking3.storage.setSDKId((String)object, ((Api.SDKIdResponse)object2).privateKey);
            }
            catch (Exception exception) {
                Log.e(exception);
            }
            DeviceTracking deviceTracking6 = this;
            synchronized (deviceTracking6) {
                deviceTracking6.isGeneratingSDKId = false;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDeviceIdIfNeeded() {
        DeviceTracking deviceTracking = this;
        synchronized (deviceTracking) {
            block16: {
                Object object;
                block18: {
                    block17: {
                        if (deviceTracking.isGeneratingDeviceId) break block16;
                        if (this.isDeviceIdValid()) break block16;
                        DeviceTracking deviceTracking2 = this;
                        DeviceTracking deviceTracking3 = deviceTracking2;
                        deviceTracking2.isGeneratingDeviceId = true;
                        // ** MonitorExit[v1] (shouldn't be in output)
                        deviceTracking2.api.viewer = this.storage.getViewer();
                        deviceTracking2.api.sdkId = this.storage.getSDKId();
                        try {
                            object = deviceTracking3.api.getDeviceId(this.context, this.storage.getDeviceId());
                        }
                        catch (Exception exception) {}
                        BaseAppInfoStorage baseAppInfoStorage = this.storage;
                        Api.DeviceIdResponse deviceIdResponse = object;
                        Api.DeviceIdResponse deviceIdResponse2 = deviceIdResponse;
                        String string2 = deviceIdResponse.deviceId;
                        long l = deviceIdResponse2.expireTime;
                        baseAppInfoStorage.setDeviceId(string2, l);
                        if (((Api.DeviceIdResponse)object).deviceId != null) break block17;
                        object = "";
                        break block18;
                    }
                    object = ((Api.DeviceIdResponse)object).deviceId;
                }
                this.callbackAndResetListener((String)object);
                DeviceTracking deviceTracking4 = this;
                synchronized (deviceTracking4) {
                    deviceTracking4.isGeneratingDeviceId = false;
                    return;
                }
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    public JSONObject prepareTrackingData() {
        return this.api.prepareTrackingData(this.context, this.storage.getDeviceId(), System.currentTimeMillis());
    }

    public JSONObject prepareCommonHeaderData() {
        return this.api.prepareCommonHeaderData(this.context);
    }

    public JSONObject prepareExtraInfo(int n) {
        return this.api.prepareExtraInfo(n);
    }

    public JSONObject prepareDeviceIdData() {
        return this.api.prepareDeviceIdData(this.context);
    }

    public synchronized void initDeviceTracking(Context context, BaseAppInfoStorage baseAppInfoStorage, String string2) {
        if (this.isInitialized) {
            return;
        }
        DeviceTracking deviceTracking = this;
        this.storage = baseAppInfoStorage;
        this.context = context;
        deviceTracking.appID = string2;
        Api api = deviceTracking.api;
        api.appId = string2;
        api.isPreInstalled = baseAppInfoStorage.ispreInstalled();
        deviceTracking.isInitialized = true;
        deviceTracking.sendMessage(16384);
    }

    public String getSDKId() {
        if (!this.isInitialized) {
            return null;
        }
        return this.storage.getSDKId();
    }

    public String getPrivateKey() {
        if (!this.isInitialized) {
            return null;
        }
        String string2 = this.storage.getPrivateKey();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        this.sendMessage(16386);
        return null;
    }

    public String getDeviceId() {
        if (!this.isInitialized) {
            return null;
        }
        if (!this.isDeviceIdValid()) {
            this.sendMessage(16385);
        }
        return this.storage.getDeviceId();
    }

    public long getDeviceIdExpireTime() {
        if (!this.isInitialized) {
            return 0L;
        }
        return this.storage.getDeviceIdExpiredTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getDeviceId(GetInfoListener getInfoListener) {
        if (this.hasDeviceId()) {
            if (getInfoListener != null) {
                getInfoListener.onGetDeviceIdComplete(this.storage.getDeviceId());
            }
            if (this.isDeviceIdValid()) return;
            this.sendMessage(16385);
            return;
        }
        if (getInfoListener != null) {
            DeviceTracking deviceTracking = this;
            synchronized (deviceTracking) {
                deviceTracking.infoListeners.add(getInfoListener);
            }
        }
        if (!this.isInitialized) return;
        this.sendMessage(16385);
    }

    public boolean handleMessage(Message message) {
        switch (message.what) {
            default: {
                return false;
            }
            case 16386: {
                this.generateSDKIdIfNeeded();
                break;
            }
            case 16385: {
                this.generateDeviceIdIfNeeded();
                break;
            }
            case 16384: {
                DeviceTracking deviceTracking = this;
                deviceTracking.loadDeviceId();
                deviceTracking.storage.loadSDKId();
                deviceTracking.generateSDKIdIfNeeded();
            }
        }
        return true;
    }

    public String getVersion() {
        return "4.1.1101";
    }

    public static interface GetInfoListener {
        public void onGetDeviceIdComplete(String var1);
    }
}

