/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.core.helper;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Base64;
import com.zing.zalo.zalosdk.core.log.Log;
import java.net.URLEncoder;
import java.security.MessageDigest;

public class AppInfo {
    private static String applicationHashKey;
    private static String firstRunDate;
    private static AppInfo __instance;
    private String appId;
    private String facebookAppId;
    String versionName;
    int versionCode;
    String packageName;
    String appName;
    String firstInstallDate;
    String installDate;
    String lastUpdateDate;
    String installerPackageName;
    String preloadChannel;
    private boolean isAutoTrackingOpenApp;

    public static synchronized AppInfo getInstance(Context context) {
        if (__instance == null) {
            __instance = new AppInfo(context);
        }
        return __instance;
    }

    static synchronized void reset() {
        __instance = null;
    }

    private AppInfo(Context context) {
        AppInfo appInfo = this;
        appInfo.preloadChannel = "";
        appInfo.extractBasicAppInfo(context);
    }

    public static String getAppId(Context context) {
        return AppInfo.getInstance((Context)context).appId;
    }

    public static Long getAppIdLong(Context context) {
        try {
            return Long.parseLong(AppInfo.getInstance((Context)context).appId);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static String getFacebookAppId(Context context) {
        return AppInfo.getInstance((Context)context).facebookAppId;
    }

    public static String getVersionName(Context context) {
        return AppInfo.getInstance((Context)context).versionName;
    }

    public static int getVersionCode(Context context) {
        return AppInfo.getInstance((Context)context).versionCode;
    }

    public static String getPackageName(Context context) {
        return AppInfo.getInstance((Context)context).packageName;
    }

    public static String getAppName(Context context) {
        return AppInfo.getInstance((Context)context).appName;
    }

    public static String getFirstInstallDate(Context context) {
        return AppInfo.getInstance((Context)context).firstInstallDate;
    }

    public static String getInstallDate(Context context) {
        return AppInfo.getInstance((Context)context).installDate;
    }

    public static String getLastUpdateDate(Context context) {
        return AppInfo.getInstance((Context)context).lastUpdateDate;
    }

    public static String getInstallerPackageName(Context context) {
        return AppInfo.getInstance((Context)context).installerPackageName;
    }

    public static String getPreloadChannel(Context context) {
        return AppInfo.getInstance((Context)context).preloadChannel;
    }

    public static String getApplicationHashKey(Context signatureArray) {
        String string2 = applicationHashKey;
        if (string2 != null) {
            return string2;
        }
        signatureArray = signatureArray.getPackageManager().getPackageInfo((String)signatureArray.getPackageName(), (int)64).signatures;
        int n = signatureArray.getPackageManager().getPackageInfo((String)signatureArray.getPackageName(), (int)64).signatures.length;
        for (int i = 0; i < n; ++i) {
            Signature signature = signatureArray[i];
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update(signature.toByteArray());
                applicationHashKey = Base64.encodeToString((byte[])messageDigest.digest(), (int)0).trim();
                continue;
            }
            catch (Exception exception) {
                Log.e("getApplicationHashKey", exception);
                break;
            }
        }
        return applicationHashKey;
    }

    public static String getFirstRunDate(Context context) {
        String string2 = firstRunDate;
        if (string2 != null) {
            return string2;
        }
        firstRunDate = (context = context.getSharedPreferences("zacPref", 0)).getString("first_run_date", null);
        if (firstRunDate == null) {
            firstRunDate = String.valueOf(System.currentTimeMillis());
            SharedPreferences.Editor editor = context.edit();
            editor.putString("first_run_date", firstRunDate);
            editor.apply();
        }
        return firstRunDate;
    }

    public static boolean isAutoTrackingOpenApp(Context context) {
        return AppInfo.getInstance((Context)context).isAutoTrackingOpenApp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractBasicAppInfo(Context object) {
        Object object2 = object.getPackageManager();
        String string2 = object.getPackageName();
        this.packageName = string2;
        PackageInfo packageInfo = object2.getPackageInfo(string2, 4096);
        ApplicationInfo applicationInfo = object2.getApplicationInfo(this.packageName, 128);
        this.versionName = packageInfo.versionName;
        this.versionCode = packageInfo.versionCode;
        this.appName = URLEncoder.encode(String.valueOf(packageInfo.applicationInfo.loadLabel((PackageManager)object2)), "UTF-8");
        this.installerPackageName = object2.getInstallerPackageName(this.packageName);
        if (Build.VERSION.SDK_INT >= 9) {
            this.installDate = String.valueOf(packageInfo.firstInstallTime);
            this.firstInstallDate = String.valueOf(packageInfo.firstInstallTime);
            this.lastUpdateDate = String.valueOf(packageInfo.lastUpdateTime);
        } else {
            AppInfo appInfo = this;
            appInfo.installDate = "";
            appInfo.firstInstallDate = "";
            appInfo.lastUpdateDate = "";
        }
        AppInfo appInfo = this;
        Bundle bundle = applicationInfo.metaData;
        object2 = appInfo.getStringValue(bundle, "com.zing.zalo.zalosdk.appID");
        try {
            this.appId = object2;
            if (object2 == null || ((String)object2).trim().length() == 0) {
                this.appId = this.getStringValue(bundle, "appID");
            }
            this.isAutoTrackingOpenApp = this.getBooleanValue(bundle, "com.zing.zalosdk.configAutoTrackingActivity");
            this.preloadChannel = this.getStringValue(bundle, "com.zalo.sdk.preloadChannel");
            this.facebookAppId = this.getStringValue(bundle, "com.facebook.sdk.ApplicationId");
            return;
        }
        catch (Exception exception) {
            Log.e("extractBasicAppInfo", exception);
        }
    }

    private String getStringValue(Bundle bundle, String string2) {
        Object object;
        block4: {
            object = null;
            if (!bundle.containsKey(string2)) break block4;
            try {
                object = bundle.getString(string2);
            }
            catch (Exception exception) {
                Log.v(exception.toString());
            }
        }
        if (object == null) {
            object = "";
        }
        return object;
    }

    private boolean getBooleanValue(Bundle bundle, String string2) {
        block3: {
            if (!bundle.containsKey(string2)) break block3;
            try {
                return bundle.getBoolean(string2);
            }
            catch (Exception exception) {
                Log.v(exception.toString());
            }
        }
        return false;
    }

    public static void launchMarketApp(Context context, String string2) {
        Intent intent;
        Context context2 = context;
        Intent intent2 = intent;
        intent = new Intent("android.intent.action.VIEW");
        Intent intent3 = intent;
        intent.addFlags(0x10000000);
        intent3.setData(Uri.parse((String)("market://details?id=" + string2)));
        try {
            context2.startActivity(intent2);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Intent intent4 = new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + string2)));
            intent4.addFlags(0x10000000);
            context.startActivity(intent4);
        }
    }

    public static boolean isPackageExists(Context context, String string2) {
        try {
            context.getPackageManager().getPackageInfo(string2, 128);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static String getReferrer(Context context) {
        try {
            return context.getSharedPreferences("zacCookie", 0).getString("referrer", "");
        }
        catch (Exception exception) {
            return "";
        }
    }
}

