/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.core.helper;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapHelper {
    public static Bitmap b64ToImage(String string2) {
        byte[] byArray = Base64.decode((String)string2, (int)0);
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteFilePhoto(String string2) {
        File file;
        File file2 = file;
        try {
            if (!new File(string2).exists()) return;
        }
        catch (Exception exception) {}
        file2.delete();
        return;
    }

    public static Bitmap rotateImage(Bitmap bitmap, float f) {
        Matrix matrix;
        Bitmap bitmap2 = bitmap;
        bitmap = null;
        Matrix matrix2 = matrix;
        matrix2();
        matrix.postRotate(f);
        int n = 0;
        int n2 = 0;
        int n3 = bitmap2.getWidth();
        int n4 = bitmap2.getHeight();
        try {
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)n, (int)n2, (int)n3, (int)n4, (Matrix)matrix2, (boolean)true);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap getDownsampledBitmap(Bitmap bitmap, int n) {
        if (bitmap != null && bitmap.getWidth() != 0 && bitmap.getHeight() != 0 && n >= 16) {
            int n2 = 0;
            for (int i = BitmapHelper.getBitmapSize(bitmap); i > n; i /= 4) {
                ++n2;
            }
            Bitmap bitmap2 = bitmap;
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)(bitmap2.getWidth() >> n2), (int)(bitmap.getHeight() >> n2), (boolean)true);
            if (bitmap == null) {
                return null;
            }
            if (BitmapHelper.getBitmapSize(bitmap) > n) {
                Bitmap bitmap3 = bitmap;
                return Bitmap.createScaledBitmap((Bitmap)bitmap3, (int)(bitmap3.getWidth() >> 1), (int)(bitmap.getHeight() >> 1), (boolean)true);
            }
            return bitmap;
        }
        return bitmap;
    }

    public static Bitmap getBitmapReSampleSize(byte[] byArray, int n) {
        Bitmap bitmap;
        double d;
        BitmapFactory.Options options;
        byte[] byArray2 = byArray;
        byte[] byArray3 = byArray;
        BitmapFactory.Options options2 = options;
        new BitmapFactory.Options().inJustDecodeBounds = true;
        int n2 = 0;
        try {
            BitmapFactory.decodeByteArray((byte[])byArray3, (int)n2, (int)byArray2.length, (BitmapFactory.Options)options2);
        }
        catch (Exception exception) {
            return null;
        }
        n2 = 1;
        while (true) {
            double d2;
            double d3 = options2.outWidth * options2.outHeight;
            double d4 = d3 * (1.0 / Math.pow(n2, 2.0));
            d = n;
            if (!(d4 > d2)) break;
            ++n2;
        }
        if (n2 > 1) {
            BitmapFactory.Options options3;
            int n3 = n2 + -1;
            BitmapFactory.Options options4 = options3;
            options4();
            options3.inSampleSize = n3;
            n3 = 0;
            Bitmap bitmap2 = BitmapFactory.decodeByteArray((byte[])byArray, (int)n3, (int)byArray.length, (BitmapFactory.Options)options4);
            Bitmap bitmap3 = bitmap2;
            Bitmap bitmap4 = bitmap2;
            double d5 = d;
            n3 = options4.outHeight;
            double d6 = options4.outWidth;
            double d7 = n3;
            double d8 = Math.sqrt(d5 / (d6 / d7));
            int n4 = (int)(d8 / d7 * d6);
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap3, (int)n4, (int)((int)d8), (boolean)true);
            bitmap4.recycle();
        } else {
            int n5 = 0;
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)n5, (int)byArray.length);
        }
        return bitmap;
    }

    public static int getBitmapSize(Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static Bitmap handleSamplingAndRotationBitmap(Context context, Uri uri, int n, int n2, String string2) throws IOException {
        BitmapFactory.Options options;
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        InputStream inputStream = context.getContentResolver().openInputStream(uri);
        BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options2);
        inputStream.close();
        options.inSampleSize = BitmapHelper.calculateInSampleSize(options, n, n2);
        options.inJustDecodeBounds = false;
        return BitmapHelper.rotateImageIfRequired(BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(uri), null, (BitmapFactory.Options)options2), string2);
    }

    static int calculateInSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3;
        int n4 = options.outHeight;
        int n5 = options.outWidth;
        int n6 = 1;
        if (n4 <= n2 && n5 <= n) {
            n3 = n6;
        } else {
            int n7;
            n6 = Math.round((float)n4 / (float)n2);
            if (n6 < (n3 = Math.round((float)n5 / (float)n))) {
                n3 = n6;
            }
            float f = n5 * n4;
            float f2 = n * n2 * 2;
            do {
                n7 = n3++;
            } while (f / (float)(n7 * n7) > f2);
        }
        return n3;
    }

    static Bitmap rotateImageIfRequired(Bitmap bitmap, String string2) throws IOException {
        int n = new ExifInterface(string2).getAttributeInt("Orientation", 1);
        if (n != 3) {
            if (n != 6) {
                if (n != 8) {
                    return bitmap;
                }
                return BitmapHelper.rotateImage(bitmap, 270);
            }
            return BitmapHelper.rotateImage(bitmap, 90);
        }
        return BitmapHelper.rotateImage(bitmap, 180);
    }

    private static Bitmap rotateImage(Bitmap bitmap, int n) {
        Matrix matrix;
        Bitmap bitmap2 = bitmap;
        Matrix matrix2 = matrix;
        matrix2();
        matrix.postRotate((float)n);
        n = bitmap2.getWidth();
        int n2 = bitmap2.getHeight();
        Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true);
        bitmap.recycle();
        return bitmap3;
    }

    public static String getRealPathFromURI(Context object, Uri uri) {
        if ((object = object.getContentResolver().query(uri, null, null, null, null)) == null) {
            object = uri.getPath();
        } else {
            Context context = object;
            context.moveToFirst();
            object = context.getString(context.getColumnIndex("_data"));
            context.close();
        }
        return object;
    }

    public static byte[] toByteArray(Bitmap object) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (object == null) {
            return new byte[0];
        }
        Bitmap bitmap = object;
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)object);
        return ((ByteArrayOutputStream)object).toByteArray();
    }
}

