/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.core.http;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.zalosdk.ZaloOAuthResultCode;
import com.zing.zalo.zalosdk.core.log.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpClientRequest {
    private static final String LINE_END = "\r\n";
    private static final String TWO_HYPHENS = "--";
    private static final String BOUNDARY = "*****";
    public int liveResponseCode;
    private Type mType;
    private String mUrl;
    private Map<String, String> mParams;
    private Map<String, String> mHeader;
    private String fileName;
    private String fileKey;
    private byte[] data;

    public HttpClientRequest(Type type, String string) {
        HttpClientRequest httpClientRequest = this;
        this.mType = type;
        httpClientRequest.mUrl = string;
        httpClientRequest.mHeader = new HashMap<String, String>();
        httpClientRequest.mParams = new HashMap<String, String>();
        httpClientRequest.addHeader("SDK-Source", "ZaloSDK-4.1.1101");
        httpClientRequest.addHeader("extInfo", DeviceTracking.getInstance().prepareCommonHeaderData().toString());
    }

    private String getQueryString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("");
        Map<String, String> map = this.mParams;
        if (map != null) {
            map = map.keySet().iterator();
            while (map.hasNext()) {
                StringBuilder stringBuilder3 = stringBuilder2;
                StringBuilder stringBuilder4 = stringBuilder2;
                String string = (String)map.next();
                try {
                    stringBuilder4.append(URLEncoder.encode(string, "UTF-8"));
                }
                catch (Exception exception) {
                    Log.w(exception.toString());
                    continue;
                }
                stringBuilder4.append("=");
                stringBuilder3.append(URLEncoder.encode(this.mParams.get(string), "UTF-8"));
                stringBuilder3.append("&");
            }
        }
        return stringBuilder2.toString();
    }

    public static byte[] getByteArray(String object) {
        InputStream inputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        URL uRL = new URL((String)object);
        object = new byte[4096];
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            Log.w(iOException.toString());
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            Log.w(malformedURLException.toString());
            return null;
        }
        while (true) {
            int n = inputStream.read((byte[])object);
            if (n <= 0) break;
            byteArrayOutputStream2.write((byte[])object, 0, n);
            continue;
            break;
        }
        return byteArrayOutputStream2.toByteArray();
    }

    public void addHeader(String string, String string2) {
        this.mHeader.put(string, string2);
    }

    public void addParams(String string, String string2) {
        this.mParams.put(string, string2);
    }

    public void setMultipartFile(String string, String string2, byte[] byArray) {
        HttpClientRequest httpClientRequest = this;
        httpClientRequest.fileName = string;
        httpClientRequest.fileKey = string2;
        httpClientRequest.data = byArray;
    }

    public void setBody(byte[] byArray) {
        this.data = byArray;
    }

    public String getJSONString() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        Map<String, String> map = this.mParams;
        if (map != null) {
            for (String string : map.keySet()) {
                try {
                    jSONObject2.put(string, (Object)this.mParams.get(string));
                }
                catch (Exception exception) {
                    Log.w(exception.toString());
                }
            }
        }
        return jSONObject2.toString(4);
    }

    public String getParamsString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("{");
        Map<String, String> map = this.mParams;
        if (map != null) {
            map = map.keySet().iterator();
            while (map.hasNext()) {
                StringBuilder stringBuilder3 = stringBuilder2;
                String string = (String)map.next();
                try {
                    stringBuilder3.append(string);
                }
                catch (Exception exception) {
                    Log.w(exception.toString());
                    continue;
                }
                stringBuilder3.append("=");
                stringBuilder2.append(this.mParams.get(string));
            }
        }
        StringBuilder stringBuilder4 = stringBuilder2;
        stringBuilder4.append("}");
        return stringBuilder4.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getResponse() throws Exception {
        Iterator<String> iterator;
        StringBuilder stringBuilder;
        Type type = ((HttpClientRequest)((Object)string3)).mType;
        if (type == Type.POST) {
            Object object;
            Log.v("connect server : " + ((HttpClientRequest)((Object)string3)).mUrl + " : " + ((HttpClientRequest)((Object)string3)).getQueryString());
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(((HttpClientRequest)((Object)string3)).mUrl).openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
            for (String string : ((HttpClientRequest)((Object)string3)).mHeader.keySet()) {
                httpURLConnection.setRequestProperty(string, ((HttpClientRequest)((Object)string3)).mHeader.get(string));
            }
            if (((HttpClientRequest)((Object)string3)).data != null) {
                object = httpURLConnection.getOutputStream();
                ((OutputStream)object).write(((HttpClientRequest)((Object)string3)).data);
            } else {
                HttpURLConnection httpURLConnection2 = httpURLConnection;
                httpURLConnection2.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                object = httpURLConnection2.getOutputStream();
                ((OutputStream)object).write(((HttpClientRequest)((Object)string3)).getQueryString().getBytes("UTF-8"));
            }
            Object object2 = object;
            ((OutputStream)object2).flush();
            ((OutputStream)object2).close();
            ((HttpClientRequest)((Object)string3)).liveResponseCode = httpURLConnection.getResponseCode();
            Log.v("connect server POST " + ((HttpClientRequest)((Object)string3)).liveResponseCode);
            return httpURLConnection.getInputStream();
        }
        if (type != Type.POST_MULIIPART) {
            StringBuilder stringBuilder2;
            stringBuilder = stringBuilder2;
            if (((HttpClientRequest)((Object)string3)).mUrl.contains("?")) {
                stringBuilder.append("&platform=android");
            } else {
                stringBuilder.append("?platform=android");
            }
            iterator = ((HttpClientRequest)((Object)string3)).mParams.keySet().iterator();
        } else {
            StringBuilder stringBuilder3;
            BufferedReader bufferedReader;
            String string;
            DataOutputStream dataOutputStream;
            Log.v("connect server : " + ((HttpClientRequest)((Object)string3)).mUrl + " : " + ((HttpClientRequest)((Object)string3)).getQueryString());
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(((HttpClientRequest)((Object)string3)).mUrl).openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setConnectTimeout(120000);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpURLConnection.setRequestProperty("ENCTYPE", "multipart/form-data");
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****");
            Object object = ((HttpClientRequest)((Object)string3)).fileName;
            if (object != null) {
                httpURLConnection.setRequestProperty("uploaded_file", (String)object);
            }
            for (String string2 : ((HttpClientRequest)((Object)string3)).mHeader.keySet()) {
                httpURLConnection.setRequestProperty(string2, ((HttpClientRequest)((Object)string3)).mHeader.get(string2));
            }
            object = dataOutputStream;
            dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            Iterator<String> iterator2 = ((HttpClientRequest)((Object)string3)).mParams.keySet().iterator();
            while (iterator2.hasNext()) {
                Object object3 = object;
                Object object4 = object;
                string = iterator2.next();
                ((DataOutputStream)object4).writeBytes("--*****\r\n");
                ((DataOutputStream)object4).writeBytes("Content-Disposition: form-data; name=\"" + string + "\"" + LINE_END);
                ((DataOutputStream)object4).writeBytes("Content-Type: text/plain; charset=UTF-8\r\n");
                ((DataOutputStream)object4).writeBytes(LINE_END);
                ((FilterOutputStream)object3).write(((HttpClientRequest)((Object)string3)).mParams.get(string).getBytes("UTF-8"));
                ((DataOutputStream)object3).writeBytes(LINE_END);
            }
            if (((HttpClientRequest)((Object)string3)).data != null && ((HttpClientRequest)((Object)string3)).fileName != null && ((HttpClientRequest)((Object)string3)).fileKey != null) {
                Object object5 = object;
                ((DataOutputStream)object5).writeBytes("--*****\r\n");
                ((DataOutputStream)object5).writeBytes("Content-Disposition: form-data; name=" + ((HttpClientRequest)((Object)string3)).fileKey + ";filename=" + ((HttpClientRequest)((Object)string3)).fileName + "" + LINE_END);
                ((DataOutputStream)object5).writeBytes(LINE_END);
                ((FilterOutputStream)object).write(((HttpClientRequest)((Object)string3)).data);
            }
            Object object6 = object;
            ((DataOutputStream)object6).writeBytes(LINE_END);
            ((DataOutputStream)object6).writeBytes("--*****--\r\n");
            ((DataOutputStream)object6).flush();
            ((FilterOutputStream)object6).close();
            int n = httpURLConnection.getResponseCode();
            Log.v("connect server POST_MULTIPART " + n);
            ((HttpClientRequest)((Object)string3)).liveResponseCode = httpURLConnection.getResponseCode();
            if (n < 300) {
                return httpURLConnection.getInputStream();
            }
            String string3 = System.getProperty("line.separator");
            BufferedReader bufferedReader2 = bufferedReader;
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream()));
            StringBuilder stringBuilder4 = stringBuilder3;
            stringBuilder3 = new StringBuilder();
            boolean bl = false;
            while (true) {
                if ((string = bufferedReader2.readLine()) == null) {
                    Log.v(stringBuilder4.toString());
                    return null;
                }
                Object object7 = bl ? string3 : "";
                stringBuilder4.append((String)object7).append(string);
                bl = true;
            }
        }
        while (iterator.hasNext()) {
            StringBuilder stringBuilder5;
            block24: {
                StringBuilder stringBuilder6 = stringBuilder;
                String string = iterator.next();
                stringBuilder.append("&");
                stringBuilder6.append(URLEncoder.encode(string, "UTF-8"));
                stringBuilder6.append("=");
                if (((HttpClientRequest)((Object)string3)).mParams.get(string) == null) break block24;
                stringBuilder5 = stringBuilder.append(URLEncoder.encode(((HttpClientRequest)((Object)string3)).mParams.get(string), "UTF-8").replace("+", "%20"));
            }
            try {
                stringBuilder5 = stringBuilder.append(URLEncoder.encode("", "UTF-8"));
            }
            catch (Exception exception) {
                Log.w(exception.toString());
            }
        }
        Log.v("connect server GET : " + stringBuilder.toString());
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(stringBuilder.toString()).openConnection();
        iterator = ((HttpClientRequest)((Object)string3)).mHeader.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                ((HttpClientRequest)((Object)string3)).liveResponseCode = httpURLConnection.getResponseCode();
                return httpURLConnection.getInputStream();
            }
            String string = iterator.next();
            httpURLConnection.setRequestProperty(string, ((HttpClientRequest)((Object)string3)).mHeader.get(string));
        }
    }

    /*
     * Unable to fully structure code
     */
    public String getText() {
        var1_1 = v0;
        v0 = new BufferedReader(new InputStreamReader(this.getResponse()));
        this = v1;
        try {
            v1 = new StringBuilder();
            ** while ((var2_2 = var1_1.readLine()) != null)
        }
        catch (Exception v2) {
            Log.w(v2.toString());
            return null;
        }
lbl-1000:
        // 1 sources

        {
            block9: {
                if (this.length() <= 0) break block9;
                this.append("\n");
            }
            this.append(var2_2);
            continue;
        }
lbl22:
        // 2 sources

        var1_1.close();
        return this.toString();
    }

    /*
     * Unable to fully structure code
     */
    public JSONObject getJSON() {
        var1_3 = "";
        var2_4 = v0;
        v0 = new BufferedReader(new InputStreamReader(this.getResponse()));
        var3_5 = v1;
        try {
            v1 = new StringBuilder();
            ** while ((var4_6 = var2_4.readLine()) != null)
        }
        catch (Exception var0_2) {
            try {
                v2 = v3;
                v3 = new JSONObject();
                v4 = v3;
            }
            catch (JSONException v5) {
                v5.printStackTrace();
                Log.w(var0_2.toString());
                return null;
            }
            v2.put("errorMsg", (Object)(var1_3 + "  " + var0_2.toString()));
            return v4;
        }
lbl-1000:
        // 1 sources

        {
            v6 = var3_5;
            v7 = v6;
            v6.append(var4_6);
            v7.append("\n");
            continue;
        }
lbl32:
        // 2 sources

        var2_4.close();
        var1_3 = var3_5.toString();
        Log.v("getJSON() from: " + this.mUrl + "=" + var1_3);
        v8 = v9;
        v10 = v9;
        v9 = new JSONObject(var1_3);
        v11 = v9;
        var0_1 = v9.optInt("error");
        v8.put("error", ZaloOAuthResultCode.findById(var0_1));
        v10.put("extCode", var0_1);
        return v11;
    }

    public Bitmap getImage() {
        Bitmap bitmap;
        block4: {
            try {
                InputStream inputStream = ((HttpClientRequest)((Object)inputStream)).getResponse();
                bitmap = null;
                if (inputStream == null) break block4;
            }
            catch (Exception exception) {
                return null;
            }
            Object object = inputStream;
            Object object2 = object;
            bitmap = BitmapFactory.decodeStream((InputStream)object);
            ((InputStream)object2).close();
        }
        return bitmap;
    }

    public int getResponseCode() {
        try {
            return ((HttpURLConnection)new URL(this.mUrl).openConnection()).getResponseCode();
        }
        catch (Exception exception) {
            Log.w(exception.toString());
            return 0;
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type GET;
        public static final /* enum */ Type POST;
        public static final /* enum */ Type POST_MULIIPART;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        static {
            Type type;
            GET = new Type();
            POST = new Type();
            Type type2 = type;
            POST_MULIIPART = new Type();
            $VALUES = new Type[]{GET, POST, type2};
        }
    }
}

