/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.core.log;

import android.os.Environment;
import com.zing.zalo.zalosdk.ZaloSDKContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Locale;

public class Log {
    public static Boolean LOG_WRITABLE = false;
    private static final String LOG_FILE_NAME = "zalosdk-log-trace.txt";
    private static final String LOG_TAG = "ZDK";
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    private static int logLevel = 5;

    public static void setLogLevel(int n) {
        logLevel = n;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void d(String string2) {
        Log.d(LOG_TAG, string2);
    }

    public static void d(String string2, Object ... objectArray) {
        Log.d(LOG_TAG, string2, objectArray);
    }

    public static void d(String string2, String string3) {
        Log.log(3, string2, string3);
    }

    public static void d(Class<?> clazz, String string2) {
        Log.log(3, clazz.getSimpleName(), string2);
    }

    public static void d(String string2, String string3, Object ... objectArray) {
        Log.log(3, string2, string3, objectArray);
    }

    public static void d(Class<?> clazz, String string2, Object ... objectArray) {
        Log.log(3, clazz.getSimpleName(), string2, objectArray);
    }

    public static void e(String string2) {
        Log.e(LOG_TAG, string2);
    }

    public static void e(String string2, Object ... objectArray) {
        Log.e(LOG_TAG, string2, objectArray);
    }

    public static void e(String string2, String string3) {
        Log.log(6, string2, string3);
    }

    public static void e(Class<?> clazz, String string2) {
        Log.log(6, clazz.getSimpleName(), string2);
    }

    public static void e(String string2, String string3, Object ... objectArray) {
        Log.log(6, string2, string3, objectArray);
    }

    public static void e(Class<?> clazz, String string2, Object ... objectArray) {
        Log.log(6, clazz.getSimpleName(), string2, objectArray);
    }

    public static void e(Exception exception) {
        Log.e(LOG_TAG, exception);
    }

    public static void e(String string2, Exception object) {
        object = android.util.Log.getStackTraceString((Throwable)object);
        Log.log(6, string2, (String)object);
    }

    public static void e(Class<?> object, Exception exception) {
        Class<?> clazz = object;
        object = android.util.Log.getStackTraceString((Throwable)exception);
        Log.log(6, clazz.getSimpleName(), (String)object);
    }

    public static void i(String string2) {
        Log.i(LOG_TAG, string2);
    }

    public static void i(String string2, Object ... objectArray) {
        Log.i(LOG_TAG, string2, objectArray);
    }

    public static void i(String string2, String string3) {
        Log.log(4, string2, string3);
    }

    public static void i(Class<?> clazz, String string2) {
        Log.log(4, clazz.getSimpleName(), string2);
    }

    public static void i(String string2, String string3, Object ... objectArray) {
        Log.log(4, string2, string3, objectArray);
    }

    public static void i(Class<?> clazz, String string2, Object ... objectArray) {
        Log.log(4, clazz.getSimpleName(), string2, objectArray);
    }

    public static void v(String string2) {
        Log.v(LOG_TAG, string2);
    }

    public static void v(String string2, Object ... objectArray) {
        Log.v(LOG_TAG, string2, objectArray);
    }

    public static void v(String string2, String string3) {
        Log.log(2, string2, string3);
    }

    public static void v(Class<?> clazz, String string2) {
        Log.log(2, clazz.getSimpleName(), string2);
    }

    public static void v(String string2, String string3, Object ... objectArray) {
        Log.log(2, string2, string3, objectArray);
    }

    public static void v(Class<?> clazz, String string2, Object ... objectArray) {
        Log.log(2, clazz.getSimpleName(), string2, objectArray);
    }

    public static void w(String string2) {
        Log.w(LOG_TAG, string2);
    }

    public static void w(String string2, Object ... objectArray) {
        Log.w(LOG_TAG, string2, objectArray);
    }

    public static void w(String string2, String string3) {
        Log.log(5, string2, string3);
    }

    public static void w(Class<?> clazz, String string2) {
        Log.log(5, clazz.getSimpleName(), string2);
    }

    public static void w(String string2, String string3, Object ... objectArray) {
        Log.log(5, string2, string3, objectArray);
    }

    public static void w(Class<?> clazz, String string2, Object ... objectArray) {
        Log.log(5, clazz.getSimpleName(), string2, objectArray);
    }

    private static void log(int n, String string2, String string3, Object ... objectArray) {
        if (string3 == null) {
            return;
        }
        String string4 = String.format(Locale.getDefault(), string3, objectArray);
        Log.log(n, string2, string4);
        Log.writeLogFile(n, string2, string4);
    }

    private static void log(int n, String string2, String string3) {
        if (n < logLevel) {
            return;
        }
        int n2 = n;
        android.util.Log.println((int)n2, (String)string2, (String)string3);
        Log.writeLogFile(n2, string2, string3);
    }

    private static void writeLogFile(int n, String string2, String string3) {
        if (LOG_WRITABLE.booleanValue()) {
            if (n == 6 || n == 5) {
                Log.writeToFile(string2 + "\n\t" + string3 + "\n\n");
            }
        } else {
            Log.removeLogFileInDevice();
        }
    }

    private static void removeLogFileInDevice() {
        File file;
        String string2 = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/com.google.android.zdt.data/" + LOG_FILE_NAME;
        File file2 = file;
        new File(string2).getParentFile().mkdirs();
        if (file2.exists()) {
            file2.delete();
        }
    }

    private static void writeToFile(String string2) {
        try {
            Log.writeFileData(string2, Log.prepareFileInExternalStore());
        }
        catch (Exception exception) {}
    }

    private static void writeFileData(String string2, File file) throws IOException {
        FileOutputStream fileOutputStream;
        FileOutputStream fileOutputStream2 = fileOutputStream;
        fileOutputStream = new FileOutputStream(file, true);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream2);
        outputStreamWriter.write(string2);
        outputStreamWriter.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private static File prepareFileInExternalStore() {
        File file;
        Object object = ZaloSDKContext.getInstance().getApplicationContext();
        if (object == null) {
            return null;
        }
        object = object.getExternalFilesDir(null) + LOG_FILE_NAME;
        File file2 = file;
        new File((String)object).getParentFile().mkdirs();
        if (!file2.exists()) {
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }
}

