/*
 * Decompiled with CFR 0.152.
 */
package com.zing.zalo.zalosdk.core.servicemap;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.zing.zalo.zalosdk.Constant;
import com.zing.zalo.zalosdk.core.http.HttpClientFactory;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapListener;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapStorage;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapTools;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ServiceMapManager {
    public static final String KEY_URL_OAUTH = "oauth_http_s";
    public static final String KEY_URL_GRAPH = "graph_http_s";
    public static final String KEY_URL_CENTRALIZED = "centralized_http_s";
    private static final String URL_OAUTH = "https://oauth.zaloapp.com";
    private static final String URL_GRAPH = "https://graph.zaloapp.com";
    private static final String URL_CENTRALIZED = "https://ztevents.zaloapp.com";
    private static final String URL_DEV_OAUTH = "https://dev-oauth.zaloapp.com";
    private static final String URL_DEV_GRAPH = "https://graph.zaloapp.com";
    private static final String URL_DEV_CENTRALIZED = "https://ztevents.zaloapp.com";
    private static final long ONE_DATE_DURATION = 86400000L;
    public static final String[] SERVICE_MAP_URLS = new String[]{"https://mp3.zing.vn/zdl/service_map_all.bin", "https://zaloapp.com/zdl/service_map_all.bin", "https://news.zing.vn/zdl/service_map_all.bin", "https://n.zing.vn/zdl/service_map_all.bin", "https://srv.mp3.zing.vn/zdl/service_map_all.bin"};
    private static ServiceMapManager instance;
    private long expireTime = -1L;
    private HttpClientFactory httpClientFactory = new HttpClientFactory();
    private Map<String, String> urls = new HashMap<String, String>();
    private ServiceMapStorage storage;

    public static synchronized ServiceMapManager getInstance() {
        if (instance == null) {
            instance = new ServiceMapManager();
        }
        return instance;
    }

    public static synchronized void destroyInstance() {
        if (instance != null) {
            instance = null;
        }
    }

    private ServiceMapManager() {
        if (Constant.IS_DEV.booleanValue()) {
            ServiceMapManager serviceMapManager = this;
            serviceMapManager.urls.put(KEY_URL_OAUTH, URL_DEV_OAUTH);
            serviceMapManager.urls.put(KEY_URL_GRAPH, "https://graph.zaloapp.com");
            serviceMapManager.urls.put(KEY_URL_CENTRALIZED, "https://ztevents.zaloapp.com");
        } else {
            ServiceMapManager serviceMapManager = this;
            serviceMapManager.urls.put(KEY_URL_OAUTH, URL_OAUTH);
            serviceMapManager.urls.put(KEY_URL_GRAPH, "https://graph.zaloapp.com");
            serviceMapManager.urls.put(KEY_URL_CENTRALIZED, "https://ztevents.zaloapp.com");
        }
    }

    private void updateMapUrls(String string2, String string3, String string4, Context object) {
        long l;
        object = this.getStorage((Context)object);
        ServiceMapManager serviceMapManager = this;
        ((ServiceMapStorage)object).setKeyUrlCentralized(string4);
        ((ServiceMapStorage)object).setKeyUrlGraph(string3);
        ((ServiceMapStorage)object).setKeyUrlOauth(string2);
        serviceMapManager.urls.put(KEY_URL_OAUTH, string2);
        serviceMapManager.urls.put(KEY_URL_GRAPH, string3);
        serviceMapManager.urls.put(KEY_URL_CENTRALIZED, string4);
        serviceMapManager.expireTime = l = System.currentTimeMillis() + 86400000L;
        ((ServiceMapStorage)object).setExpireTime(l);
    }

    private void updateMapUrlsFromPreference(Context object) {
        ServiceMapStorage serviceMapStorage = this.getStorage((Context)object);
        object = serviceMapStorage.getKeyUrlOauth();
        String string2 = serviceMapStorage.getKeyUrlGraph();
        String string3 = serviceMapStorage.getKeyUrlCentralized();
        if (!(TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3))) {
            ServiceMapManager serviceMapManager = this;
            serviceMapManager.urls.put(KEY_URL_OAUTH, (String)object);
            serviceMapManager.urls.put(KEY_URL_GRAPH, string2);
            serviceMapManager.urls.put(KEY_URL_CENTRALIZED, string3);
        }
    }

    public void load(final Context context) {
        this.updateMapUrlsFromPreference(context);
        if (this.isExpiredTime(context) && !Constant.IS_DEV.booleanValue()) {
            new DownloadServiceMapFilesAsyncTask(this.httpClientFactory, new ServiceMapListener(){

                @Override
                public void receiveJSONObject(JSONObject object) {
                    if (object == null) {
                        Log.v("Service map not found!");
                        return;
                    }
                    1 v0 = this;
                    JSONObject jSONObject = object;
                    JSONObject jSONObject2 = jSONObject;
                    JSONObject jSONObject3 = jSONObject;
                    object = jSONObject.getJSONArray(ServiceMapManager.KEY_URL_OAUTH).getString(0);
                    String string2 = jSONObject3.getJSONArray(ServiceMapManager.KEY_URL_GRAPH).getString(0);
                    String string3 = jSONObject2.getJSONArray(ServiceMapManager.KEY_URL_CENTRALIZED).getString(0);
                    try {
                        Log.v("Got service map: ");
                        Log.v("oath: " + (String)object);
                        Log.v("graph: " + string2);
                        Log.v("centralized: " + string3);
                        v0.ServiceMapManager.this.updateMapUrls((String)object, string2, string3, context);
                    }
                    catch (Exception exception) {
                        Log.v(exception.getMessage());
                    }
                }
            }).execute(new Integer[0]);
        }
    }

    public String urlFor(String string2, String string3) {
        String string4 = ((ServiceMapManager)((Object)string4)).urls.get(string2);
        if (string4 == null) {
            Log.v("Url for" + string2 + "not found");
            return string3;
        }
        if (!string4.endsWith("/") && !string3.startsWith("/")) {
            return (String)string4 + "/" + string3;
        }
        return (String)string4 + string3;
    }

    public boolean isExpiredTime(Context object) {
        ServiceMapManager serviceMapManager = this;
        long l = System.currentTimeMillis();
        object = serviceMapManager.getStorage((Context)object);
        if (serviceMapManager.expireTime == -1L) {
            long l2 = ((ServiceMapStorage)object).getExpireTime() != 0L ? ((ServiceMapStorage)object).getExpireTime() : l;
            this.expireTime = l2;
        }
        return l >= this.expireTime;
    }

    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public ServiceMapStorage getStorage(Context context) {
        if (this.storage == null) {
            ServiceMapStorage serviceMapStorage;
            ServiceMapStorage serviceMapStorage2 = serviceMapStorage;
            serviceMapStorage = new ServiceMapStorage(context);
            this.storage = serviceMapStorage2;
        }
        return this.storage;
    }

    public void setStorage(ServiceMapStorage serviceMapStorage) {
        this.storage = serviceMapStorage;
    }

    public static class DownloadServiceMapFilesAsyncTask
    extends AsyncTask<Integer, Void, JSONObject> {
        private final HttpClientFactory httpClientFactory;
        private ServiceMapListener listener;

        DownloadServiceMapFilesAsyncTask(HttpClientFactory httpClientFactory, ServiceMapListener serviceMapListener) {
            this.httpClientFactory = httpClientFactory;
            this.listener = serviceMapListener;
        }

        protected JSONObject doInBackground(Integer ... objectArray) {
            objectArray = SERVICE_MAP_URLS;
            int n = SERVICE_MAP_URLS.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                try {
                    object = ServiceMapTools.decryptString(this.httpClientFactory.newRequest(HttpClientRequest.Type.GET, (String)object).getText());
                }
                catch (Exception exception) {
                    Log.e("DownloadServiceMapFilesAsyncTask", exception.getMessage());
                    continue;
                }
                return new JSONObject((String)object);
            }
            return null;
        }

        protected void onPostExecute(JSONObject jSONObject) {
            this.listener.receiveJSONObject(jSONObject);
        }
    }
}

