/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import me.zhanghai.android.fastscroll.FastScroller;

public class DefaultAnimationHelper
implements FastScroller.AnimationHelper {
    private static final int SHOW_DURATION_MILLIS = 150;
    private static final int HIDE_DURATION_MILLIS = 200;
    private static final Interpolator SHOW_SCROLLBAR_INTERPOLATOR = new LinearOutSlowInInterpolator();
    private static final Interpolator HIDE_SCROLLBAR_INTERPOLATOR = new FastOutLinearInInterpolator();
    private static final int AUTO_HIDE_SCROLLBAR_DELAY_MILLIS = 1500;
    @NonNull
    private final View mView;
    private boolean mScrollbarAutoHideEnabled = true;
    private boolean mShowingScrollbar = true;
    private boolean mShowingPopup;

    public DefaultAnimationHelper(@NonNull View view) {
        this.mView = view;
    }

    @Override
    public void showScrollbar(@NonNull View trackView, @NonNull View thumbView) {
        if (this.mShowingScrollbar) {
            return;
        }
        this.mShowingScrollbar = true;
        trackView.animate().alpha(1.0f).translationX(0.0f).setDuration(150L).setInterpolator((TimeInterpolator)SHOW_SCROLLBAR_INTERPOLATOR).start();
        thumbView.animate().alpha(1.0f).translationX(0.0f).setDuration(150L).setInterpolator((TimeInterpolator)SHOW_SCROLLBAR_INTERPOLATOR).start();
    }

    @Override
    public void hideScrollbar(@NonNull View trackView, @NonNull View thumbView) {
        if (!this.mShowingScrollbar) {
            return;
        }
        this.mShowingScrollbar = false;
        boolean isLayoutRtl = this.mView.getLayoutDirection() == 1;
        int width = Math.max(trackView.getWidth(), thumbView.getWidth());
        float translationX = isLayoutRtl ? (trackView.getLeft() == 0 ? (float)(-width) : 0.0f) : (trackView.getRight() == this.mView.getWidth() ? (float)width : 0.0f);
        trackView.animate().alpha(0.0f).translationX(translationX).setDuration(200L).setInterpolator((TimeInterpolator)HIDE_SCROLLBAR_INTERPOLATOR).start();
        thumbView.animate().alpha(0.0f).translationX(translationX).setDuration(200L).setInterpolator((TimeInterpolator)HIDE_SCROLLBAR_INTERPOLATOR).start();
    }

    @Override
    public boolean isScrollbarAutoHideEnabled() {
        return this.mScrollbarAutoHideEnabled;
    }

    public void setScrollbarAutoHideEnabled(boolean enabled) {
        this.mScrollbarAutoHideEnabled = enabled;
    }

    @Override
    public int getScrollbarAutoHideDelayMillis() {
        return 1500;
    }

    @Override
    public void showPopup(@NonNull View popupView) {
        if (this.mShowingPopup) {
            return;
        }
        this.mShowingPopup = true;
        popupView.animate().alpha(1.0f).setDuration(150L).start();
    }

    @Override
    public void hidePopup(@NonNull View popupView) {
        if (!this.mShowingPopup) {
            return;
        }
        this.mShowingPopup = false;
        popupView.animate().alpha(0.0f).setDuration(200L).start();
    }
}

