/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ScrollView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import me.zhanghai.android.fastscroll.FastScroller;
import me.zhanghai.android.fastscroll.SimpleViewHelper;
import me.zhanghai.android.fastscroll.ViewHelperProvider;

@SuppressLint(value={"MissingSuperCall"})
public class FastScrollScrollView
extends ScrollView
implements ViewHelperProvider {
    @NonNull
    private final ViewHelper mViewHelper = new ViewHelper();

    public FastScrollScrollView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public FastScrollScrollView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FastScrollScrollView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public FastScrollScrollView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setVerticalScrollBarEnabled(false);
        this.setScrollContainer(true);
    }

    @Override
    @NonNull
    public FastScroller.ViewHelper getViewHelper() {
        return this.mViewHelper;
    }

    public void draw(@NonNull Canvas canvas) {
        this.mViewHelper.draw(canvas);
    }

    protected void onScrollChanged(int left, int top, int oldLeft, int oldTop) {
        this.mViewHelper.onScrollChanged(left, top, oldLeft, oldTop);
    }

    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        return this.mViewHelper.onInterceptTouchEvent(event);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        return this.mViewHelper.onTouchEvent(event);
    }

    private class ViewHelper
    extends SimpleViewHelper {
        private ViewHelper() {
        }

        @Override
        public int getScrollRange() {
            return super.getScrollRange() + FastScrollScrollView.this.getPaddingTop() + FastScrollScrollView.this.getPaddingBottom();
        }

        @Override
        protected void superDraw(@NonNull Canvas canvas) {
            FastScrollScrollView.super.draw(canvas);
        }

        @Override
        protected void superOnScrollChanged(int left, int top, int oldLeft, int oldTop) {
            FastScrollScrollView.super.onScrollChanged(left, top, oldLeft, oldTop);
        }

        @Override
        protected boolean superOnInterceptTouchEvent(@NonNull MotionEvent event) {
            return FastScrollScrollView.super.onInterceptTouchEvent(event);
        }

        @Override
        protected boolean superOnTouchEvent(@NonNull MotionEvent event) {
            return FastScrollScrollView.super.onTouchEvent(event);
        }

        @Override
        protected int computeVerticalScrollRange() {
            return FastScrollScrollView.this.computeVerticalScrollRange();
        }

        @Override
        protected int computeVerticalScrollOffset() {
            return FastScrollScrollView.this.computeVerticalScrollOffset();
        }

        @Override
        protected int getScrollX() {
            return FastScrollScrollView.this.getScrollX();
        }

        @Override
        protected void scrollTo(int x, int y) {
            FastScrollScrollView.this.scrollTo(x, y);
        }
    }
}

