/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.webkit.WebView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import me.zhanghai.android.fastscroll.FastScroller;
import me.zhanghai.android.fastscroll.SimpleViewHelper;
import me.zhanghai.android.fastscroll.ViewHelperProvider;

@SuppressLint(value={"MissingSuperCall"})
public class FastScrollWebView
extends WebView
implements ViewHelperProvider {
    @NonNull
    private final ViewHelper mViewHelper = new ViewHelper();

    public FastScrollWebView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public FastScrollWebView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FastScrollWebView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public FastScrollWebView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setVerticalScrollBarEnabled(false);
        this.setScrollContainer(true);
    }

    @Override
    @NonNull
    public FastScroller.ViewHelper getViewHelper() {
        return this.mViewHelper;
    }

    public void draw(@NonNull Canvas canvas) {
        this.mViewHelper.draw(canvas);
    }

    protected void onScrollChanged(int left, int top, int oldLeft, int oldTop) {
        this.mViewHelper.onScrollChanged(left, top, oldLeft, oldTop);
    }

    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        return this.mViewHelper.onInterceptTouchEvent(event);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        return this.mViewHelper.onTouchEvent(event);
    }

    private class ViewHelper
    extends SimpleViewHelper {
        private ViewHelper() {
        }

        @Override
        protected void superDraw(@NonNull Canvas canvas) {
            FastScrollWebView.super.draw(canvas);
        }

        @Override
        protected void superOnScrollChanged(int left, int top, int oldLeft, int oldTop) {
            FastScrollWebView.super.onScrollChanged(left, top, oldLeft, oldTop);
        }

        @Override
        protected boolean superOnInterceptTouchEvent(@NonNull MotionEvent event) {
            return FastScrollWebView.super.onInterceptTouchEvent(event);
        }

        @Override
        protected boolean superOnTouchEvent(@NonNull MotionEvent event) {
            return FastScrollWebView.super.onTouchEvent(event);
        }

        @Override
        protected int computeVerticalScrollRange() {
            return FastScrollWebView.this.computeVerticalScrollRange();
        }

        @Override
        protected int computeVerticalScrollOffset() {
            return FastScrollWebView.this.computeVerticalScrollOffset();
        }

        @Override
        protected int getScrollX() {
            return FastScrollWebView.this.getScrollX();
        }

        @Override
        protected void scrollTo(int x, int y) {
            FastScrollWebView.this.scrollTo(x, y);
        }
    }
}

