/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.math.MathUtils;
import androidx.core.util.Consumer;
import java.util.Objects;
import me.zhanghai.android.fastscroll.Predicate;
import me.zhanghai.android.fastscroll.R;

public class FastScroller {
    private final int mMinTouchTargetSize;
    private final int mTouchSlop;
    @NonNull
    private final ViewGroup mView;
    @NonNull
    private final ViewHelper mViewHelper;
    @Nullable
    private Rect mUserPadding;
    @NonNull
    private final AnimationHelper mAnimationHelper;
    private final int mTrackWidth;
    private final int mThumbWidth;
    private final int mThumbHeight;
    @NonNull
    private final View mTrackView;
    @NonNull
    private final View mThumbView;
    @NonNull
    private final TextView mPopupView;
    private boolean mScrollbarEnabled;
    private int mThumbOffset;
    private float mDownX;
    private float mDownY;
    private float mLastY;
    private float mDragStartY;
    private int mDragStartThumbOffset;
    private boolean mDragging;
    @NonNull
    private final Runnable mAutoHideScrollbarRunnable = this::autoHideScrollbar;
    @NonNull
    private final Rect mTempRect = new Rect();

    public FastScroller(@NonNull ViewGroup view, @NonNull ViewHelper viewHelper, @Nullable Rect padding, @NonNull Drawable trackDrawable, @NonNull Drawable thumbDrawable, @NonNull Consumer<TextView> popupStyle, @NonNull AnimationHelper animationHelper) {
        this.mMinTouchTargetSize = view.getResources().getDimensionPixelSize(R.dimen.afs_min_touch_target_size);
        Context context = view.getContext();
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mView = view;
        this.mViewHelper = viewHelper;
        this.mUserPadding = padding;
        this.mAnimationHelper = animationHelper;
        this.mTrackWidth = FastScroller.requireNonNegative(trackDrawable.getIntrinsicWidth(), "trackDrawable.getIntrinsicWidth() < 0");
        this.mThumbWidth = FastScroller.requireNonNegative(thumbDrawable.getIntrinsicWidth(), "thumbDrawable.getIntrinsicWidth() < 0");
        this.mThumbHeight = FastScroller.requireNonNegative(thumbDrawable.getIntrinsicHeight(), "thumbDrawable.getIntrinsicHeight() < 0");
        this.mTrackView = new View(context);
        this.mTrackView.setBackground(trackDrawable);
        this.mThumbView = new View(context);
        this.mThumbView.setBackground(thumbDrawable);
        this.mPopupView = new AppCompatTextView(context);
        this.mPopupView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        popupStyle.accept((Object)this.mPopupView);
        ViewGroupOverlay overlay = this.mView.getOverlay();
        overlay.add(this.mTrackView);
        overlay.add(this.mThumbView);
        overlay.add((View)this.mPopupView);
        this.postAutoHideScrollbar();
        this.mPopupView.setAlpha(0.0f);
        this.mViewHelper.addOnPreDrawListener(this::onPreDraw);
        this.mViewHelper.addOnScrollChangedListener(this::onScrollChanged);
        this.mViewHelper.addOnTouchEventListener(this::onTouchEvent);
    }

    private static int requireNonNegative(int value, @NonNull String message) {
        if (value < 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if (this.mUserPadding != null && this.mUserPadding.left == left && this.mUserPadding.top == top && this.mUserPadding.right == right && this.mUserPadding.bottom == bottom) {
            return;
        }
        if (this.mUserPadding == null) {
            this.mUserPadding = new Rect();
        }
        this.mUserPadding.set(left, top, right, bottom);
        this.mView.invalidate();
    }

    public void setPadding(@Nullable Rect padding) {
        if (Objects.equals(this.mUserPadding, padding)) {
            return;
        }
        if (padding != null) {
            if (this.mUserPadding == null) {
                this.mUserPadding = new Rect();
            }
            this.mUserPadding.set(padding);
        } else {
            this.mUserPadding = null;
        }
        this.mView.invalidate();
    }

    @NonNull
    private Rect getPadding() {
        if (this.mUserPadding != null) {
            this.mTempRect.set(this.mUserPadding);
        } else {
            this.mTempRect.set(this.mView.getPaddingLeft(), this.mView.getPaddingTop(), this.mView.getPaddingRight(), this.mView.getPaddingBottom());
        }
        return this.mTempRect;
    }

    private void onPreDraw() {
        this.updateScrollbarState();
        this.mTrackView.setVisibility(this.mScrollbarEnabled ? 0 : 4);
        this.mThumbView.setVisibility(this.mScrollbarEnabled ? 0 : 4);
        if (!this.mScrollbarEnabled) {
            this.mPopupView.setVisibility(4);
            return;
        }
        int layoutDirection = this.mView.getLayoutDirection();
        this.mTrackView.setLayoutDirection(layoutDirection);
        this.mThumbView.setLayoutDirection(layoutDirection);
        this.mPopupView.setLayoutDirection(layoutDirection);
        boolean isLayoutRtl = layoutDirection == 1;
        int viewWidth = this.mView.getWidth();
        int viewHeight = this.mView.getHeight();
        Rect padding = this.getPadding();
        int trackLeft = isLayoutRtl ? padding.left : viewWidth - padding.right - this.mTrackWidth;
        this.layoutView(this.mTrackView, trackLeft, padding.top, trackLeft + this.mTrackWidth, Math.max(viewHeight - padding.bottom, padding.top));
        int thumbLeft = isLayoutRtl ? padding.left : viewWidth - padding.right - this.mThumbWidth;
        int thumbTop = padding.top + this.mThumbOffset;
        this.layoutView(this.mThumbView, thumbLeft, thumbTop, thumbLeft + this.mThumbWidth, thumbTop + this.mThumbHeight);
        CharSequence popupText = this.mViewHelper.getPopupText();
        boolean hasPopup = !TextUtils.isEmpty((CharSequence)popupText);
        this.mPopupView.setVisibility(hasPopup ? 0 : 4);
        if (hasPopup) {
            int thumbAnchorY;
            int popupAnchorY;
            FrameLayout.LayoutParams popupLayoutParams = (FrameLayout.LayoutParams)this.mPopupView.getLayoutParams();
            if (!Objects.equals(this.mPopupView.getText(), popupText)) {
                this.mPopupView.setText(popupText);
                int widthMeasureSpec = ViewGroup.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)viewWidth, (int)0x40000000), (int)(padding.left + padding.right + this.mThumbWidth + popupLayoutParams.leftMargin + popupLayoutParams.rightMargin), (int)popupLayoutParams.width);
                int heightMeasureSpec = ViewGroup.getChildMeasureSpec((int)View.MeasureSpec.makeMeasureSpec((int)viewHeight, (int)0x40000000), (int)(padding.top + padding.bottom + popupLayoutParams.topMargin + popupLayoutParams.bottomMargin), (int)popupLayoutParams.height);
                this.mPopupView.measure(widthMeasureSpec, heightMeasureSpec);
            }
            int popupWidth = this.mPopupView.getMeasuredWidth();
            int popupHeight = this.mPopupView.getMeasuredHeight();
            int popupLeft = isLayoutRtl ? padding.left + this.mThumbWidth + popupLayoutParams.leftMargin : viewWidth - padding.right - this.mThumbWidth - popupLayoutParams.rightMargin - popupWidth;
            switch (popupLayoutParams.gravity & 7) {
                default: {
                    popupAnchorY = 0;
                    break;
                }
                case 1: {
                    popupAnchorY = popupHeight / 2;
                    break;
                }
                case 5: {
                    popupAnchorY = popupHeight;
                }
            }
            switch (popupLayoutParams.gravity & 0x70) {
                default: {
                    thumbAnchorY = this.mThumbView.getPaddingTop();
                    break;
                }
                case 16: {
                    int thumbPaddingTop = this.mThumbView.getPaddingTop();
                    thumbAnchorY = thumbPaddingTop + (this.mThumbHeight - thumbPaddingTop - this.mThumbView.getPaddingBottom()) / 2;
                    break;
                }
                case 80: {
                    thumbAnchorY = this.mThumbHeight - this.mThumbView.getPaddingBottom();
                }
            }
            int popupTop = MathUtils.clamp((int)(thumbTop + thumbAnchorY - popupAnchorY), (int)(padding.top + popupLayoutParams.topMargin), (int)(viewHeight - padding.bottom - popupLayoutParams.bottomMargin - popupHeight));
            this.layoutView((View)this.mPopupView, popupLeft, popupTop, popupLeft + popupWidth, popupTop + popupHeight);
        }
    }

    private void updateScrollbarState() {
        int scrollOffsetRange = this.getScrollOffsetRange();
        this.mScrollbarEnabled = scrollOffsetRange > 0;
        this.mThumbOffset = this.mScrollbarEnabled ? (int)((long)this.getThumbOffsetRange() * (long)this.mViewHelper.getScrollOffset() / (long)scrollOffsetRange) : 0;
    }

    private void layoutView(@NonNull View view, int left, int top, int right, int bottom) {
        int scrollX = this.mView.getScrollX();
        int scrollY = this.mView.getScrollY();
        view.layout(scrollX + left, scrollY + top, scrollX + right, scrollY + bottom);
    }

    private void onScrollChanged() {
        this.updateScrollbarState();
        if (!this.mScrollbarEnabled) {
            return;
        }
        this.mAnimationHelper.showScrollbar(this.mTrackView, this.mThumbView);
        this.postAutoHideScrollbar();
    }

    private boolean onTouchEvent(@NonNull MotionEvent event) {
        if (!this.mScrollbarEnabled) {
            return false;
        }
        float eventX = event.getX();
        float eventY = event.getY();
        Rect padding = this.getPadding();
        switch (event.getAction()) {
            case 0: {
                this.mDownX = eventX;
                this.mDownY = eventY;
                if (!(this.mThumbView.getAlpha() > 0.0f) || !this.isInViewTouchTarget(this.mThumbView, eventX, eventY)) break;
                this.mDragStartY = eventY;
                this.mDragStartThumbOffset = this.mThumbOffset;
                this.setDragging(true);
                break;
            }
            case 2: {
                if (!this.mDragging && this.isInViewTouchTarget(this.mTrackView, this.mDownX, this.mDownY) && Math.abs(eventY - this.mDownY) > (float)this.mTouchSlop) {
                    if (this.isInViewTouchTarget(this.mThumbView, this.mDownX, this.mDownY)) {
                        this.mDragStartY = this.mLastY;
                        this.mDragStartThumbOffset = this.mThumbOffset;
                    } else {
                        this.mDragStartY = eventY;
                        this.mDragStartThumbOffset = (int)(eventY - (float)padding.top - (float)this.mThumbHeight / 2.0f);
                        this.scrollToThumbOffset(this.mDragStartThumbOffset);
                    }
                    this.setDragging(true);
                }
                if (!this.mDragging) break;
                int thumbOffset = this.mDragStartThumbOffset + (int)(eventY - this.mDragStartY);
                this.scrollToThumbOffset(thumbOffset);
                break;
            }
            case 1: 
            case 3: {
                this.setDragging(false);
            }
        }
        this.mLastY = eventY;
        return this.mDragging;
    }

    private boolean isInView(@NonNull View view, float x, float y) {
        int scrollX = this.mView.getScrollX();
        int scrollY = this.mView.getScrollY();
        return x >= (float)(view.getLeft() - scrollX) && x < (float)(view.getRight() - scrollX) && y >= (float)(view.getTop() - scrollY) && y < (float)(view.getBottom() - scrollY);
    }

    private boolean isInViewTouchTarget(@NonNull View view, float x, float y) {
        int scrollX = this.mView.getScrollX();
        int scrollY = this.mView.getScrollY();
        return this.isInTouchTarget(x, view.getLeft() - scrollX, view.getRight() - scrollX, 0, this.mView.getWidth()) && this.isInTouchTarget(y, view.getTop() - scrollY, view.getBottom() - scrollY, 0, this.mView.getHeight());
    }

    private boolean isInTouchTarget(float position, int viewStart, int viewEnd, int parentStart, int parentEnd) {
        int touchTargetEnd;
        int viewSize = viewEnd - viewStart;
        if (viewSize >= this.mMinTouchTargetSize) {
            return position >= (float)viewStart && position < (float)viewEnd;
        }
        int touchTargetStart = viewStart - (this.mMinTouchTargetSize - viewSize) / 2;
        if (touchTargetStart < parentStart) {
            touchTargetStart = parentStart;
        }
        if ((touchTargetEnd = touchTargetStart + this.mMinTouchTargetSize) > parentEnd && (touchTargetStart = (touchTargetEnd = parentEnd) - this.mMinTouchTargetSize) < parentStart) {
            touchTargetStart = parentStart;
        }
        return position >= (float)touchTargetStart && position < (float)touchTargetEnd;
    }

    private void scrollToThumbOffset(int thumbOffset) {
        int thumbOffsetRange = this.getThumbOffsetRange();
        thumbOffset = MathUtils.clamp((int)thumbOffset, (int)0, (int)thumbOffsetRange);
        int scrollOffset = (int)((long)this.getScrollOffsetRange() * (long)thumbOffset / (long)thumbOffsetRange);
        this.mViewHelper.scrollTo(scrollOffset);
    }

    private int getScrollOffsetRange() {
        return this.mViewHelper.getScrollRange() - this.mView.getHeight();
    }

    private int getThumbOffsetRange() {
        Rect padding = this.getPadding();
        return this.mView.getHeight() - padding.top - padding.bottom - this.mThumbHeight;
    }

    private void setDragging(boolean dragging) {
        if (this.mDragging == dragging) {
            return;
        }
        this.mDragging = dragging;
        if (this.mDragging) {
            this.mView.getParent().requestDisallowInterceptTouchEvent(true);
        }
        this.mTrackView.setPressed(this.mDragging);
        this.mThumbView.setPressed(this.mDragging);
        if (this.mDragging) {
            this.cancelAutoHideScrollbar();
            this.mAnimationHelper.showScrollbar(this.mTrackView, this.mThumbView);
            this.mAnimationHelper.showPopup((View)this.mPopupView);
        } else {
            this.postAutoHideScrollbar();
            this.mAnimationHelper.hidePopup((View)this.mPopupView);
        }
    }

    private void postAutoHideScrollbar() {
        this.cancelAutoHideScrollbar();
        if (this.mAnimationHelper.isScrollbarAutoHideEnabled()) {
            this.mView.postDelayed(this.mAutoHideScrollbarRunnable, (long)this.mAnimationHelper.getScrollbarAutoHideDelayMillis());
        }
    }

    private void autoHideScrollbar() {
        if (this.mDragging) {
            return;
        }
        this.mAnimationHelper.hideScrollbar(this.mTrackView, this.mThumbView);
    }

    private void cancelAutoHideScrollbar() {
        this.mView.removeCallbacks(this.mAutoHideScrollbarRunnable);
    }

    public static interface AnimationHelper {
        public void showScrollbar(@NonNull View var1, @NonNull View var2);

        public void hideScrollbar(@NonNull View var1, @NonNull View var2);

        public boolean isScrollbarAutoHideEnabled();

        public int getScrollbarAutoHideDelayMillis();

        public void showPopup(@NonNull View var1);

        public void hidePopup(@NonNull View var1);
    }

    public static interface ViewHelper {
        public void addOnPreDrawListener(@NonNull Runnable var1);

        public void addOnScrollChangedListener(@NonNull Runnable var1);

        public void addOnTouchEventListener(@NonNull Predicate<MotionEvent> var1);

        public int getScrollRange();

        public int getScrollOffset();

        public void scrollTo(int var1);

        @Nullable
        default public CharSequence getPopupText() {
            return null;
        }
    }
}

