/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import androidx.core.widget.NestedScrollView;
import androidx.recyclerview.widget.RecyclerView;
import me.zhanghai.android.fastscroll.DefaultAnimationHelper;
import me.zhanghai.android.fastscroll.FastScrollNestedScrollView;
import me.zhanghai.android.fastscroll.FastScrollScrollView;
import me.zhanghai.android.fastscroll.FastScrollWebView;
import me.zhanghai.android.fastscroll.FastScroller;
import me.zhanghai.android.fastscroll.PopupStyles;
import me.zhanghai.android.fastscroll.PopupTextProvider;
import me.zhanghai.android.fastscroll.R;
import me.zhanghai.android.fastscroll.RecyclerViewHelper;
import me.zhanghai.android.fastscroll.Utils;
import me.zhanghai.android.fastscroll.ViewHelperProvider;

public class FastScrollerBuilder {
    @NonNull
    private final ViewGroup mView;
    @Nullable
    private FastScroller.ViewHelper mViewHelper;
    @Nullable
    private PopupTextProvider mPopupTextProvider;
    @Nullable
    private Rect mPadding;
    @NonNull
    private Drawable mTrackDrawable;
    @NonNull
    private Drawable mThumbDrawable;
    @NonNull
    private Consumer<TextView> mPopupStyle;
    @Nullable
    private FastScroller.AnimationHelper mAnimationHelper;

    public FastScrollerBuilder(@NonNull ViewGroup view) {
        this.mView = view;
        this.useDefaultStyle();
    }

    @NonNull
    public FastScrollerBuilder setViewHelper(@Nullable FastScroller.ViewHelper viewHelper) {
        this.mViewHelper = viewHelper;
        return this;
    }

    @NonNull
    public FastScrollerBuilder setPopupTextProvider(@Nullable PopupTextProvider popupTextProvider) {
        this.mPopupTextProvider = popupTextProvider;
        return this;
    }

    @NonNull
    public FastScrollerBuilder setPadding(int left, int top, int right, int bottom) {
        if (this.mPadding == null) {
            this.mPadding = new Rect();
        }
        this.mPadding.set(left, top, right, bottom);
        return this;
    }

    @NonNull
    public FastScrollerBuilder setPadding(@Nullable Rect padding) {
        if (padding != null) {
            if (this.mPadding == null) {
                this.mPadding = new Rect();
            }
            this.mPadding.set(padding);
        } else {
            this.mPadding = null;
        }
        return this;
    }

    @NonNull
    public FastScrollerBuilder setTrackDrawable(@NonNull Drawable trackDrawable) {
        this.mTrackDrawable = trackDrawable;
        return this;
    }

    @NonNull
    public FastScrollerBuilder setThumbDrawable(@NonNull Drawable thumbDrawable) {
        this.mThumbDrawable = thumbDrawable;
        return this;
    }

    @NonNull
    public FastScrollerBuilder setPopupStyle(@NonNull Consumer<TextView> popupStyle) {
        this.mPopupStyle = popupStyle;
        return this;
    }

    @NonNull
    public FastScrollerBuilder useDefaultStyle() {
        Context context = this.mView.getContext();
        this.mTrackDrawable = Utils.getGradientDrawableWithTintAttr(R.drawable.afs_track, R.attr.colorControlNormal, context);
        this.mThumbDrawable = Utils.getGradientDrawableWithTintAttr(R.drawable.afs_thumb, R.attr.colorControlActivated, context);
        this.mPopupStyle = PopupStyles.DEFAULT;
        return this;
    }

    @NonNull
    public FastScrollerBuilder useMd2Style() {
        Context context = this.mView.getContext();
        this.mTrackDrawable = Utils.getGradientDrawableWithTintAttr(R.drawable.afs_md2_track, R.attr.colorControlNormal, context);
        this.mThumbDrawable = Utils.getGradientDrawableWithTintAttr(R.drawable.afs_md2_thumb, R.attr.colorControlActivated, context);
        this.mPopupStyle = PopupStyles.MD2;
        return this;
    }

    public void setAnimationHelper(@Nullable FastScroller.AnimationHelper animationHelper) {
        this.mAnimationHelper = animationHelper;
    }

    public void disableScrollbarAutoHide() {
        DefaultAnimationHelper animationHelper = new DefaultAnimationHelper((View)this.mView);
        animationHelper.setScrollbarAutoHideEnabled(false);
        this.mAnimationHelper = animationHelper;
    }

    @NonNull
    public FastScroller build() {
        return new FastScroller(this.mView, this.getOrCreateViewHelper(), this.mPadding, this.mTrackDrawable, this.mThumbDrawable, this.mPopupStyle, this.getOrCreateAnimationHelper());
    }

    @NonNull
    private FastScroller.ViewHelper getOrCreateViewHelper() {
        if (this.mViewHelper != null) {
            return this.mViewHelper;
        }
        if (this.mView instanceof ViewHelperProvider) {
            return ((ViewHelperProvider)this.mView).getViewHelper();
        }
        if (this.mView instanceof RecyclerView) {
            return new RecyclerViewHelper((RecyclerView)this.mView, this.mPopupTextProvider);
        }
        if (this.mView instanceof NestedScrollView) {
            throw new UnsupportedOperationException("Please use " + FastScrollNestedScrollView.class.getSimpleName() + " instead of " + NestedScrollView.class.getSimpleName() + "for fast scroll");
        }
        if (this.mView instanceof ScrollView) {
            throw new UnsupportedOperationException("Please use " + FastScrollScrollView.class.getSimpleName() + " instead of " + ScrollView.class.getSimpleName() + "for fast scroll");
        }
        if (this.mView instanceof WebView) {
            throw new UnsupportedOperationException("Please use " + FastScrollWebView.class.getSimpleName() + " instead of " + WebView.class.getSimpleName() + "for fast scroll");
        }
        throw new UnsupportedOperationException(this.mView.getClass().getSimpleName() + " is not supported for fast scroll");
    }

    @NonNull
    private FastScroller.AnimationHelper getOrCreateAnimationHelper() {
        if (this.mAnimationHelper != null) {
            return this.mAnimationHelper;
        }
        return new DefaultAnimationHelper((View)this.mView);
    }
}

