/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import me.zhanghai.android.fastscroll.R;
import me.zhanghai.android.fastscroll.Utils;

class Md2PopupBackground
extends Drawable {
    @NonNull
    private final Paint mPaint;
    private final int mPaddingStart;
    private final int mPaddingEnd;
    @NonNull
    private final Path mPath = new Path();
    @NonNull
    private final Matrix mTempMatrix = new Matrix();

    public Md2PopupBackground(@NonNull Context context) {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(Utils.getColorFromAttrRes(R.attr.colorControlActivated, context));
        this.mPaint.setStyle(Paint.Style.FILL);
        Resources resources = context.getResources();
        this.mPaddingStart = resources.getDimensionPixelOffset(R.dimen.afs_md2_popup_padding_start);
        this.mPaddingEnd = resources.getDimensionPixelOffset(R.dimen.afs_md2_popup_padding_end);
    }

    public void draw(@NonNull Canvas canvas) {
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public boolean onLayoutDirectionChanged(int layoutDirection) {
        this.updatePath();
        return true;
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public boolean isAutoMirrored() {
        return true;
    }

    private boolean needMirroring() {
        return DrawableCompat.getLayoutDirection((Drawable)this) == 1;
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(@NonNull Rect bounds) {
        this.updatePath();
    }

    private void updatePath() {
        this.mPath.reset();
        Rect bounds = this.getBounds();
        float width = bounds.width();
        float height = bounds.height();
        float r = height / 2.0f;
        float sqrt2 = (float)Math.sqrt(2.0);
        width = Math.max(r + sqrt2 * r, width);
        Md2PopupBackground.pathArcTo(this.mPath, r, r, r, 90.0f, 180.0f);
        float o1X = width - sqrt2 * r;
        Md2PopupBackground.pathArcTo(this.mPath, o1X, r, r, -90.0f, 45.0f);
        float r2 = r / 5.0f;
        float o2X = width - sqrt2 * r2;
        Md2PopupBackground.pathArcTo(this.mPath, o2X, r, r2, -45.0f, 90.0f);
        Md2PopupBackground.pathArcTo(this.mPath, o1X, r, r, 45.0f, 45.0f);
        this.mPath.close();
        if (this.needMirroring()) {
            this.mTempMatrix.setScale(-1.0f, 1.0f, width / 2.0f, 0.0f);
        } else {
            this.mTempMatrix.reset();
        }
        this.mTempMatrix.postTranslate((float)bounds.left, (float)bounds.top);
        this.mPath.transform(this.mTempMatrix);
    }

    private static void pathArcTo(@NonNull Path path, float centerX, float centerY, float radius, float startAngle, float sweepAngle) {
        path.arcTo(centerX - radius, centerY - radius, centerX + radius, centerY + radius, startAngle, sweepAngle, false);
    }

    public boolean getPadding(@NonNull Rect padding) {
        if (this.needMirroring()) {
            padding.set(this.mPaddingEnd, 0, this.mPaddingStart, 0);
        } else {
            padding.set(this.mPaddingStart, 0, this.mPaddingEnd, 0);
        }
        return true;
    }

    public void getOutline(@NonNull Outline outline) {
        if (Build.VERSION.SDK_INT < 29 && !this.mPath.isConvex()) {
            super.getOutline(outline);
            return;
        }
        outline.setConvexPath(this.mPath);
    }
}

