/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import me.zhanghai.android.fastscroll.FastScroller;
import me.zhanghai.android.fastscroll.PopupTextProvider;
import me.zhanghai.android.fastscroll.Predicate;

class RecyclerViewHelper
implements FastScroller.ViewHelper {
    @NonNull
    private final RecyclerView mView;
    @Nullable
    private final PopupTextProvider mPopupTextProvider;
    @NonNull
    private final Rect mTempRect = new Rect();

    public RecyclerViewHelper(@NonNull RecyclerView view, @Nullable PopupTextProvider popupTextProvider) {
        this.mView = view;
        this.mPopupTextProvider = popupTextProvider;
    }

    @Override
    public void addOnPreDrawListener(final @NonNull Runnable onPreDraw) {
        this.mView.addItemDecoration(new RecyclerView.ItemDecoration(){

            public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
                onPreDraw.run();
            }
        });
    }

    @Override
    public void addOnScrollChangedListener(final @NonNull Runnable onScrollChanged) {
        this.mView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                onScrollChanged.run();
            }
        });
    }

    @Override
    public void addOnTouchEventListener(final @NonNull Predicate<MotionEvent> onTouchEvent) {
        this.mView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RecyclerView.SimpleOnItemTouchListener(){

            public boolean onInterceptTouchEvent(@NonNull RecyclerView recyclerView, @NonNull MotionEvent event) {
                return onTouchEvent.test(event);
            }

            public void onTouchEvent(@NonNull RecyclerView recyclerView, @NonNull MotionEvent event) {
                onTouchEvent.test(event);
            }
        });
    }

    @Override
    public int getScrollRange() {
        int itemCount = this.getItemCount();
        if (itemCount == 0) {
            return 0;
        }
        int itemHeight = this.getItemHeight();
        if (itemHeight == 0) {
            return 0;
        }
        return this.mView.getPaddingTop() + itemCount * itemHeight + this.mView.getPaddingBottom();
    }

    @Override
    public int getScrollOffset() {
        int firstItemPosition = this.getFirstItemPosition();
        if (firstItemPosition == -1) {
            return 0;
        }
        int itemHeight = this.getItemHeight();
        int firstItemTop = this.getFirstItemOffset();
        return this.mView.getPaddingTop() + firstItemPosition * itemHeight - firstItemTop;
    }

    @Override
    public void scrollTo(int offset) {
        this.mView.stopScroll();
        int itemHeight = this.getItemHeight();
        int firstItemPosition = Math.max(0, (offset -= this.mView.getPaddingTop()) / itemHeight);
        int firstItemTop = firstItemPosition * itemHeight - offset;
        this.scrollToPositionWithOffset(firstItemPosition, firstItemTop);
    }

    @Override
    @Nullable
    public CharSequence getPopupText() {
        RecyclerView.Adapter adapter;
        PopupTextProvider popupTextProvider = this.mPopupTextProvider;
        if (popupTextProvider == null && (adapter = this.mView.getAdapter()) instanceof PopupTextProvider) {
            popupTextProvider = (PopupTextProvider)adapter;
        }
        if (popupTextProvider == null) {
            return null;
        }
        int position = this.getFirstItemAdapterPosition();
        if (position == -1) {
            return null;
        }
        return popupTextProvider.getPopupText(position);
    }

    private int getItemCount() {
        LinearLayoutManager linearLayoutManager = this.getVerticalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return 0;
        }
        int itemCount = linearLayoutManager.getItemCount();
        if (itemCount == 0) {
            return 0;
        }
        if (linearLayoutManager instanceof GridLayoutManager) {
            GridLayoutManager gridLayoutManager = (GridLayoutManager)linearLayoutManager;
            itemCount = (itemCount - 1) / gridLayoutManager.getSpanCount() + 1;
        }
        return itemCount;
    }

    private int getItemHeight() {
        if (this.mView.getChildCount() == 0) {
            return 0;
        }
        View itemView = this.mView.getChildAt(0);
        this.mView.getDecoratedBoundsWithMargins(itemView, this.mTempRect);
        return this.mTempRect.height();
    }

    private int getFirstItemPosition() {
        int position = this.getFirstItemAdapterPosition();
        LinearLayoutManager linearLayoutManager = this.getVerticalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return -1;
        }
        if (linearLayoutManager instanceof GridLayoutManager) {
            GridLayoutManager gridLayoutManager = (GridLayoutManager)linearLayoutManager;
            position /= gridLayoutManager.getSpanCount();
        }
        return position;
    }

    private int getFirstItemAdapterPosition() {
        if (this.mView.getChildCount() == 0) {
            return -1;
        }
        View itemView = this.mView.getChildAt(0);
        LinearLayoutManager linearLayoutManager = this.getVerticalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return -1;
        }
        return linearLayoutManager.getPosition(itemView);
    }

    private int getFirstItemOffset() {
        if (this.mView.getChildCount() == 0) {
            return -1;
        }
        View itemView = this.mView.getChildAt(0);
        this.mView.getDecoratedBoundsWithMargins(itemView, this.mTempRect);
        return this.mTempRect.top;
    }

    private void scrollToPositionWithOffset(int position, int offset) {
        LinearLayoutManager linearLayoutManager = this.getVerticalLinearLayoutManager();
        if (linearLayoutManager == null) {
            return;
        }
        if (linearLayoutManager instanceof GridLayoutManager) {
            GridLayoutManager gridLayoutManager = (GridLayoutManager)linearLayoutManager;
            position *= gridLayoutManager.getSpanCount();
        }
        linearLayoutManager.scrollToPositionWithOffset(position, offset -= this.mView.getPaddingTop());
    }

    @Nullable
    private LinearLayoutManager getVerticalLinearLayoutManager() {
        RecyclerView.LayoutManager layoutManager = this.mView.getLayoutManager();
        if (!(layoutManager instanceof LinearLayoutManager)) {
            return null;
        }
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
        if (linearLayoutManager.getOrientation() != 1) {
            return null;
        }
        return linearLayoutManager;
    }
}

