/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.fastscroll;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.drawable.DrawableCompat;

class Utils {
    Utils() {
    }

    @ColorInt
    public static int getColorFromAttrRes(@AttrRes int attrRes, @NonNull Context context) {
        ColorStateList colorStateList = Utils.getColorStateListFromAttrRes(attrRes, context);
        return colorStateList != null ? colorStateList.getDefaultColor() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ColorStateList getColorStateListFromAttrRes(@AttrRes int attrRes, @NonNull Context context) {
        TypedArray a = context.obtainStyledAttributes(new int[]{attrRes});
        try {
            int resId = a.getResourceId(0, 0);
            if (resId != 0) {
                ColorStateList colorStateList = AppCompatResources.getColorStateList((Context)context, (int)resId);
                return colorStateList;
            }
            ColorStateList colorStateList = a.getColorStateList(0);
            return colorStateList;
        }
        finally {
            a.recycle();
        }
    }

    @Nullable
    public static Drawable getGradientDrawableWithTintAttr(@DrawableRes int drawableRes, @AttrRes int tintAttrRes, @NonNull Context context) {
        Drawable drawable2 = AppCompatResources.getDrawable((Context)context, (int)drawableRes);
        if (Build.VERSION.SDK_INT < 22 && drawable2 instanceof GradientDrawable) {
            drawable2 = DrawableCompat.wrap((Drawable)drawable2);
            drawable2.setTintList(Utils.getColorStateListFromAttrRes(tintAttrRes, context));
        }
        return drawable2;
    }
}

