/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ProgressBar;
import me.zhanghai.android.materialprogressbar.HorizontalProgressDrawable;
import me.zhanghai.android.materialprogressbar.IndeterminateHorizontalProgressDrawable;
import me.zhanghai.android.materialprogressbar.IndeterminateProgressDrawable;
import me.zhanghai.android.materialprogressbar.IntrinsicPaddingDrawable;
import me.zhanghai.android.materialprogressbar.R;
import me.zhanghai.android.materialprogressbar.ShowTrackDrawable;
import me.zhanghai.android.materialprogressbar.TintableDrawable;
import me.zhanghai.android.materialprogressbar.internal.DrawableCompat;

public class MaterialProgressBar
extends ProgressBar {
    private static final String TAG = MaterialProgressBar.class.getSimpleName();
    public static final int PROGRESS_STYLE_CIRCULAR = 0;
    public static final int PROGRESS_STYLE_HORIZONTAL = 1;
    private int mProgressStyle;
    private TintInfo mProgressTint = new TintInfo();

    public MaterialProgressBar(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public MaterialProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public MaterialProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public MaterialProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MaterialProgressBar, defStyleAttr, defStyleRes);
        this.mProgressStyle = a.getInt(R.styleable.MaterialProgressBar_mpb_progressStyle, 0);
        boolean setBothDrawables = a.getBoolean(R.styleable.MaterialProgressBar_mpb_setBothDrawables, false);
        boolean useIntrinsicPadding = a.getBoolean(R.styleable.MaterialProgressBar_mpb_useIntrinsicPadding, true);
        boolean showTrack = a.getBoolean(R.styleable.MaterialProgressBar_mpb_showTrack, this.mProgressStyle == 1);
        if (a.hasValue(R.styleable.MaterialProgressBar_android_tint)) {
            this.mProgressTint.mTintList = a.getColorStateList(R.styleable.MaterialProgressBar_android_tint);
            this.mProgressTint.mHasTintList = true;
        }
        if (a.hasValue(R.styleable.MaterialProgressBar_mpb_tintMode)) {
            this.mProgressTint.mTintMode = DrawableCompat.parseTintMode(a.getInt(R.styleable.MaterialProgressBar_mpb_tintMode, -1), null);
            this.mProgressTint.mHasTintMode = true;
        }
        a.recycle();
        switch (this.mProgressStyle) {
            case 0: {
                if (!this.isIndeterminate() || setBothDrawables) {
                    throw new UnsupportedOperationException("Determinate circular drawable is not yet supported");
                }
                this.setIndeterminateDrawable(new IndeterminateProgressDrawable(context));
                break;
            }
            case 1: {
                if (this.isIndeterminate() || setBothDrawables) {
                    this.setIndeterminateDrawable(new IndeterminateHorizontalProgressDrawable(context));
                }
                if (this.isIndeterminate() && !setBothDrawables) break;
                this.setProgressDrawable((Drawable)new HorizontalProgressDrawable(context));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown progress style: " + this.mProgressStyle);
            }
        }
        this.setUseIntrinsicPadding(useIntrinsicPadding);
        this.setShowTrack(showTrack);
    }

    public int getProgressStyle() {
        return this.mProgressStyle;
    }

    public Drawable getDrawable() {
        return this.isIndeterminate() ? this.getIndeterminateDrawable() : this.getProgressDrawable();
    }

    public boolean getUseIntrinsicPadding() {
        Drawable drawable = this.getDrawable();
        if (drawable instanceof IntrinsicPaddingDrawable) {
            return ((IntrinsicPaddingDrawable)drawable).getUseIntrinsicPadding();
        }
        throw new IllegalStateException("Drawable does not implement IntrinsicPaddingDrawable");
    }

    public void setUseIntrinsicPadding(boolean useIntrinsicPadding) {
        Drawable drawable = this.getDrawable();
        if (!(drawable instanceof IntrinsicPaddingDrawable)) {
            throw new IllegalStateException("Drawable does not implement IntrinsicPaddingDrawable");
        }
        ((IntrinsicPaddingDrawable)drawable).setUseIntrinsicPadding(useIntrinsicPadding);
    }

    public boolean getShowTrack() {
        Drawable drawable = this.getDrawable();
        if (drawable instanceof ShowTrackDrawable) {
            return ((ShowTrackDrawable)drawable).getShowTrack();
        }
        return false;
    }

    public void setShowTrack(boolean showTrack) {
        Drawable drawable = this.getDrawable();
        if (drawable instanceof ShowTrackDrawable) {
            ((ShowTrackDrawable)drawable).setShowTrack(showTrack);
        } else if (showTrack) {
            throw new IllegalStateException("Drawable does not implement ShowTrackDrawable");
        }
    }

    public void setProgressDrawable(Drawable d) {
        super.setProgressDrawable(d);
        if (this.mProgressTint != null) {
            this.applyDeterminateProgressTint();
        }
    }

    public void setIndeterminateDrawable(Drawable d) {
        super.setIndeterminateDrawable(d);
        if (this.mProgressTint != null) {
            this.applyIndeterminateProgressTint();
        }
    }

    @Nullable
    public ColorStateList getProgressTintList() {
        return this.mProgressTint.mTintList;
    }

    public void setProgressTintList(@Nullable ColorStateList tint) {
        this.mProgressTint.mTintList = tint;
        this.mProgressTint.mHasTintList = true;
        this.applyProgressTint();
    }

    @Nullable
    public PorterDuff.Mode getProgressTintMode() {
        return this.mProgressTint.mTintMode;
    }

    public void setProgressTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mProgressTint.mTintMode = tintMode;
        this.mProgressTint.mHasTintMode = true;
        this.applyProgressTint();
    }

    private void applyProgressTint() {
        this.applyDeterminateProgressTint();
        this.applyIndeterminateProgressTint();
    }

    private void applyDeterminateProgressTint() {
        Drawable drawable;
        if ((this.mProgressTint.mHasTintList || this.mProgressTint.mHasTintMode) && (drawable = this.getProgressDrawable()) != null) {
            this.applyTintForDrawable(drawable, this.mProgressTint);
        }
    }

    private void applyIndeterminateProgressTint() {
        Drawable drawable;
        if ((this.mProgressTint.mHasTintList || this.mProgressTint.mHasTintMode) && (drawable = this.getIndeterminateDrawable()) != null) {
            this.applyTintForDrawable(drawable, this.mProgressTint);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void applyTintForDrawable(Drawable drawable, TintInfo tint) {
        if (tint.mHasTintList || tint.mHasTintMode) {
            if (tint.mHasTintList) {
                if (drawable instanceof TintableDrawable) {
                    ((TintableDrawable)drawable).setTintList(tint.mTintList);
                } else {
                    Log.w((String)TAG, (String)"drawable did not implement TintableDrawable, it won't be tinted below Lollipop");
                    if (Build.VERSION.SDK_INT >= 21) {
                        drawable.setTintList(tint.mTintList);
                    }
                }
            }
            if (tint.mHasTintMode) {
                if (drawable instanceof TintableDrawable) {
                    ((TintableDrawable)drawable).setTintMode(tint.mTintMode);
                } else {
                    Log.w((String)TAG, (String)"drawable did not implement TintableDrawable, it won't be tinted below Lollipop");
                    if (Build.VERSION.SDK_INT >= 21) {
                        drawable.setTintMode(tint.mTintMode);
                    }
                }
            }
            if (drawable.isStateful()) {
                drawable.setState(this.getDrawableState());
            }
        }
    }

    private static class TintInfo {
        boolean mHasTintList;
        ColorStateList mTintList;
        boolean mHasTintMode;
        PorterDuff.Mode mTintMode;

        private TintInfo() {
        }
    }
}

