/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import me.zhanghai.android.materialprogressbar.BaseProgressDrawable;

abstract class BaseSingleCircularProgressDrawable
extends BaseProgressDrawable {
    private static final RectF RECT_BOUND = new RectF(-21.0f, -21.0f, 21.0f, 21.0f);
    private static final RectF RECT_PADDED_BOUND = new RectF(-24.0f, -24.0f, 24.0f, 24.0f);
    private static final RectF RECT_PROGRESS = new RectF(-19.0f, -19.0f, 19.0f, 19.0f);

    BaseSingleCircularProgressDrawable() {
    }

    @Override
    protected void onPreparePaint(Paint paint) {
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(4.0f);
    }

    @Override
    protected void onDraw(Canvas canvas, int width, int height, Paint paint) {
        if (this.mUseIntrinsicPadding) {
            canvas.scale((float)width / RECT_PADDED_BOUND.width(), (float)height / RECT_PADDED_BOUND.height());
            canvas.translate(RECT_PADDED_BOUND.width() / 2.0f, RECT_PADDED_BOUND.height() / 2.0f);
        } else {
            canvas.scale((float)width / RECT_BOUND.width(), (float)height / RECT_BOUND.height());
            canvas.translate(RECT_BOUND.width() / 2.0f, RECT_BOUND.height() / 2.0f);
        }
        this.onDrawRing(canvas, paint);
    }

    protected abstract void onDrawRing(Canvas var1, Paint var2);

    protected void drawRing(Canvas canvas, Paint paint, float startAngle, float sweepAngle) {
        canvas.drawArc(RECT_PROGRESS, -90.0f + startAngle, sweepAngle, false, paint);
    }
}

