/*
 * Decompiled with CFR 0.152.
 */
package me.zhenxin.qqbot.core;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.zhenxin.qqbot.api.ApiManager;
import me.zhenxin.qqbot.entity.AccessInfo;
import me.zhenxin.qqbot.enums.Intent;
import me.zhenxin.qqbot.websocket.Client;
import me.zhenxin.qqbot.websocket.EventHandler;
import me.zhenxin.qqbot.websocket.entity.Gateway;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotCore {
    private static final Logger log = LoggerFactory.getLogger(BotCore.class);
    private final List<Intent> intents = new ArrayList<Intent>();
    private final AccessInfo accessInfo;
    private EventHandler eventHandler = new EventHandler();

    public BotCore(AccessInfo accessInfo) {
        this.accessInfo = accessInfo;
    }

    private Gateway getGateway() {
        String token = this.getToken();
        String apiBase = this.getApiBase();
        OkHttpClient client = new OkHttpClient.Builder().build();
        Request request = new Request.Builder().url(apiBase + "/gateway/bot").header("Authorization", token).get().build();
        Call call = client.newCall(request);
        try {
            Response response = call.execute();
            ResponseBody body = response.body();
            if (body == null) {
                System.exit(1);
            }
            String result = body.string();
            log.debug(result);
            return (Gateway)JSON.parseObject((String)result, Gateway.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private String getToken() {
        return "Bot " + this.accessInfo.getBotAppId() + "." + this.accessInfo.getBotToken();
    }

    private String getApiBase() {
        String apiBase = "https://api.sgroup.qq.com";
        if (this.accessInfo.getUseSandBoxMode().booleanValue()) {
            apiBase = "https://sandbox.api.sgroup.qq.com";
        }
        return apiBase;
    }

    public void start() {
        this.start(null, null);
    }

    public void start(Integer shard, Integer totalShard) {
        Gateway gateway = this.getGateway();
        if (gateway.getCode() == null) {
            String url = gateway.getUrl();
            log.info("\u7f51\u5173\u5730\u5740: {}, \u5efa\u8bae\u5206\u7247\u6570: {}", (Object)url, (Object)gateway.getShards());
            try {
                Client client = new Client(new URI(url));
                client.setToken(this.getToken());
                client.setIntents(this.intents);
                client.setEventHandler(this.eventHandler);
                client.setShard(shard, totalShard);
                client.setConnectionLostTimeout(0);
                client.connect();
            }
            catch (URISyntaxException e) {
                log.error("WebSocket \u8fde\u63a5\u5730\u5740\u9519\u8bef!");
                System.exit(1);
            }
        } else {
            log.error("\u83b7\u53d6 Gateway \u5931\u8d25! {} {}", (Object)gateway.getCode(), (Object)gateway.getMessage());
            System.exit(gateway.getCode());
        }
    }

    public void useSandBoxMode() {
        this.accessInfo.setUseSandBoxMode(Boolean.valueOf(true));
    }

    public ApiManager getApiManager() {
        return new ApiManager(this.accessInfo);
    }

    public void registerIntents(Intent ... intents) {
        this.intents.addAll(Arrays.asList(intents));
    }

    public void registerGuildsEvent() {
        this.intents.add(Intent.GUILDS);
    }

    public void registerGuildMembersEvent() {
        this.intents.add(Intent.GUILD_MEMBERS);
    }

    public void registerUserMessagesEvent() {
        this.intents.add(Intent.USER_MESSAGES);
    }

    public void registerGuildMessageReactionsEvent() {
        this.intents.add(Intent.GUILD_MESSAGE_REACTIONS);
    }

    public void registerDirectMessageEvent() {
        this.intents.add(Intent.DIRECT_MESSAGE);
    }

    public void registerForumEvent() {
        this.intents.add(Intent.FORUM_EVENT);
    }

    public void registerAudioActionEvent() {
        this.intents.add(Intent.AUDIO_ACTION);
    }

    public void registerAtMessageEvent() {
        this.intents.add(Intent.PUBLIC_GUILD_MESSAGES);
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }
}

