/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.GlobalAuthUtil;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthDingTalkRequest
extends AuthDefaultRequest {
    public AuthDingTalkRequest(AuthConfig config) {
        super(config, AuthSource.DINGTALK);
    }

    public AuthDingTalkRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthSource.DINGTALK, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        return AuthToken.builder().accessCode(authCallback.getCode()).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String code = authToken.getAccessCode();
        JSONObject param = new JSONObject();
        param.put("tmp_auth_code", (Object)code);
        HttpResponse response = HttpRequest.post((String)this.userInfoUrl(authToken)).body(param.toJSONString()).execute();
        JSONObject object = JSON.parseObject((String)response.body());
        if (object.getIntValue("errcode") != 0) {
            throw new AuthException(object.getString("errmsg"));
        }
        object = object.getJSONObject("user_info");
        AuthToken token = AuthToken.builder().openId(object.getString("openid")).unionId(object.getString("unionid")).build();
        return AuthUser.builder().uuid(object.getString("unionid")).nickname(object.getString("nick")).username(object.getString("nick")).gender(AuthUserGender.UNKNOWN).source(this.source).token(token).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("appid", this.config.getClientId()).queryParam("scope", "snsapi_login").queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        String timestamp = System.currentTimeMillis() + "";
        String urlEncodeSignature = GlobalAuthUtil.generateDingTalkSignature(this.config.getClientSecret(), timestamp);
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("signature", urlEncodeSignature).queryParam("timestamp", timestamp).queryParam("accessKey", this.config.getClientId()).build();
    }
}

