/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.GlobalAuthUtil;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthTwitterRequest
extends AuthDefaultRequest {
    private static final String PREAMBLE = "OAuth";

    public AuthTwitterRequest(AuthConfig config) {
        super(config, AuthDefaultSource.TWITTER);
    }

    public AuthTwitterRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.TWITTER, authStateCache);
    }

    public AuthToken getRequestToken() {
        String baseUrl = "https://api.twitter.com/oauth/request_token";
        Map<String, Object> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_callback", this.config.getRedirectUri());
        oauthParams.put("oauth_signature", GlobalAuthUtil.generateTwitterSignature(oauthParams, "POST", baseUrl, this.config.getClientSecret(), null));
        String header = this.buildHeader(oauthParams);
        HttpResponse requestToken = ((HttpRequest)HttpRequest.post((String)baseUrl).header("Authorization", header)).execute();
        this.checkResponse(requestToken);
        Map<String, Object> res = GlobalAuthUtil.parseQueryToMap(requestToken.body());
        return AuthToken.builder().oauthToken(res.get("oauth_token").toString()).oauthTokenSecret(res.get("oauth_token_secret").toString()).oauthCallbackConfirmed(Boolean.valueOf(res.get("oauth_callback_confirmed").toString())).build();
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        Map<String, Object> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_token", authCallback.getOauthToken());
        oauthParams.put("oauth_verifier", authCallback.getOauthVerifier());
        oauthParams.put("oauth_signature", GlobalAuthUtil.generateTwitterSignature(oauthParams, "POST", this.source.accessToken(), this.config.getClientSecret(), authCallback.getOauthToken()));
        String header = this.buildHeader(oauthParams);
        HttpResponse response = ((HttpRequest)((HttpRequest)HttpRequest.post((String)this.source.accessToken()).header("Authorization", header)).header("Content-Type", "application/x-www-form-urlencoded")).form("oauth_verifier", (Object)authCallback.getOauthVerifier()).execute();
        this.checkResponse(response);
        Map<String, Object> requestToken = GlobalAuthUtil.parseQueryToMap(response.body());
        return AuthToken.builder().oauthToken(requestToken.get("oauth_token").toString()).oauthTokenSecret(requestToken.get("oauth_token_secret").toString()).userId(requestToken.get("user_id").toString()).screenName(requestToken.get("screen_name").toString()).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("user_id", authToken.getUserId());
        queryParams.put("screen_name", authToken.getScreenName());
        queryParams.put("include_entities", true);
        Map<String, Object> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_token", authToken.getOauthToken());
        HashMap<String, Object> params = new HashMap<String, Object>(oauthParams);
        params.putAll(queryParams);
        oauthParams.put("oauth_signature", GlobalAuthUtil.generateTwitterSignature(params, "GET", this.source.userInfo(), this.config.getClientSecret(), authToken.getOauthTokenSecret()));
        String header = this.buildHeader(oauthParams);
        HttpResponse response = ((HttpRequest)HttpRequest.get((String)this.userInfoUrl(authToken)).header("Authorization", header)).execute();
        this.checkResponse(response);
        JSONObject userInfo = JSONObject.parseObject((String)response.body());
        return AuthUser.builder().uuid(userInfo.getString("id_str")).username(userInfo.getString("screen_name")).nickname(userInfo.getString("name")).remark(userInfo.getString("description")).avatar(userInfo.getString("profile_image_url_https")).blog(userInfo.getString("url")).location(userInfo.getString("location")).source(this.source.toString()).token(authToken).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("user_id", authToken.getUserId()).queryParam("screen_name", authToken.getScreenName()).queryParam("include_entities", true).build();
    }

    private Map<String, Object> buildOauthParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("oauth_consumer_key", this.config.getClientId());
        params.put("oauth_nonce", GlobalAuthUtil.generateNonce(32));
        params.put("oauth_signature_method", "HMAC-SHA1");
        params.put("oauth_timestamp", GlobalAuthUtil.getTimestamp());
        params.put("oauth_version", "1.0");
        return params;
    }

    private String buildHeader(Map<String, Object> oauthParams) {
        StringBuilder sb = new StringBuilder(PREAMBLE);
        for (Map.Entry<String, Object> param : oauthParams.entrySet()) {
            if (sb.length() > PREAMBLE.length()) {
                sb.append(", ");
            }
            sb.append(param.getKey()).append("=\"").append(GlobalAuthUtil.urlEncode(param.getValue().toString())).append('\"');
        }
        return sb.toString();
    }

    private void checkResponse(HttpResponse response) {
        if (!response.isOk()) {
            throw new AuthException(response.body());
        }
    }
}

