/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.utils;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.utils.StringUtils;

public class GlobalAuthUtil {
    private static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String HMAC_SHA_256 = "HmacSHA256";

    public static String generateDingTalkSignature(String secretKey, String timestamp) {
        byte[] signData = GlobalAuthUtil.sign(secretKey.getBytes(DEFAULT_ENCODING), timestamp.getBytes(DEFAULT_ENCODING), HMAC_SHA_256);
        return GlobalAuthUtil.urlEncode(new String(Base64.encode((byte[])signData, (boolean)false)));
    }

    private static byte[] sign(byte[] key, byte[] data, String algorithm) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthException("Unsupported algorithm: " + algorithm, ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthException("Invalid key: " + Arrays.toString(key), ex);
        }
    }

    public static String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, DEFAULT_ENCODING.displayName());
            return encoded.replace("+", "%20").replace("*", "%2A").replace("~", "%7E").replace("/", "%2F");
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthException("Failed To Encode Uri", e);
        }
    }

    public static String urlDecode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLDecoder.decode(value, DEFAULT_ENCODING.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthException("Failed To Decode Uri", e);
        }
    }

    public static Map<String, String> parseStringToMap(String accessTokenStr) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (accessTokenStr.contains("&")) {
            String[] fields;
            for (String field : fields = accessTokenStr.split("&")) {
                if (!field.contains("=")) continue;
                String[] keyValue = field.split("=");
                res.put(GlobalAuthUtil.urlDecode(keyValue[0]), keyValue.length == 2 ? GlobalAuthUtil.urlDecode(keyValue[1]) : null);
            }
        }
        return res;
    }

    public static String parseMapToString(Map<String, Object> params, boolean encode) {
        ArrayList paramList = new ArrayList();
        params.forEach((k, v) -> {
            if (ObjectUtil.isNull((Object)v)) {
                paramList.add(k + "=");
            } else {
                String valueString = v.toString();
                paramList.add(k + "=" + (encode ? GlobalAuthUtil.urlEncode(valueString) : valueString));
            }
        });
        return CollUtil.join(paramList, (CharSequence)"&");
    }

    public static Map<String, Object> parseQueryToMap(String url) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HttpUtil.decodeParamMap((String)url, (String)"UTF-8").forEach(paramMap::put);
        return paramMap;
    }

    public static boolean isHttpProtocol(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("http://");
    }

    public static boolean isHttpsProtocol(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("https://");
    }

    public static boolean isLocalHost(String url) {
        return StringUtils.isEmpty(url) || url.contains("127.0.0.1") || url.contains("localhost");
    }

    public static String generateNonce(int len) {
        String s = "0123456789QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm";
        Random rng = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int index = rng.nextInt(62);
            sb.append(s, index, index + 1);
        }
        return sb.toString();
    }

    public static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    public static String generateTwitterSignature(Map<String, Object> params, String method, String baseUrl, String apiSecret, String tokenSecret) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> e : params.entrySet()) {
            map.put(GlobalAuthUtil.urlEncode(e.getKey()), e.getValue());
        }
        String str = GlobalAuthUtil.parseMapToString(map, true);
        String baseStr = method.toUpperCase() + "&" + GlobalAuthUtil.urlEncode(baseUrl) + "&" + GlobalAuthUtil.urlEncode(str);
        String signKey = apiSecret + "&" + (StringUtils.isEmpty(tokenSecret) ? "" : tokenSecret);
        byte[] signature = GlobalAuthUtil.sign(signKey.getBytes(DEFAULT_ENCODING), baseStr.getBytes(DEFAULT_ENCODING), HMAC_SHA1);
        return new String(Base64.encode((byte[])signature, (boolean)false));
    }

    public static String generateElemeSignature(String appKey, String secret, long timestamp, String action, String token, Map<String, Object> parameters) {
        TreeMap<String, Object> sorted = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            sorted.put(entry.getKey(), entry.getValue());
        }
        sorted.put("app_key", appKey);
        sorted.put("timestamp", timestamp);
        StringBuffer string = new StringBuffer();
        for (Map.Entry entry : sorted.entrySet()) {
            string.append((String)entry.getKey()).append("=").append(JSON.toJSONString(entry.getValue()));
        }
        String string2 = String.format("%s%s%s%s", action, token, string, secret);
        String string3 = GlobalAuthUtil.md5(string2);
        return string3.toUpperCase();
    }

    private static String md5(String str) {
        MessageDigest md = null;
        StringBuilder buffer = null;
        try {
            md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] byteData = md.digest();
            buffer = new StringBuilder();
            for (byte byteDatum : byteData) {
                buffer.append(Integer.toString((byteDatum & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null == buffer ? "" : buffer.toString();
    }
}

