/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthCodingRequest
extends AuthDefaultRequest {
    public AuthCodingRequest(AuthConfig config) {
        super(config, AuthDefaultSource.CODING);
    }

    public AuthCodingRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.CODING, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String response = this.doGetAuthorizationCode(authCallback.getCode());
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String response = this.doGetUserInfo(authToken);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        object = object.getJSONObject("data");
        return AuthUser.builder().uuid(object.getString("id")).username(object.getString("name")).avatar("https://coding.net/" + object.getString("avatar")).blog("https://coding.net/" + object.getString("path")).nickname(object.getString("name")).company(object.getString("company")).location(object.getString("location")).gender(AuthUserGender.getRealGender(object.getString("sex"))).email(object.getString("email")).remark(object.getString("slogan")).token(authToken).source(this.source.toString()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.getIntValue("code") != 0) {
            throw new AuthException(object.getString("msg"));
        }
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", "user").queryParam("state", this.getRealState(state)).build();
    }
}

