/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.config;

import com.xkcoding.http.config.HttpConfig;
import java.util.List;
import me.zhyd.oauth.utils.StringUtils;

public class AuthConfig {
    private String clientId;
    private String clientSecret;
    private String redirectUri;
    private String alipayPublicKey;
    private boolean unionId;
    private String stackOverflowKey;
    private String agentId;
    private String domainPrefix;
    private HttpConfig httpConfig;
    private boolean ignoreCheckState;
    private List<String> scopes;
    private String deviceId;
    private Integer clientOsType;
    private String packId;
    private boolean pkce;
    private String authServerId;

    public String getAuthServerId() {
        return StringUtils.isEmpty(this.authServerId) ? "default" : this.authServerId;
    }

    public static AuthConfigBuilder builder() {
        return new AuthConfigBuilder();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getAlipayPublicKey() {
        return this.alipayPublicKey;
    }

    public boolean isUnionId() {
        return this.unionId;
    }

    public String getStackOverflowKey() {
        return this.stackOverflowKey;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getDomainPrefix() {
        return this.domainPrefix;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public boolean isIgnoreCheckState() {
        return this.ignoreCheckState;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public Integer getClientOsType() {
        return this.clientOsType;
    }

    public String getPackId() {
        return this.packId;
    }

    public boolean isPkce() {
        return this.pkce;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setAlipayPublicKey(String alipayPublicKey) {
        this.alipayPublicKey = alipayPublicKey;
    }

    public void setUnionId(boolean unionId) {
        this.unionId = unionId;
    }

    public void setStackOverflowKey(String stackOverflowKey) {
        this.stackOverflowKey = stackOverflowKey;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setDomainPrefix(String domainPrefix) {
        this.domainPrefix = domainPrefix;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setIgnoreCheckState(boolean ignoreCheckState) {
        this.ignoreCheckState = ignoreCheckState;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setClientOsType(Integer clientOsType) {
        this.clientOsType = clientOsType;
    }

    public void setPackId(String packId) {
        this.packId = packId;
    }

    public void setPkce(boolean pkce) {
        this.pkce = pkce;
    }

    public void setAuthServerId(String authServerId) {
        this.authServerId = authServerId;
    }

    public AuthConfig() {
    }

    public AuthConfig(String clientId, String clientSecret, String redirectUri, String alipayPublicKey, boolean unionId, String stackOverflowKey, String agentId, String domainPrefix, HttpConfig httpConfig, boolean ignoreCheckState, List<String> scopes, String deviceId, Integer clientOsType, String packId, boolean pkce, String authServerId) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.alipayPublicKey = alipayPublicKey;
        this.unionId = unionId;
        this.stackOverflowKey = stackOverflowKey;
        this.agentId = agentId;
        this.domainPrefix = domainPrefix;
        this.httpConfig = httpConfig;
        this.ignoreCheckState = ignoreCheckState;
        this.scopes = scopes;
        this.deviceId = deviceId;
        this.clientOsType = clientOsType;
        this.packId = packId;
        this.pkce = pkce;
        this.authServerId = authServerId;
    }

    public static class AuthConfigBuilder {
        private String clientId;
        private String clientSecret;
        private String redirectUri;
        private String alipayPublicKey;
        private boolean unionId;
        private String stackOverflowKey;
        private String agentId;
        private String domainPrefix;
        private HttpConfig httpConfig;
        private boolean ignoreCheckState;
        private List<String> scopes;
        private String deviceId;
        private Integer clientOsType;
        private String packId;
        private boolean pkce;
        private String authServerId;

        AuthConfigBuilder() {
        }

        public AuthConfigBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AuthConfigBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public AuthConfigBuilder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public AuthConfigBuilder alipayPublicKey(String alipayPublicKey) {
            this.alipayPublicKey = alipayPublicKey;
            return this;
        }

        public AuthConfigBuilder unionId(boolean unionId) {
            this.unionId = unionId;
            return this;
        }

        public AuthConfigBuilder stackOverflowKey(String stackOverflowKey) {
            this.stackOverflowKey = stackOverflowKey;
            return this;
        }

        public AuthConfigBuilder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public AuthConfigBuilder domainPrefix(String domainPrefix) {
            this.domainPrefix = domainPrefix;
            return this;
        }

        public AuthConfigBuilder httpConfig(HttpConfig httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        public AuthConfigBuilder ignoreCheckState(boolean ignoreCheckState) {
            this.ignoreCheckState = ignoreCheckState;
            return this;
        }

        public AuthConfigBuilder scopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public AuthConfigBuilder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public AuthConfigBuilder clientOsType(Integer clientOsType) {
            this.clientOsType = clientOsType;
            return this;
        }

        public AuthConfigBuilder packId(String packId) {
            this.packId = packId;
            return this;
        }

        public AuthConfigBuilder pkce(boolean pkce) {
            this.pkce = pkce;
            return this;
        }

        public AuthConfigBuilder authServerId(String authServerId) {
            this.authServerId = authServerId;
            return this;
        }

        public AuthConfig build() {
            return new AuthConfig(this.clientId, this.clientSecret, this.redirectUri, this.alipayPublicKey, this.unionId, this.stackOverflowKey, this.agentId, this.domainPrefix, this.httpConfig, this.ignoreCheckState, this.scopes, this.deviceId, this.clientOsType, this.packId, this.pkce, this.authServerId);
        }

        public String toString() {
            return "AuthConfig.AuthConfigBuilder(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", redirectUri=" + this.redirectUri + ", alipayPublicKey=" + this.alipayPublicKey + ", unionId=" + this.unionId + ", stackOverflowKey=" + this.stackOverflowKey + ", agentId=" + this.agentId + ", domainPrefix=" + this.domainPrefix + ", httpConfig=" + this.httpConfig + ", ignoreCheckState=" + this.ignoreCheckState + ", scopes=" + this.scopes + ", deviceId=" + this.deviceId + ", clientOsType=" + this.clientOsType + ", packId=" + this.packId + ", pkce=" + this.pkce + ", authServerId=" + this.authServerId + ")";
        }
    }
}

