/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.utils;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.utils.Base64Utils;
import me.zhyd.oauth.utils.StringUtils;

public class GlobalAuthUtils {
    private static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String HMAC_SHA_256 = "HmacSHA256";

    public static String generateDingTalkSignature(String secretKey, String timestamp) {
        byte[] signData = GlobalAuthUtils.sign(secretKey.getBytes(DEFAULT_ENCODING), timestamp.getBytes(DEFAULT_ENCODING), HMAC_SHA_256);
        return GlobalAuthUtils.urlEncode(new String(Base64Utils.encode(signData, false)));
    }

    private static byte[] sign(byte[] key, byte[] data, String algorithm) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthException("Unsupported algorithm: " + algorithm, ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthException("Invalid key: " + Arrays.toString(key), ex);
        }
    }

    public static String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, DEFAULT_ENCODING.displayName());
            return encoded.replace("+", "%20").replace("*", "%2A").replace("~", "%7E").replace("/", "%2F");
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthException("Failed To Encode Uri", e);
        }
    }

    public static String urlDecode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLDecoder.decode(value, DEFAULT_ENCODING.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthException("Failed To Decode Uri", e);
        }
    }

    public static Map<String, String> parseStringToMap(String accessTokenStr) {
        HashMap<String, String> res = null;
        if (accessTokenStr.contains("&")) {
            String[] fields = accessTokenStr.split("&");
            res = new HashMap((int)((double)fields.length / 0.75 + 1.0));
            for (String field : fields) {
                if (!field.contains("=")) continue;
                String[] keyValue = field.split("=");
                res.put(GlobalAuthUtils.urlDecode(keyValue[0]), keyValue.length == 2 ? GlobalAuthUtils.urlDecode(keyValue[1]) : null);
            }
        } else {
            res = new HashMap<String, String>(0);
        }
        return res;
    }

    public static String parseMapToString(Map<String, String> params, boolean encode) {
        if (null == params || params.isEmpty()) {
            return "";
        }
        ArrayList paramList = new ArrayList();
        params.forEach((k, v) -> {
            if (null == v) {
                paramList.add(k + "=");
            } else {
                paramList.add(k + "=" + (encode ? GlobalAuthUtils.urlEncode(v) : v));
            }
        });
        return String.join((CharSequence)"&", paramList);
    }

    public static boolean isHttpProtocol(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("http://");
    }

    public static boolean isHttpsProtocol(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        return url.startsWith("https://");
    }

    public static boolean isLocalHost(String url) {
        return StringUtils.isEmpty(url) || url.contains("127.0.0.1") || url.contains("localhost");
    }

    public static String generateNonce(int len) {
        String s = "0123456789QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm";
        Random rng = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            int index = rng.nextInt(62);
            sb.append(s, index, index + 1);
        }
        return sb.toString();
    }

    public static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    public static String generateTwitterSignature(Map<String, String> params, String method, String baseUrl, String apiSecret, String tokenSecret) {
        TreeMap<String, String> map = new TreeMap<String, String>(params);
        String str = GlobalAuthUtils.parseMapToString(map, true);
        String baseStr = method.toUpperCase() + "&" + GlobalAuthUtils.urlEncode(baseUrl) + "&" + GlobalAuthUtils.urlEncode(str);
        String signKey = apiSecret + "&" + (StringUtils.isEmpty(tokenSecret) ? "" : tokenSecret);
        byte[] signature = GlobalAuthUtils.sign(signKey.getBytes(DEFAULT_ENCODING), baseStr.getBytes(DEFAULT_ENCODING), HMAC_SHA1);
        return new String(Base64Utils.encode(signature, false));
    }

    public static String generateXmlySignature(Map<String, String> params, String clientSecret) {
        TreeMap<String, String> map = new TreeMap<String, String>(params);
        String baseStr = Base64Utils.encode(GlobalAuthUtils.parseMapToString(map, false));
        byte[] sign = GlobalAuthUtils.sign(clientSecret.getBytes(DEFAULT_ENCODING), baseStr.getBytes(DEFAULT_ENCODING), HMAC_SHA1);
        MessageDigest md5 = null;
        StringBuilder builder = null;
        try {
            byte[] byteData;
            builder = new StringBuilder();
            md5 = MessageDigest.getInstance("MD5");
            md5.update(sign);
            for (byte byteDatum : byteData = md5.digest()) {
                builder.append(Integer.toString((byteDatum & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null == builder ? "" : builder.toString();
    }

    public static String generateElemeSignature(String appKey, String secret, long timestamp, String action, String token, Map<String, Object> parameters) {
        TreeMap<String, Object> sorted = new TreeMap<String, Object>(parameters);
        sorted.put("app_key", appKey);
        sorted.put("timestamp", timestamp);
        StringBuffer string = new StringBuffer();
        for (Map.Entry entry : sorted.entrySet()) {
            string.append((String)entry.getKey()).append("=").append(JSON.toJSONString(entry.getValue()));
        }
        String splice = String.format("%s%s%s%s", action, token, string, secret);
        String calculatedSignature = GlobalAuthUtils.md5(splice);
        return calculatedSignature.toUpperCase();
    }

    public static String md5(String str) {
        MessageDigest md = null;
        StringBuilder buffer = null;
        try {
            md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] byteData = md.digest();
            buffer = new StringBuilder();
            for (byte byteDatum : byteData) {
                buffer.append(Integer.toString((byteDatum & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null == buffer ? "" : buffer.toString();
    }

    public static String generateJdSignature(String appSecret, Map<String, Object> params) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(params);
        StringBuilder signBuilder = new StringBuilder(appSecret);
        for (Map.Entry entry : treeMap.entrySet()) {
            String name = (String)entry.getKey();
            String value = String.valueOf(entry.getValue());
            if (!StringUtils.isNotEmpty(name) || !StringUtils.isNotEmpty(value)) continue;
            signBuilder.append(name).append(value);
        }
        signBuilder.append(appSecret);
        return GlobalAuthUtils.md5(signBuilder.toString()).toUpperCase();
    }
}

