/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.request.AbstractAuthMicrosoftRequest;
import me.zhyd.oauth.utils.GlobalAuthUtils;

public class AuthMicrosoftRequest
extends AbstractAuthMicrosoftRequest {
    public AuthMicrosoftRequest(AuthConfig config) {
        super(config, AuthDefaultSource.MICROSOFT);
    }

    public AuthMicrosoftRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.MICROSOFT, authStateCache);
    }

    @Override
    protected void checkConfig(AuthConfig config) {
        super.checkConfig(config);
        if (AuthDefaultSource.MICROSOFT == this.source && !GlobalAuthUtils.isHttpsProtocolOrLocalHost(config.getRedirectUri())) {
            throw new AuthException(AuthResponseStatus.ILLEGAL_REDIRECT_URI, this.source);
        }
    }
}

