/*
 * Decompiled with CFR 0.152.
 */
package me.zongren.pullablelayout.Main;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.Transformation;
import android.widget.ImageView;
import android.widget.TextView;
import me.zongren.pullablelayout.Constant.Result;
import me.zongren.pullablelayout.Constant.Side;
import me.zongren.pullablelayout.Constant.Status;
import me.zongren.pullablelayout.Inteface.OnSizeChangeListener;
import me.zongren.pullablelayout.Inteface.OnStatusChangeListener;
import me.zongren.pullablelayout.R;

public class PullableComponent {
    private static final int DELAYING_WHEN_FINISHED = 1000;
    private static final float POSITION_DEGREE_RATIO = 1.0f;
    private static final int MINIMUM_ANIMATION_DURATION = 200;
    private View mView;
    private ImageView mIconImageView;
    private TextView mStatusTextView;
    private RotateAnimation mRotateAnimation;
    private OnSizeChangeListener mOnSizeChangeListener;
    private OnStatusChangeListener mOnStatusChangeListener;
    private Status mStatus = Status.INADEQUATE;
    private Side mSide;
    private int mTouchDownSize = 0;
    private int mSize = 0;
    private float mAdequateSize;
    private boolean mTouching;
    private Result mResult;

    PullableComponent(Context context, ViewGroup parent, int layoutId, Side side) {
        this.mSide = side;
        this.mAdequateSize = context.getResources().getDimensionPixelSize(R.dimen.pullablelayout_default_adequate_size);
        this.mRotateAnimation = (RotateAnimation)AnimationUtils.loadAnimation((Context)context, (int)R.anim.pullablelayout_rotate_animation);
        this.mRotateAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mView = LayoutInflater.from((Context)context).inflate(layoutId, parent, false);
        this.mIconImageView = (ImageView)this.mView.findViewById(R.id.pullablelayout_component_iconImageView);
        this.mStatusTextView = (TextView)this.mView.findViewById(R.id.pullablelayout_component_statusTextView);
    }

    public void autoLoad() {
        this.setTouching(false);
        Animation animation = this.animateToPosition(this.mAdequateSize + 50.0f);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                PullableComponent.this.release();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    public void finish(Result result) {
        this.mTouching = false;
        this.mResult = result;
        this.setStatus(Status.FINISHED);
    }

    public Side getSide() {
        return this.mSide;
    }

    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        int delta = size - this.mSize;
        float degree = (float)delta * 1.0f;
        Log.i((String)this.getClass().toString(), (String)("degree is " + degree));
        float currentDegree = this.mIconImageView.getRotation();
        this.mIconImageView.setRotation(currentDegree + degree);
        this.mSize = size;
        if (this.mOnSizeChangeListener != null) {
            this.mOnSizeChangeListener.onSizeChanged(this, this.mSize);
        }
        if (!this.mTouching && this.mStatus == Status.LOADING || !this.mTouching && this.mStatus == Status.FINISHED) {
            this.mView.requestLayout();
        } else {
            if (this.isAdequate()) {
                this.setStatus(Status.ADEQUATE);
            } else {
                this.setStatus(Status.INADEQUATE);
            }
            this.mView.requestLayout();
        }
    }

    public View getView() {
        return this.mView;
    }

    public void setOnSizeChangeListener(OnSizeChangeListener onSizeChangeListener) {
        this.mOnSizeChangeListener = onSizeChangeListener;
    }

    public void setOnStatusChangeListener(OnStatusChangeListener onStatusChangeListener) {
        this.mOnStatusChangeListener = onStatusChangeListener;
    }

    private Animation animateToPosition(final float position) {
        DecelerateInterpolator easeInOutQuart = new DecelerateInterpolator();
        Animation animation = new Animation(){

            public boolean willChangeBounds() {
                return true;
            }

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                int size = (int)((float)PullableComponent.this.mSize - ((float)PullableComponent.this.mSize - position) * interpolatedTime);
                PullableComponent.this.setSize(size);
            }
        };
        animation.setInterpolator((Interpolator)easeInOutQuart);
        int durationMillis = (int)(position / this.mView.getContext().getResources().getDisplayMetrics().density);
        if (durationMillis < 200) {
            durationMillis = 200;
        }
        animation.setDuration((long)durationMillis);
        this.mView.startAnimation(animation);
        return animation;
    }

    private void hide() {
        this.setTouching(true);
        this.animateToPosition(0.0f);
    }

    private boolean isAdequate() {
        return (float)this.mSize >= this.mAdequateSize;
    }

    private void onStatusChanged(Status fromStatus, Status toStatus) {
        if (fromStatus == Status.INADEQUATE && toStatus == Status.ADEQUATE) {
            this.mStatusTextView.setText(R.string.pullablelayout_release_to_load);
            return;
        }
        if (fromStatus == Status.ADEQUATE && toStatus == Status.INADEQUATE) {
            this.mStatusTextView.setText(R.string.pullablelayout_pull_to_load);
        }
        if (fromStatus == Status.ADEQUATE && toStatus == Status.LOADING) {
            if (this.mIconImageView.getAnimation() != null) {
                this.mIconImageView.clearAnimation();
            }
            this.mIconImageView.startAnimation((Animation)this.mRotateAnimation);
            this.mStatusTextView.setText(R.string.pullablelayout_loading);
            if (this.mOnStatusChangeListener != null) {
                this.mOnStatusChangeListener.onLoading(this);
            }
        }
        if (fromStatus == Status.LOADING && toStatus == Status.ADEQUATE) {
            if (this.mIconImageView.getAnimation() != null) {
                this.mIconImageView.clearAnimation();
            }
            this.mStatusTextView.setText(R.string.pullablelayout_release_to_load);
            if (this.mOnStatusChangeListener != null) {
                this.mOnStatusChangeListener.onCanceled(this);
            }
        }
        if (fromStatus == Status.LOADING && toStatus == Status.INADEQUATE) {
            if (this.mIconImageView.getAnimation() != null) {
                this.mIconImageView.clearAnimation();
            }
            this.mStatusTextView.setText(R.string.pullablelayout_pull_to_load);
            if (this.mOnStatusChangeListener != null) {
                this.mOnStatusChangeListener.onCanceled(this);
            }
        }
        if (fromStatus == Status.LOADING && toStatus == Status.FINISHED) {
            if (this.mIconImageView.getAnimation() != null) {
                this.mIconImageView.clearAnimation();
            }
            if (this.mResult == Result.SUCCEED) {
                this.mIconImageView.setImageResource(R.mipmap.pullablelayout_ic_succeed);
                this.mStatusTextView.setText(R.string.pullablelayout_load_succeed);
            } else {
                this.mIconImageView.setImageResource(R.mipmap.pullablelayout_ic_failed);
                this.mStatusTextView.setText(R.string.pullablelayout_load_failed);
            }
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!PullableComponent.this.mTouching) {
                        PullableComponent.this.animateToPosition(0.0f);
                    }
                }
            }, 1000L);
        }
        if (fromStatus == Status.FINISHED && toStatus == Status.INADEQUATE) {
            this.mIconImageView.setImageResource(R.mipmap.pullablelayout_icon_loading);
            this.mStatusTextView.setText(R.string.pullablelayout_pull_to_load);
        }
        if (fromStatus == Status.FINISHED && toStatus == Status.ADEQUATE) {
            this.mIconImageView.setImageResource(R.mipmap.pullablelayout_icon_loading);
            this.mStatusTextView.setText(R.string.pullablelayout_release_to_load);
        }
    }

    private void setStatus(Status status) {
        if (this.mStatus != status) {
            Status previousStatus = this.mStatus;
            this.mStatus = status;
            this.onStatusChanged(previousStatus, this.mStatus);
        }
    }

    void addSize(int offset) {
        this.setSize(this.mTouchDownSize + offset);
    }

    void clearTouchDownSize() {
        this.mTouchDownSize = 0;
    }

    void recordTouchDownSize() {
        this.mTouchDownSize = this.mSize;
    }

    void release() {
        if (this.mStatus == Status.FINISHED) {
            this.hide();
        } else if (this.isAdequate()) {
            this.setStatus(Status.LOADING);
            this.animateToPosition(this.mAdequateSize);
        } else {
            this.hide();
        }
    }

    void setTouching(boolean touching) {
        this.mTouching = touching;
        if (this.mTouching) {
            this.mView.clearAnimation();
        }
    }
}

