/*
 * Decompiled with CFR 0.152.
 */
package me.zongren.pullablelayout.Main;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import me.zongren.pullablelayout.Constant.Direction;
import me.zongren.pullablelayout.Constant.Result;
import me.zongren.pullablelayout.Constant.Side;
import me.zongren.pullablelayout.Inteface.OnSizeChangeListener;
import me.zongren.pullablelayout.Inteface.OnStatusChangeListener;
import me.zongren.pullablelayout.Inteface.Pullable;
import me.zongren.pullablelayout.Main.PullableComponent;
import me.zongren.pullablelayout.R;

public class PullableLayout
extends RelativeLayout {
    public PullableComponent topComponent;
    public PullableComponent bottomComponent;
    public PullableComponent leftComponent;
    public PullableComponent rightComponent;
    private int mSide;
    private float mDistanceRatio;
    private float mVerticalDirectionRatio;
    private float mHorizontalDirectionRatio;
    private int mComponentCount = 0;
    private View mPullableView;
    private Direction mCurrentDirection = Direction.NONE;
    private float mTouchDownX;
    private float mTouchDownY;
    private OnSizeChangeListener mDummyOnSizeChangeListener;
    private OnStatusChangeListener mDummyOnStatusChangeListener;
    private Handler mHandler;
    private Runnable mRunnable;
    private boolean mIsOverlay;
    private PullableComponent mCurrentComponent;

    public PullableLayout(Context context) {
        this(context, null);
    }

    public PullableLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PullableLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray array = context.getTheme().obtainStyledAttributes(attrs, R.styleable.pullablelayout, 0, 0);
        this.mSide = array.getInt(R.styleable.pullablelayout_side, Side.TOP.getValue());
        this.mDistanceRatio = array.getFloat(R.styleable.pullablelayout_distanceRatio, 2.0f);
        this.mVerticalDirectionRatio = array.getFloat(R.styleable.pullablelayout_verticalAngle, 3.0f);
        this.mHorizontalDirectionRatio = array.getFloat(R.styleable.pullablelayout_horizontalAngle, 3.0f);
        this.mIsOverlay = array.getBoolean(R.styleable.pullablelayout_overlay, false);
        array.recycle();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mRunnable = new Runnable(){

            @Override
            public void run() {
                PullableLayout.this.mCurrentComponent.finish(Result.FAILED);
            }
        };
        this.mDummyOnSizeChangeListener = new OnSizeChangeListener(){

            @Override
            public void onSizeChanged(PullableComponent component, int size) {
                Log.i((String)this.getClass().toString(), (String)("Size of " + component.getSide().toString() + "Component is " + size));
            }
        };
        this.mDummyOnStatusChangeListener = new OnStatusChangeListener(){

            @Override
            public void onCanceled(PullableComponent component) {
                PullableLayout.this.mHandler.removeCallbacks(PullableLayout.this.mRunnable);
            }

            @Override
            public void onLoading(PullableComponent component) {
                PullableLayout.this.mHandler.postDelayed(PullableLayout.this.mRunnable, 1000L);
            }
        };
        if ((this.mSide & Side.TOP.getValue()) > 0) {
            this.topComponent = new PullableComponent(this.getContext(), (ViewGroup)this, R.layout.pullablelayout_component_top, Side.TOP);
            this.topComponent.setOnStatusChangeListener(this.mDummyOnStatusChangeListener);
            this.topComponent.setOnSizeChangeListener(this.mDummyOnSizeChangeListener);
            this.addView(this.topComponent.getView());
            ++this.mComponentCount;
        }
        if ((this.mSide & Side.LEFT.getValue()) > 0) {
            this.leftComponent = new PullableComponent(this.getContext(), (ViewGroup)this, R.layout.pullablelayout_component_left, Side.LEFT);
            this.addView(this.leftComponent.getView());
            this.leftComponent.setOnStatusChangeListener(this.mDummyOnStatusChangeListener);
            this.leftComponent.setOnSizeChangeListener(this.mDummyOnSizeChangeListener);
            ++this.mComponentCount;
        }
        if ((this.mSide & Side.BOTTOM.getValue()) > 0) {
            this.bottomComponent = new PullableComponent(this.getContext(), (ViewGroup)this, R.layout.pullablelayout_component_bottom, Side.BOTTOM);
            this.addView(this.bottomComponent.getView());
            this.bottomComponent.setOnStatusChangeListener(this.mDummyOnStatusChangeListener);
            this.bottomComponent.setOnSizeChangeListener(this.mDummyOnSizeChangeListener);
            ++this.mComponentCount;
        }
        if ((this.mSide & Side.RIGHT.getValue()) > 0) {
            this.rightComponent = new PullableComponent(this.getContext(), (ViewGroup)this, R.layout.pullablelayout_component_right, Side.RIGHT);
            this.addView(this.rightComponent.getView());
            this.rightComponent.setOnStatusChangeListener(this.mDummyOnStatusChangeListener);
            this.rightComponent.setOnSizeChangeListener(this.mDummyOnSizeChangeListener);
            ++this.mComponentCount;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getActionMasked()) {
            case 0: {
                if (this.mCurrentComponent != null) {
                    this.mCurrentComponent.recordTouchDownSize();
                    this.mCurrentComponent.setTouching(true);
                    if (this.mCurrentComponent.getSize() <= 0) {
                        this.mCurrentComponent = null;
                    }
                }
                this.mTouchDownX = ev.getX();
                this.mTouchDownY = ev.getY();
                super.dispatchTouchEvent(ev);
                return true;
            }
            case 2: {
                if (!this.handleTouchMove(ev)) break;
                return true;
            }
            case 1: 
            case 3: {
                if (this.mCurrentComponent == null) break;
                this.mCurrentComponent.release();
                this.mCurrentComponent.setTouching(false);
                return true;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mPullableView == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View view = this.getChildAt(i);
                if (!(view instanceof Pullable)) continue;
                this.mPullableView = view;
            }
            if (this.getChildCount() != this.mComponentCount + 1) {
                throw new IllegalStateException("PullableLayout has to hold only exactly one child view!");
            }
            if (!(this.mPullableView instanceof Pullable)) {
                throw new IllegalStateException("Child View must implement Pullable interface!");
            }
        }
        if (this.mCurrentComponent == null && this.topComponent != null && this.topComponent.getSize() > 0) {
            this.mCurrentComponent = this.topComponent;
        } else if (this.mCurrentComponent == null && this.leftComponent != null && this.leftComponent.getSize() > 0) {
            this.mCurrentComponent = this.leftComponent;
        } else if (this.mCurrentComponent == null && this.bottomComponent != null && this.bottomComponent.getSize() > 0) {
            this.mCurrentComponent = this.bottomComponent;
        } else if (this.mCurrentComponent == null && this.rightComponent != null && this.rightComponent.getSize() > 0) {
            this.mCurrentComponent = this.rightComponent;
        }
        int width = r - l;
        int height = b - t;
        int pullableViewLeft = this.getPaddingLeft();
        int pullableViewTop = this.getPaddingLeft();
        int pullableViewWidth = this.mPullableView.getMeasuredWidth();
        int pullableViewHeight = this.mPullableView.getMeasuredHeight();
        if (this.mCurrentComponent != null) {
            int pullableComponentLeft = this.getPaddingLeft();
            int pullableComponentTop = this.getPaddingTop();
            int pullableComponentWidth = this.mCurrentComponent.getView().getMeasuredWidth();
            int pullableComponentHeight = this.mCurrentComponent.getView().getMeasuredHeight();
            int pullableComponentSize = this.mCurrentComponent.getSize();
            switch (this.mCurrentComponent.getSide()) {
                case TOP: {
                    pullableComponentTop += pullableComponentSize - pullableComponentHeight;
                    pullableViewTop += pullableComponentSize;
                    if (this.leftComponent != null) {
                        this.leftComponent.getView().layout(-this.leftComponent.getView().getMeasuredWidth(), 0, 0, this.leftComponent.getView().getMeasuredHeight());
                    }
                    if (this.bottomComponent != null) {
                        this.bottomComponent.getView().layout(0, height, this.bottomComponent.getView().getMeasuredWidth(), height + this.bottomComponent.getView().getMeasuredHeight());
                    }
                    if (this.rightComponent == null) break;
                    this.rightComponent.getView().layout(width, 0, width + this.rightComponent.getView().getMeasuredWidth(), this.rightComponent.getView().getMeasuredHeight());
                    break;
                }
                case LEFT: {
                    pullableComponentLeft += pullableComponentSize - pullableComponentWidth;
                    pullableViewLeft += pullableComponentSize;
                    if (this.topComponent != null) {
                        this.topComponent.getView().layout(0, -this.topComponent.getView().getMeasuredHeight(), this.topComponent.getView().getMeasuredWidth(), 0);
                    }
                    if (this.bottomComponent != null) {
                        this.bottomComponent.getView().layout(0, height, this.bottomComponent.getView().getMeasuredWidth(), height + this.bottomComponent.getView().getMeasuredHeight());
                    }
                    if (this.rightComponent == null) break;
                    this.rightComponent.getView().layout(width, 0, width + this.rightComponent.getView().getMeasuredWidth(), this.rightComponent.getView().getMeasuredHeight());
                    break;
                }
                case BOTTOM: {
                    pullableComponentTop += height - pullableComponentSize;
                    pullableViewTop -= pullableComponentSize;
                    if (this.topComponent != null) {
                        this.topComponent.getView().layout(0, -this.topComponent.getView().getMeasuredHeight(), this.topComponent.getView().getMeasuredWidth(), 0);
                    }
                    if (this.leftComponent != null) {
                        this.leftComponent.getView().layout(-this.leftComponent.getView().getMeasuredWidth(), 0, 0, this.leftComponent.getView().getMeasuredHeight());
                    }
                    if (this.rightComponent == null) break;
                    this.rightComponent.getView().layout(width, 0, width + this.rightComponent.getView().getMeasuredWidth(), this.rightComponent.getView().getMeasuredHeight());
                    break;
                }
                case RIGHT: {
                    pullableComponentLeft += width - pullableComponentSize;
                    pullableViewLeft -= pullableComponentSize;
                    if (this.topComponent != null) {
                        this.topComponent.getView().layout(0, -this.topComponent.getView().getMeasuredHeight(), this.topComponent.getView().getMeasuredWidth(), 0);
                    }
                    if (this.leftComponent != null) {
                        this.leftComponent.getView().layout(-this.leftComponent.getView().getMeasuredWidth(), 0, 0, this.leftComponent.getView().getMeasuredHeight());
                    }
                    if (this.bottomComponent == null) break;
                    this.bottomComponent.getView().layout(0, height, this.bottomComponent.getView().getMeasuredWidth(), height + this.bottomComponent.getView().getMeasuredHeight());
                }
            }
            int pullableComponentRight = pullableComponentLeft + pullableComponentWidth;
            int pullableComponentBottom = pullableComponentTop + pullableComponentHeight;
            this.mCurrentComponent.getView().layout(pullableComponentLeft, pullableComponentTop, pullableComponentRight, pullableComponentBottom);
        } else {
            if (this.topComponent != null) {
                this.topComponent.getView().layout(0, -this.topComponent.getView().getMeasuredHeight(), this.topComponent.getView().getMeasuredWidth(), 0);
            }
            if (this.leftComponent != null) {
                this.leftComponent.getView().layout(-this.leftComponent.getView().getMeasuredWidth(), 0, 0, this.leftComponent.getView().getMeasuredHeight());
            }
            if (this.bottomComponent != null) {
                this.bottomComponent.getView().layout(0, height, this.bottomComponent.getView().getMeasuredWidth(), height + this.bottomComponent.getView().getMeasuredHeight());
            }
            if (this.rightComponent != null) {
                this.rightComponent.getView().layout(width, 0, width + this.rightComponent.getView().getMeasuredWidth(), this.rightComponent.getView().getMeasuredHeight());
            }
        }
        if (!this.mIsOverlay) {
            int pullableViewBottom = pullableViewTop + pullableViewHeight;
            int pullableViewRight = pullableViewLeft + pullableViewWidth;
            this.mPullableView.layout(pullableViewLeft, pullableViewTop, pullableViewRight, pullableViewBottom);
        }
    }

    private boolean handleTouchMove(MotionEvent ev) {
        boolean intercept = true;
        float currentX = ev.getX();
        float currentY = ev.getY();
        float offsetX = currentX - this.mTouchDownX;
        float offsetY = currentY - this.mTouchDownY;
        float absOffsetX = Math.abs(offsetX);
        float absOffsetY = Math.abs(offsetY);
        if (this.mCurrentComponent != null) {
            this.mCurrentComponent.setTouching(true);
            switch (this.mCurrentComponent.getSide()) {
                case TOP: {
                    this.mCurrentComponent.addSize((int)(offsetY / this.mDistanceRatio));
                    break;
                }
                case BOTTOM: {
                    this.mCurrentComponent.addSize(-((int)(offsetY / this.mDistanceRatio)));
                    break;
                }
                case LEFT: {
                    this.mCurrentComponent.addSize((int)(offsetX / this.mDistanceRatio));
                    break;
                }
                case RIGHT: {
                    this.mCurrentComponent.addSize(-((int)(offsetX / this.mDistanceRatio)));
                }
            }
            if (this.mCurrentComponent.getSize() <= 0) {
                this.mTouchDownX = ev.getX();
                this.mTouchDownY = ev.getY();
                this.mCurrentComponent.clearTouchDownSize();
                this.mCurrentComponent = null;
                intercept = false;
            } else {
                intercept = true;
            }
        } else {
            if (offsetX == 0.0f) {
                if (offsetY > 0.0f) {
                    this.mCurrentDirection = Direction.FROM_TOP_TO_BOTTOM;
                } else if (offsetY < 0.0f) {
                    this.mCurrentDirection = Direction.FROM_BOTTOM_TO_TOP;
                }
            } else if (offsetY == 0.0f) {
                if (offsetX > 0.0f) {
                    this.mCurrentDirection = Direction.FROM_LEFT_TO_RIGHT;
                } else if (offsetX < 0.0f) {
                    this.mCurrentDirection = Direction.FROM_RIGHT_TO_LEFT;
                }
            } else if (absOffsetX >= absOffsetY) {
                if (absOffsetX / absOffsetY >= this.mHorizontalDirectionRatio) {
                    if (offsetX > 0.0f) {
                        this.mCurrentDirection = Direction.FROM_LEFT_TO_RIGHT;
                    } else if (offsetX < 0.0f) {
                        this.mCurrentDirection = Direction.FROM_RIGHT_TO_LEFT;
                    }
                } else {
                    this.mCurrentDirection = Direction.NONE;
                }
            } else if (absOffsetY / absOffsetX >= this.mVerticalDirectionRatio) {
                if (offsetY > 0.0f) {
                    this.mCurrentDirection = Direction.FROM_TOP_TO_BOTTOM;
                } else if (offsetY < 0.0f) {
                    this.mCurrentDirection = Direction.FROM_BOTTOM_TO_TOP;
                }
            } else {
                this.mCurrentDirection = Direction.NONE;
            }
            switch (this.mCurrentDirection) {
                case FROM_TOP_TO_BOTTOM: {
                    if (this.topComponent != null && ((Pullable)this.mPullableView).reachEdgeOfSide(Side.TOP)) {
                        this.mCurrentComponent = this.topComponent;
                        intercept = true;
                        break;
                    }
                    intercept = false;
                    break;
                }
                case FROM_BOTTOM_TO_TOP: {
                    if (this.bottomComponent != null && ((Pullable)this.mPullableView).reachEdgeOfSide(Side.BOTTOM)) {
                        this.mCurrentComponent = this.bottomComponent;
                        intercept = true;
                        break;
                    }
                    intercept = false;
                    break;
                }
                case FROM_LEFT_TO_RIGHT: {
                    if (this.leftComponent != null && ((Pullable)this.mPullableView).reachEdgeOfSide(Side.LEFT)) {
                        this.mCurrentComponent = this.leftComponent;
                        intercept = true;
                        break;
                    }
                    intercept = false;
                    break;
                }
                case FROM_RIGHT_TO_LEFT: {
                    if (this.rightComponent != null && ((Pullable)this.mPullableView).reachEdgeOfSide(Side.RIGHT)) {
                        this.mCurrentComponent = this.rightComponent;
                        intercept = true;
                        break;
                    }
                    intercept = false;
                    break;
                }
                default: {
                    intercept = false;
                }
            }
            if (intercept && this.mCurrentComponent != null) {
                this.mTouchDownX = ev.getX();
                this.mTouchDownY = ev.getY();
                offsetX = currentX - this.mTouchDownX;
                offsetY = currentY - this.mTouchDownY;
                absOffsetX = Math.abs(offsetX);
                absOffsetY = Math.abs(offsetY);
                switch (this.mCurrentComponent.getSide()) {
                    case TOP: {
                        this.mCurrentComponent.setSize((int)(absOffsetY / this.mDistanceRatio));
                        break;
                    }
                    case LEFT: {
                        this.mCurrentComponent.setSize((int)(absOffsetX / this.mDistanceRatio));
                        break;
                    }
                    case BOTTOM: {
                        this.mCurrentComponent.setSize((int)(absOffsetY / this.mDistanceRatio));
                        break;
                    }
                    case RIGHT: {
                        this.mCurrentComponent.setSize((int)(absOffsetX / this.mDistanceRatio));
                    }
                }
            }
        }
        return intercept;
    }
}

