/*
 * Decompiled with CFR 0.152.
 */
package me.zongren.pullablelayout.View;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.View;
import me.zongren.pullablelayout.Constant.Side;
import me.zongren.pullablelayout.Inteface.Pullable;

public class PullableRecyclerView
extends RecyclerView
implements Pullable {
    private static final String TAG = "PullableRecyclerView";

    public PullableRecyclerView(Context context) {
        super(context);
    }

    public PullableRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PullableRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean reachEdgeOfBottom() {
        if (this.getChildCount() == 0) {
            return true;
        }
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            int height;
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            if (linearLayoutManager.getOrientation() == 0) {
                return true;
            }
            View lastChild = linearLayoutManager.getChildAt(linearLayoutManager.getChildCount() - 1);
            int top = lastChild.getTop();
            return top + (height = lastChild.getHeight()) <= this.getHeight();
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
            if (staggeredGridLayoutManager.getOrientation() == 0) {
                return true;
            }
            if (staggeredGridLayoutManager.getSpanCount() == 0) {
                return true;
            }
            int[] positions = staggeredGridLayoutManager.findLastCompletelyVisibleItemPositions(null);
            return positions[staggeredGridLayoutManager.getSpanCount() - 1] == staggeredGridLayoutManager.getChildCount() - 1;
        }
        return false;
    }

    @Override
    public boolean reachEdgeOfSide(Side side) {
        if ((side.getValue() & Side.TOP.getValue()) > 0) {
            return this.reachEdgeOfTop();
        }
        if ((side.getValue() & Side.BOTTOM.getValue()) > 0) {
            return this.reachEdgeOfBottom();
        }
        if ((side.getValue() & Side.LEFT.getValue()) > 0) {
            return this.reachEdgeOfLeft();
        }
        if ((side.getValue() & Side.RIGHT.getValue()) > 0) {
            return this.reachEdgeOfRight();
        }
        return false;
    }

    public boolean reachEdgeOfTop() {
        if (this.getChildCount() == 0) {
            return true;
        }
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            if (linearLayoutManager.getOrientation() == 0) {
                return true;
            }
            return linearLayoutManager.findFirstCompletelyVisibleItemPosition() == 0;
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
            if (staggeredGridLayoutManager.getOrientation() == 0) {
                return true;
            }
            if (staggeredGridLayoutManager.getSpanCount() == 0) {
                return true;
            }
            int[] positions = staggeredGridLayoutManager.findFirstCompletelyVisibleItemPositions(null);
            return positions[0] == 0;
        }
        return false;
    }

    private boolean reachEdgeOfLeft() {
        if (this.getChildCount() == 0) {
            return true;
        }
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            if (linearLayoutManager.getOrientation() == 1) {
                return true;
            }
            return linearLayoutManager.findFirstCompletelyVisibleItemPosition() == 0;
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
            if (staggeredGridLayoutManager.getOrientation() == 1) {
                return true;
            }
            if (staggeredGridLayoutManager.getSpanCount() == 0) {
                return true;
            }
            int[] positions = staggeredGridLayoutManager.findFirstCompletelyVisibleItemPositions(null);
            return positions[0] == 0;
        }
        return false;
    }

    private boolean reachEdgeOfRight() {
        if (this.getChildCount() == 0) {
            return true;
        }
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            if (linearLayoutManager.getOrientation() == 1) {
                return true;
            }
            return linearLayoutManager.findLastCompletelyVisibleItemPosition() == this.getAdapter().getItemCount() - 1;
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
            if (staggeredGridLayoutManager.getOrientation() == 1) {
                return true;
            }
            if (staggeredGridLayoutManager.getSpanCount() == 0) {
                return true;
            }
            int[] positions = staggeredGridLayoutManager.findLastCompletelyVisibleItemPositions(null);
            return positions[staggeredGridLayoutManager.getSpanCount() - 1] == staggeredGridLayoutManager.getChildCount() - 1;
        }
        return false;
    }
}

