/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.api;

import embyclient.ApiCallback;
import embyclient.ApiClient;
import embyclient.ApiException;
import embyclient.ApiResponse;
import embyclient.Configuration;
import embyclient.Pair;
import embyclient.ProgressRequestBody;
import embyclient.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import embyclient.model.DataExplorer2ModelEnumsShowProviders;
import embyclient.model.DataExplorer2ModelItemDataTable;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataExplorerApiApi {
    private ApiClient apiClient;

    public DataExplorerApiApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataExplorerApiApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for getItemsByItemidItemrawdata
     * @param itemId The id of the item (required)
     * @param language The metadata language (optional)
     * @param providers The metadata providers to query (optional)
     * @param showAllFields Whether to show all fields (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getItemsByItemidItemrawdataCall(String itemId, String language, DataExplorer2ModelEnumsShowProviders providers, Boolean showAllFields, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/Items/{ItemId}/ItemRawData"
            .replaceAll("\\{" + "ItemId" + "\\}", apiClient.escapeString(itemId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (language != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("Language", language));
        if (providers != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("Providers", providers));
        if (showAllFields != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("ShowAllFields", showAllFields));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/xml"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "apikeyauth", "embyauth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getItemsByItemidItemrawdataValidateBeforeCall(String itemId, String language, DataExplorer2ModelEnumsShowProviders providers, Boolean showAllFields, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'itemId' is set
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling getItemsByItemidItemrawdata(Async)");
        }
        
        com.squareup.okhttp.Call call = getItemsByItemidItemrawdataCall(itemId, language, providers, showAllFields, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Gets raw metadata for an item
     * Requires authentication as administrator
     * @param itemId The id of the item (required)
     * @param language The metadata language (optional)
     * @param providers The metadata providers to query (optional)
     * @param showAllFields Whether to show all fields (optional)
     * @return DataExplorer2ModelItemDataTable
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DataExplorer2ModelItemDataTable getItemsByItemidItemrawdata(String itemId, String language, DataExplorer2ModelEnumsShowProviders providers, Boolean showAllFields) throws ApiException {
        ApiResponse<DataExplorer2ModelItemDataTable> resp = getItemsByItemidItemrawdataWithHttpInfo(itemId, language, providers, showAllFields);
        return resp.getData();
    }

    /**
     * Gets raw metadata for an item
     * Requires authentication as administrator
     * @param itemId The id of the item (required)
     * @param language The metadata language (optional)
     * @param providers The metadata providers to query (optional)
     * @param showAllFields Whether to show all fields (optional)
     * @return ApiResponse&lt;DataExplorer2ModelItemDataTable&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DataExplorer2ModelItemDataTable> getItemsByItemidItemrawdataWithHttpInfo(String itemId, String language, DataExplorer2ModelEnumsShowProviders providers, Boolean showAllFields) throws ApiException {
        com.squareup.okhttp.Call call = getItemsByItemidItemrawdataValidateBeforeCall(itemId, language, providers, showAllFields, null, null);
        Type localVarReturnType = new TypeToken<DataExplorer2ModelItemDataTable>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Gets raw metadata for an item (asynchronously)
     * Requires authentication as administrator
     * @param itemId The id of the item (required)
     * @param language The metadata language (optional)
     * @param providers The metadata providers to query (optional)
     * @param showAllFields Whether to show all fields (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getItemsByItemidItemrawdataAsync(String itemId, String language, DataExplorer2ModelEnumsShowProviders providers, Boolean showAllFields, final ApiCallback<DataExplorer2ModelItemDataTable> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getItemsByItemidItemrawdataValidateBeforeCall(itemId, language, providers, showAllFields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DataExplorer2ModelItemDataTable>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
