/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.api;

import embyclient.ApiCallback;
import embyclient.ApiClient;
import embyclient.ApiException;
import embyclient.ApiResponse;
import embyclient.Configuration;
import embyclient.Pair;
import embyclient.ProgressRequestBody;
import embyclient.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import embyclient.model.NameValuePair;
import embyclient.model.ProviderIdDictionary;
import embyclient.model.QueryResultAutoOrganizeModelFileOrganizationResult;
import embyclient.model.QueryResultAutoOrganizeModelSmartMatchInfo;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileOrganizationServiceApi {
    private ApiClient apiClient;

    public FileOrganizationServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FileOrganizationServiceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteLibraryFileorganizations
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteLibraryFileorganizationsCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/Library/FileOrganizations";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "apikeyauth", "embyauth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteLibraryFileorganizationsValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        com.squareup.okhttp.Call call = deleteLibraryFileorganizationsCall(progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Clears the activity log
     * Requires authentication as administrator
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteLibraryFileorganizations() throws ApiException {
        deleteLibraryFileorganizationsWithHttpInfo();
    }

    /**
     * Clears the activity log
     * Requires authentication as administrator
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteLibraryFileorganizationsWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = deleteLibraryFileorganizationsValidateBeforeCall(null, null);
        return apiClient.execute(call);
    }

    /**
     * Clears the activity log (asynchronously)
     * Requires authentication as administrator
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteLibraryFileorganizationsAsync(final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteLibraryFileorganizationsValidateBeforeCall(progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteLibraryFileorganizationsByIdFile
     * @param id Result Id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteLibraryFileorganizationsByIdFileCall(String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/Library/FileOrganizations/{Id}/File"
            .replaceAll("\\{" + "Id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "apikeyauth", "embyauth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteLibraryFileorganizationsByIdFileValidateBeforeCall(String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteLibraryFileorganizationsByIdFile(Async)");
        }
        
        com.squareup.okhttp.Call call = deleteLibraryFileorganizationsByIdFileCall(id, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Deletes the original file of a organizer result
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteLibraryFileorganizationsByIdFile(String id) throws ApiException {
        deleteLibraryFileorganizationsByIdFileWithHttpInfo(id);
    }

    /**
     * Deletes the original file of a organizer result
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteLibraryFileorganizationsByIdFileWithHttpInfo(String id) throws ApiException {
        com.squareup.okhttp.Call call = deleteLibraryFileorganizationsByIdFileValidateBeforeCall(id, null, null);
        return apiClient.execute(call);
    }

    /**
     * Deletes the original file of a organizer result (asynchronously)
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteLibraryFileorganizationsByIdFileAsync(String id, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteLibraryFileorganizationsByIdFileValidateBeforeCall(id, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteLibraryFileorganizationsCompleted
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteLibraryFileorganizationsCompletedCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/Library/FileOrganizations/Completed";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "apikeyauth", "embyauth" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteLibraryFileorganizationsCompletedValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        com.squareup.okhttp.Call call = deleteLibraryFileorganizationsCompletedCall(progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Clears the activity log
     * Requires authentication as administrator
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteLibraryFileorganizationsCompleted() throws ApiException {
        deleteLibraryFileorganizationsCompletedWithHttpInfo();
    }

    /**
     * Clears the activity log
     * Requires authentication as administrator
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteLibraryFileorganizationsCompletedWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = deleteLibraryFileorganizationsCompletedValidateBeforeCall(null, null);
        return apiClient.execute(call);
    }

    /**
     * Clears the activity log (asynchronously)
     * Requires authentication as administrator
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteLibraryFileorganizationsCompletedAsync(final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteLibraryFileorganizationsCompletedValidateBeforeCall(progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getLibraryFileorganization
     * @param startIndex Optional. The record index to start at. All items with a lower index will be dropped from the results. (optional)
     * @param limit Optional. The maximum number of records to return (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLibraryFileorganizationCall(Integer startIndex, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/Library/FileOrganization";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startIndex != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("StartIndex", startIndex));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("Limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/xml"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "apikeyauth", "embyauth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLibraryFileorganizationValidateBeforeCall(Integer startIndex, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        com.squareup.okhttp.Call call = getLibraryFileorganizationCall(startIndex, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Gets file organization results
     * Requires authentication as administrator
     * @param startIndex Optional. The record index to start at. All items with a lower index will be dropped from the results. (optional)
     * @param limit Optional. The maximum number of records to return (optional)
     * @return QueryResultAutoOrganizeModelFileOrganizationResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public QueryResultAutoOrganizeModelFileOrganizationResult getLibraryFileorganization(Integer startIndex, Integer limit) throws ApiException {
        ApiResponse<QueryResultAutoOrganizeModelFileOrganizationResult> resp = getLibraryFileorganizationWithHttpInfo(startIndex, limit);
        return resp.getData();
    }

    /**
     * Gets file organization results
     * Requires authentication as administrator
     * @param startIndex Optional. The record index to start at. All items with a lower index will be dropped from the results. (optional)
     * @param limit Optional. The maximum number of records to return (optional)
     * @return ApiResponse&lt;QueryResultAutoOrganizeModelFileOrganizationResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<QueryResultAutoOrganizeModelFileOrganizationResult> getLibraryFileorganizationWithHttpInfo(Integer startIndex, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = getLibraryFileorganizationValidateBeforeCall(startIndex, limit, null, null);
        Type localVarReturnType = new TypeToken<QueryResultAutoOrganizeModelFileOrganizationResult>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Gets file organization results (asynchronously)
     * Requires authentication as administrator
     * @param startIndex Optional. The record index to start at. All items with a lower index will be dropped from the results. (optional)
     * @param limit Optional. The maximum number of records to return (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLibraryFileorganizationAsync(Integer startIndex, Integer limit, final ApiCallback<QueryResultAutoOrganizeModelFileOrganizationResult> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getLibraryFileorganizationValidateBeforeCall(startIndex, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryResultAutoOrganizeModelFileOrganizationResult>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getLibraryFileorganizationsSmartmatches
     * @param startIndex Optional. The record index to start at. All items with a lower index will be dropped from the results. (optional)
     * @param limit Optional. The maximum number of records to return (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLibraryFileorganizationsSmartmatchesCall(Integer startIndex, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/Library/FileOrganizations/SmartMatches";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startIndex != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("StartIndex", startIndex));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("Limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/xml"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "apikeyauth", "embyauth" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLibraryFileorganizationsSmartmatchesValidateBeforeCall(Integer startIndex, Integer limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        com.squareup.okhttp.Call call = getLibraryFileorganizationsSmartmatchesCall(startIndex, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Gets smart match entries
     * Requires authentication as administrator
     * @param startIndex Optional. The record index to start at. All items with a lower index will be dropped from the results. (optional)
     * @param limit Optional. The maximum number of records to return (optional)
     * @return QueryResultAutoOrganizeModelSmartMatchInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public QueryResultAutoOrganizeModelSmartMatchInfo getLibraryFileorganizationsSmartmatches(Integer startIndex, Integer limit) throws ApiException {
        ApiResponse<QueryResultAutoOrganizeModelSmartMatchInfo> resp = getLibraryFileorganizationsSmartmatchesWithHttpInfo(startIndex, limit);
        return resp.getData();
    }

    /**
     * Gets smart match entries
     * Requires authentication as administrator
     * @param startIndex Optional. The record index to start at. All items with a lower index will be dropped from the results. (optional)
     * @param limit Optional. The maximum number of records to return (optional)
     * @return ApiResponse&lt;QueryResultAutoOrganizeModelSmartMatchInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<QueryResultAutoOrganizeModelSmartMatchInfo> getLibraryFileorganizationsSmartmatchesWithHttpInfo(Integer startIndex, Integer limit) throws ApiException {
        com.squareup.okhttp.Call call = getLibraryFileorganizationsSmartmatchesValidateBeforeCall(startIndex, limit, null, null);
        Type localVarReturnType = new TypeToken<QueryResultAutoOrganizeModelSmartMatchInfo>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Gets smart match entries (asynchronously)
     * Requires authentication as administrator
     * @param startIndex Optional. The record index to start at. All items with a lower index will be dropped from the results. (optional)
     * @param limit Optional. The maximum number of records to return (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLibraryFileorganizationsSmartmatchesAsync(Integer startIndex, Integer limit, final ApiCallback<QueryResultAutoOrganizeModelSmartMatchInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getLibraryFileorganizationsSmartmatchesValidateBeforeCall(startIndex, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryResultAutoOrganizeModelSmartMatchInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postLibraryFileorganizationsByIdEpisodeOrganize
     * @param id Result Id (required)
     * @param seriesId Series Id (required)
     * @param seasonNumber  (required)
     * @param episodeNumber  (required)
     * @param endingEpisodeNumber  (optional)
     * @param rememberCorrection Whether or not to apply the same correction to future episodes of the same series. (optional)
     * @param newSeriesProviderIds A list of provider IDs identifying a new series. (optional)
     * @param newSeriesName Name of a series to add. (optional)
     * @param newSeriesYear Year of a series to add. (optional)
     * @param targetFolder Target Folder (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postLibraryFileorganizationsByIdEpisodeOrganizeCall(String id, String seriesId, Integer seasonNumber, Integer episodeNumber, Integer endingEpisodeNumber, Boolean rememberCorrection, ProviderIdDictionary newSeriesProviderIds, String newSeriesName, Integer newSeriesYear, String targetFolder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/Library/FileOrganizations/{Id}/Episode/Organize"
            .replaceAll("\\{" + "Id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (seriesId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("SeriesId", seriesId));
        if (seasonNumber != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("SeasonNumber", seasonNumber));
        if (episodeNumber != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("EpisodeNumber", episodeNumber));
        if (endingEpisodeNumber != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("EndingEpisodeNumber", endingEpisodeNumber));
        if (rememberCorrection != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("RememberCorrection", rememberCorrection));
        if (newSeriesProviderIds != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("NewSeriesProviderIds", newSeriesProviderIds));
        if (newSeriesName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("NewSeriesName", newSeriesName));
        if (newSeriesYear != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("NewSeriesYear", newSeriesYear));
        if (targetFolder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("TargetFolder", targetFolder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "apikeyauth", "embyauth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postLibraryFileorganizationsByIdEpisodeOrganizeValidateBeforeCall(String id, String seriesId, Integer seasonNumber, Integer episodeNumber, Integer endingEpisodeNumber, Boolean rememberCorrection, ProviderIdDictionary newSeriesProviderIds, String newSeriesName, Integer newSeriesYear, String targetFolder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postLibraryFileorganizationsByIdEpisodeOrganize(Async)");
        }
        // verify the required parameter 'seriesId' is set
        if (seriesId == null) {
            throw new ApiException("Missing the required parameter 'seriesId' when calling postLibraryFileorganizationsByIdEpisodeOrganize(Async)");
        }
        // verify the required parameter 'seasonNumber' is set
        if (seasonNumber == null) {
            throw new ApiException("Missing the required parameter 'seasonNumber' when calling postLibraryFileorganizationsByIdEpisodeOrganize(Async)");
        }
        // verify the required parameter 'episodeNumber' is set
        if (episodeNumber == null) {
            throw new ApiException("Missing the required parameter 'episodeNumber' when calling postLibraryFileorganizationsByIdEpisodeOrganize(Async)");
        }
        
        com.squareup.okhttp.Call call = postLibraryFileorganizationsByIdEpisodeOrganizeCall(id, seriesId, seasonNumber, episodeNumber, endingEpisodeNumber, rememberCorrection, newSeriesProviderIds, newSeriesName, newSeriesYear, targetFolder, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Performs organization of a tv episode
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @param seriesId Series Id (required)
     * @param seasonNumber  (required)
     * @param episodeNumber  (required)
     * @param endingEpisodeNumber  (optional)
     * @param rememberCorrection Whether or not to apply the same correction to future episodes of the same series. (optional)
     * @param newSeriesProviderIds A list of provider IDs identifying a new series. (optional)
     * @param newSeriesName Name of a series to add. (optional)
     * @param newSeriesYear Year of a series to add. (optional)
     * @param targetFolder Target Folder (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void postLibraryFileorganizationsByIdEpisodeOrganize(String id, String seriesId, Integer seasonNumber, Integer episodeNumber, Integer endingEpisodeNumber, Boolean rememberCorrection, ProviderIdDictionary newSeriesProviderIds, String newSeriesName, Integer newSeriesYear, String targetFolder) throws ApiException {
        postLibraryFileorganizationsByIdEpisodeOrganizeWithHttpInfo(id, seriesId, seasonNumber, episodeNumber, endingEpisodeNumber, rememberCorrection, newSeriesProviderIds, newSeriesName, newSeriesYear, targetFolder);
    }

    /**
     * Performs organization of a tv episode
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @param seriesId Series Id (required)
     * @param seasonNumber  (required)
     * @param episodeNumber  (required)
     * @param endingEpisodeNumber  (optional)
     * @param rememberCorrection Whether or not to apply the same correction to future episodes of the same series. (optional)
     * @param newSeriesProviderIds A list of provider IDs identifying a new series. (optional)
     * @param newSeriesName Name of a series to add. (optional)
     * @param newSeriesYear Year of a series to add. (optional)
     * @param targetFolder Target Folder (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> postLibraryFileorganizationsByIdEpisodeOrganizeWithHttpInfo(String id, String seriesId, Integer seasonNumber, Integer episodeNumber, Integer endingEpisodeNumber, Boolean rememberCorrection, ProviderIdDictionary newSeriesProviderIds, String newSeriesName, Integer newSeriesYear, String targetFolder) throws ApiException {
        com.squareup.okhttp.Call call = postLibraryFileorganizationsByIdEpisodeOrganizeValidateBeforeCall(id, seriesId, seasonNumber, episodeNumber, endingEpisodeNumber, rememberCorrection, newSeriesProviderIds, newSeriesName, newSeriesYear, targetFolder, null, null);
        return apiClient.execute(call);
    }

    /**
     * Performs organization of a tv episode (asynchronously)
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @param seriesId Series Id (required)
     * @param seasonNumber  (required)
     * @param episodeNumber  (required)
     * @param endingEpisodeNumber  (optional)
     * @param rememberCorrection Whether or not to apply the same correction to future episodes of the same series. (optional)
     * @param newSeriesProviderIds A list of provider IDs identifying a new series. (optional)
     * @param newSeriesName Name of a series to add. (optional)
     * @param newSeriesYear Year of a series to add. (optional)
     * @param targetFolder Target Folder (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postLibraryFileorganizationsByIdEpisodeOrganizeAsync(String id, String seriesId, Integer seasonNumber, Integer episodeNumber, Integer endingEpisodeNumber, Boolean rememberCorrection, ProviderIdDictionary newSeriesProviderIds, String newSeriesName, Integer newSeriesYear, String targetFolder, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postLibraryFileorganizationsByIdEpisodeOrganizeValidateBeforeCall(id, seriesId, seasonNumber, episodeNumber, endingEpisodeNumber, rememberCorrection, newSeriesProviderIds, newSeriesName, newSeriesYear, targetFolder, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for postLibraryFileorganizationsByIdMovieOrganize
     * @param id Result Id (required)
     * @param movieId Movie Id (required)
     * @param newMovieProviderIds A list of provider IDs identifying a new movie. (optional)
     * @param newMovieName Name of a movie to add. (optional)
     * @param newMovieYear Year of a movie to add. (optional)
     * @param targetFolder Target Folder (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postLibraryFileorganizationsByIdMovieOrganizeCall(String id, String movieId, ProviderIdDictionary newMovieProviderIds, String newMovieName, Integer newMovieYear, String targetFolder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/Library/FileOrganizations/{Id}/Movie/Organize"
            .replaceAll("\\{" + "Id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (movieId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("MovieId", movieId));
        if (newMovieProviderIds != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("NewMovieProviderIds", newMovieProviderIds));
        if (newMovieName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("NewMovieName", newMovieName));
        if (newMovieYear != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("NewMovieYear", newMovieYear));
        if (targetFolder != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("TargetFolder", targetFolder));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "apikeyauth", "embyauth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postLibraryFileorganizationsByIdMovieOrganizeValidateBeforeCall(String id, String movieId, ProviderIdDictionary newMovieProviderIds, String newMovieName, Integer newMovieYear, String targetFolder, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postLibraryFileorganizationsByIdMovieOrganize(Async)");
        }
        // verify the required parameter 'movieId' is set
        if (movieId == null) {
            throw new ApiException("Missing the required parameter 'movieId' when calling postLibraryFileorganizationsByIdMovieOrganize(Async)");
        }
        
        com.squareup.okhttp.Call call = postLibraryFileorganizationsByIdMovieOrganizeCall(id, movieId, newMovieProviderIds, newMovieName, newMovieYear, targetFolder, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Performs organization of a movie
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @param movieId Movie Id (required)
     * @param newMovieProviderIds A list of provider IDs identifying a new movie. (optional)
     * @param newMovieName Name of a movie to add. (optional)
     * @param newMovieYear Year of a movie to add. (optional)
     * @param targetFolder Target Folder (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void postLibraryFileorganizationsByIdMovieOrganize(String id, String movieId, ProviderIdDictionary newMovieProviderIds, String newMovieName, Integer newMovieYear, String targetFolder) throws ApiException {
        postLibraryFileorganizationsByIdMovieOrganizeWithHttpInfo(id, movieId, newMovieProviderIds, newMovieName, newMovieYear, targetFolder);
    }

    /**
     * Performs organization of a movie
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @param movieId Movie Id (required)
     * @param newMovieProviderIds A list of provider IDs identifying a new movie. (optional)
     * @param newMovieName Name of a movie to add. (optional)
     * @param newMovieYear Year of a movie to add. (optional)
     * @param targetFolder Target Folder (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> postLibraryFileorganizationsByIdMovieOrganizeWithHttpInfo(String id, String movieId, ProviderIdDictionary newMovieProviderIds, String newMovieName, Integer newMovieYear, String targetFolder) throws ApiException {
        com.squareup.okhttp.Call call = postLibraryFileorganizationsByIdMovieOrganizeValidateBeforeCall(id, movieId, newMovieProviderIds, newMovieName, newMovieYear, targetFolder, null, null);
        return apiClient.execute(call);
    }

    /**
     * Performs organization of a movie (asynchronously)
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @param movieId Movie Id (required)
     * @param newMovieProviderIds A list of provider IDs identifying a new movie. (optional)
     * @param newMovieName Name of a movie to add. (optional)
     * @param newMovieYear Year of a movie to add. (optional)
     * @param targetFolder Target Folder (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postLibraryFileorganizationsByIdMovieOrganizeAsync(String id, String movieId, ProviderIdDictionary newMovieProviderIds, String newMovieName, Integer newMovieYear, String targetFolder, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postLibraryFileorganizationsByIdMovieOrganizeValidateBeforeCall(id, movieId, newMovieProviderIds, newMovieName, newMovieYear, targetFolder, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for postLibraryFileorganizationsByIdOrganize
     * @param id Result Id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postLibraryFileorganizationsByIdOrganizeCall(String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/Library/FileOrganizations/{Id}/Organize"
            .replaceAll("\\{" + "Id" + "\\}", apiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/xml"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "apikeyauth", "embyauth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postLibraryFileorganizationsByIdOrganizeValidateBeforeCall(String id, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postLibraryFileorganizationsByIdOrganize(Async)");
        }
        
        com.squareup.okhttp.Call call = postLibraryFileorganizationsByIdOrganizeCall(id, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Performs an organization
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @return QueryResultAutoOrganizeModelFileOrganizationResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public QueryResultAutoOrganizeModelFileOrganizationResult postLibraryFileorganizationsByIdOrganize(String id) throws ApiException {
        ApiResponse<QueryResultAutoOrganizeModelFileOrganizationResult> resp = postLibraryFileorganizationsByIdOrganizeWithHttpInfo(id);
        return resp.getData();
    }

    /**
     * Performs an organization
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @return ApiResponse&lt;QueryResultAutoOrganizeModelFileOrganizationResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<QueryResultAutoOrganizeModelFileOrganizationResult> postLibraryFileorganizationsByIdOrganizeWithHttpInfo(String id) throws ApiException {
        com.squareup.okhttp.Call call = postLibraryFileorganizationsByIdOrganizeValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<QueryResultAutoOrganizeModelFileOrganizationResult>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Performs an organization (asynchronously)
     * Requires authentication as administrator
     * @param id Result Id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postLibraryFileorganizationsByIdOrganizeAsync(String id, final ApiCallback<QueryResultAutoOrganizeModelFileOrganizationResult> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postLibraryFileorganizationsByIdOrganizeValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryResultAutoOrganizeModelFileOrganizationResult>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postLibraryFileorganizationsSmartmatchesDelete
     * @param entries SmartMatch Entry (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postLibraryFileorganizationsSmartmatchesDeleteCall(List<NameValuePair> entries, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/Library/FileOrganizations/SmartMatches/Delete";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (entries != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "Entries", entries));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "apikeyauth", "embyauth" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postLibraryFileorganizationsSmartmatchesDeleteValidateBeforeCall(List<NameValuePair> entries, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'entries' is set
        if (entries == null) {
            throw new ApiException("Missing the required parameter 'entries' when calling postLibraryFileorganizationsSmartmatchesDelete(Async)");
        }
        
        com.squareup.okhttp.Call call = postLibraryFileorganizationsSmartmatchesDeleteCall(entries, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Deletes a smart match entry
     * Requires authentication as administrator
     * @param entries SmartMatch Entry (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void postLibraryFileorganizationsSmartmatchesDelete(List<NameValuePair> entries) throws ApiException {
        postLibraryFileorganizationsSmartmatchesDeleteWithHttpInfo(entries);
    }

    /**
     * Deletes a smart match entry
     * Requires authentication as administrator
     * @param entries SmartMatch Entry (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> postLibraryFileorganizationsSmartmatchesDeleteWithHttpInfo(List<NameValuePair> entries) throws ApiException {
        com.squareup.okhttp.Call call = postLibraryFileorganizationsSmartmatchesDeleteValidateBeforeCall(entries, null, null);
        return apiClient.execute(call);
    }

    /**
     * Deletes a smart match entry (asynchronously)
     * Requires authentication as administrator
     * @param entries SmartMatch Entry (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postLibraryFileorganizationsSmartmatchesDeleteAsync(List<NameValuePair> entries, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postLibraryFileorganizationsSmartmatchesDeleteValidateBeforeCall(entries, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
