/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import embyclient.model.AutoOrganizeModelFileOrganizerType;
import embyclient.model.AutoOrganizeModelFileSortingStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
/**
 * AutoOrganizeModelFileOrganizationResult
 */


public class AutoOrganizeModelFileOrganizationResult {
  @SerializedName("Id")
  private String id = null;

  @SerializedName("OriginalPath")
  private String originalPath = null;

  @SerializedName("OriginalFileName")
  private String originalFileName = null;

  @SerializedName("ExtractedName")
  private String extractedName = null;

  @SerializedName("ExtractedYear")
  private Integer extractedYear = null;

  @SerializedName("ExtractedSeasonNumber")
  private Integer extractedSeasonNumber = null;

  @SerializedName("ExtractedEpisodeNumber")
  private Integer extractedEpisodeNumber = null;

  @SerializedName("ExtractedEndingEpisodeNumber")
  private Integer extractedEndingEpisodeNumber = null;

  @SerializedName("TargetPath")
  private String targetPath = null;

  @SerializedName("Date")
  private OffsetDateTime date = null;

  @SerializedName("StatusMessage")
  private String statusMessage = null;

  @SerializedName("Status")
  private AutoOrganizeModelFileSortingStatus status = null;

  @SerializedName("OrganizerType")
  private AutoOrganizeModelFileOrganizerType organizerType = null;

  @SerializedName("Type")
  private String type = null;

  @SerializedName("DuplicatePaths")
  private List<String> duplicatePaths = null;

  @SerializedName("FileSize")
  private Long fileSize = null;

  @SerializedName("IsInProgress")
  private Boolean isInProgress = null;

  public AutoOrganizeModelFileOrganizationResult id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(description = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public AutoOrganizeModelFileOrganizationResult originalPath(String originalPath) {
    this.originalPath = originalPath;
    return this;
  }

   /**
   * Get originalPath
   * @return originalPath
  **/
  @Schema(description = "")
  public String getOriginalPath() {
    return originalPath;
  }

  public void setOriginalPath(String originalPath) {
    this.originalPath = originalPath;
  }

  public AutoOrganizeModelFileOrganizationResult originalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
    return this;
  }

   /**
   * Get originalFileName
   * @return originalFileName
  **/
  @Schema(description = "")
  public String getOriginalFileName() {
    return originalFileName;
  }

  public void setOriginalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
  }

  public AutoOrganizeModelFileOrganizationResult extractedName(String extractedName) {
    this.extractedName = extractedName;
    return this;
  }

   /**
   * Get extractedName
   * @return extractedName
  **/
  @Schema(description = "")
  public String getExtractedName() {
    return extractedName;
  }

  public void setExtractedName(String extractedName) {
    this.extractedName = extractedName;
  }

  public AutoOrganizeModelFileOrganizationResult extractedYear(Integer extractedYear) {
    this.extractedYear = extractedYear;
    return this;
  }

   /**
   * Get extractedYear
   * @return extractedYear
  **/
  @Schema(description = "")
  public Integer getExtractedYear() {
    return extractedYear;
  }

  public void setExtractedYear(Integer extractedYear) {
    this.extractedYear = extractedYear;
  }

  public AutoOrganizeModelFileOrganizationResult extractedSeasonNumber(Integer extractedSeasonNumber) {
    this.extractedSeasonNumber = extractedSeasonNumber;
    return this;
  }

   /**
   * Get extractedSeasonNumber
   * @return extractedSeasonNumber
  **/
  @Schema(description = "")
  public Integer getExtractedSeasonNumber() {
    return extractedSeasonNumber;
  }

  public void setExtractedSeasonNumber(Integer extractedSeasonNumber) {
    this.extractedSeasonNumber = extractedSeasonNumber;
  }

  public AutoOrganizeModelFileOrganizationResult extractedEpisodeNumber(Integer extractedEpisodeNumber) {
    this.extractedEpisodeNumber = extractedEpisodeNumber;
    return this;
  }

   /**
   * Get extractedEpisodeNumber
   * @return extractedEpisodeNumber
  **/
  @Schema(description = "")
  public Integer getExtractedEpisodeNumber() {
    return extractedEpisodeNumber;
  }

  public void setExtractedEpisodeNumber(Integer extractedEpisodeNumber) {
    this.extractedEpisodeNumber = extractedEpisodeNumber;
  }

  public AutoOrganizeModelFileOrganizationResult extractedEndingEpisodeNumber(Integer extractedEndingEpisodeNumber) {
    this.extractedEndingEpisodeNumber = extractedEndingEpisodeNumber;
    return this;
  }

   /**
   * Get extractedEndingEpisodeNumber
   * @return extractedEndingEpisodeNumber
  **/
  @Schema(description = "")
  public Integer getExtractedEndingEpisodeNumber() {
    return extractedEndingEpisodeNumber;
  }

  public void setExtractedEndingEpisodeNumber(Integer extractedEndingEpisodeNumber) {
    this.extractedEndingEpisodeNumber = extractedEndingEpisodeNumber;
  }

  public AutoOrganizeModelFileOrganizationResult targetPath(String targetPath) {
    this.targetPath = targetPath;
    return this;
  }

   /**
   * Get targetPath
   * @return targetPath
  **/
  @Schema(description = "")
  public String getTargetPath() {
    return targetPath;
  }

  public void setTargetPath(String targetPath) {
    this.targetPath = targetPath;
  }

  public AutoOrganizeModelFileOrganizationResult date(OffsetDateTime date) {
    this.date = date;
    return this;
  }

   /**
   * Get date
   * @return date
  **/
  @Schema(description = "")
  public OffsetDateTime getDate() {
    return date;
  }

  public void setDate(OffsetDateTime date) {
    this.date = date;
  }

  public AutoOrganizeModelFileOrganizationResult statusMessage(String statusMessage) {
    this.statusMessage = statusMessage;
    return this;
  }

   /**
   * Get statusMessage
   * @return statusMessage
  **/
  @Schema(description = "")
  public String getStatusMessage() {
    return statusMessage;
  }

  public void setStatusMessage(String statusMessage) {
    this.statusMessage = statusMessage;
  }

  public AutoOrganizeModelFileOrganizationResult status(AutoOrganizeModelFileSortingStatus status) {
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @Schema(description = "")
  public AutoOrganizeModelFileSortingStatus getStatus() {
    return status;
  }

  public void setStatus(AutoOrganizeModelFileSortingStatus status) {
    this.status = status;
  }

  public AutoOrganizeModelFileOrganizationResult organizerType(AutoOrganizeModelFileOrganizerType organizerType) {
    this.organizerType = organizerType;
    return this;
  }

   /**
   * Get organizerType
   * @return organizerType
  **/
  @Schema(description = "")
  public AutoOrganizeModelFileOrganizerType getOrganizerType() {
    return organizerType;
  }

  public void setOrganizerType(AutoOrganizeModelFileOrganizerType organizerType) {
    this.organizerType = organizerType;
  }

  public AutoOrganizeModelFileOrganizationResult type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @Schema(description = "")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public AutoOrganizeModelFileOrganizationResult duplicatePaths(List<String> duplicatePaths) {
    this.duplicatePaths = duplicatePaths;
    return this;
  }

  public AutoOrganizeModelFileOrganizationResult addDuplicatePathsItem(String duplicatePathsItem) {
    if (this.duplicatePaths == null) {
      this.duplicatePaths = new ArrayList<>();
    }
    this.duplicatePaths.add(duplicatePathsItem);
    return this;
  }

   /**
   * Get duplicatePaths
   * @return duplicatePaths
  **/
  @Schema(description = "")
  public List<String> getDuplicatePaths() {
    return duplicatePaths;
  }

  public void setDuplicatePaths(List<String> duplicatePaths) {
    this.duplicatePaths = duplicatePaths;
  }

  public AutoOrganizeModelFileOrganizationResult fileSize(Long fileSize) {
    this.fileSize = fileSize;
    return this;
  }

   /**
   * Get fileSize
   * @return fileSize
  **/
  @Schema(description = "")
  public Long getFileSize() {
    return fileSize;
  }

  public void setFileSize(Long fileSize) {
    this.fileSize = fileSize;
  }

  public AutoOrganizeModelFileOrganizationResult isInProgress(Boolean isInProgress) {
    this.isInProgress = isInProgress;
    return this;
  }

   /**
   * Get isInProgress
   * @return isInProgress
  **/
  @Schema(description = "")
  public Boolean isIsInProgress() {
    return isInProgress;
  }

  public void setIsInProgress(Boolean isInProgress) {
    this.isInProgress = isInProgress;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AutoOrganizeModelFileOrganizationResult autoOrganizeModelFileOrganizationResult = (AutoOrganizeModelFileOrganizationResult) o;
    return Objects.equals(this.id, autoOrganizeModelFileOrganizationResult.id) &&
        Objects.equals(this.originalPath, autoOrganizeModelFileOrganizationResult.originalPath) &&
        Objects.equals(this.originalFileName, autoOrganizeModelFileOrganizationResult.originalFileName) &&
        Objects.equals(this.extractedName, autoOrganizeModelFileOrganizationResult.extractedName) &&
        Objects.equals(this.extractedYear, autoOrganizeModelFileOrganizationResult.extractedYear) &&
        Objects.equals(this.extractedSeasonNumber, autoOrganizeModelFileOrganizationResult.extractedSeasonNumber) &&
        Objects.equals(this.extractedEpisodeNumber, autoOrganizeModelFileOrganizationResult.extractedEpisodeNumber) &&
        Objects.equals(this.extractedEndingEpisodeNumber, autoOrganizeModelFileOrganizationResult.extractedEndingEpisodeNumber) &&
        Objects.equals(this.targetPath, autoOrganizeModelFileOrganizationResult.targetPath) &&
        Objects.equals(this.date, autoOrganizeModelFileOrganizationResult.date) &&
        Objects.equals(this.statusMessage, autoOrganizeModelFileOrganizationResult.statusMessage) &&
        Objects.equals(this.status, autoOrganizeModelFileOrganizationResult.status) &&
        Objects.equals(this.organizerType, autoOrganizeModelFileOrganizationResult.organizerType) &&
        Objects.equals(this.type, autoOrganizeModelFileOrganizationResult.type) &&
        Objects.equals(this.duplicatePaths, autoOrganizeModelFileOrganizationResult.duplicatePaths) &&
        Objects.equals(this.fileSize, autoOrganizeModelFileOrganizationResult.fileSize) &&
        Objects.equals(this.isInProgress, autoOrganizeModelFileOrganizationResult.isInProgress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, originalPath, originalFileName, extractedName, extractedYear, extractedSeasonNumber, extractedEpisodeNumber, extractedEndingEpisodeNumber, targetPath, date, statusMessage, status, organizerType, type, duplicatePaths, fileSize, isInProgress);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AutoOrganizeModelFileOrganizationResult {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    originalPath: ").append(toIndentedString(originalPath)).append("\n");
    sb.append("    originalFileName: ").append(toIndentedString(originalFileName)).append("\n");
    sb.append("    extractedName: ").append(toIndentedString(extractedName)).append("\n");
    sb.append("    extractedYear: ").append(toIndentedString(extractedYear)).append("\n");
    sb.append("    extractedSeasonNumber: ").append(toIndentedString(extractedSeasonNumber)).append("\n");
    sb.append("    extractedEpisodeNumber: ").append(toIndentedString(extractedEpisodeNumber)).append("\n");
    sb.append("    extractedEndingEpisodeNumber: ").append(toIndentedString(extractedEndingEpisodeNumber)).append("\n");
    sb.append("    targetPath: ").append(toIndentedString(targetPath)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    statusMessage: ").append(toIndentedString(statusMessage)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    organizerType: ").append(toIndentedString(organizerType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    duplicatePaths: ").append(toIndentedString(duplicatePaths)).append("\n");
    sb.append("    fileSize: ").append(toIndentedString(fileSize)).append("\n");
    sb.append("    isInProgress: ").append(toIndentedString(isInProgress)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
