/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Gets or Sets AutoOrganize.Model.FileOrganizerType
 */
@JsonAdapter(AutoOrganizeModelFileOrganizerType.Adapter.class)
public enum AutoOrganizeModelFileOrganizerType {
  UNKNOWN("Unknown"),
  MOVIE("Movie"),
  EPISODE("Episode"),
  SONG("Song");

  private String value;

  AutoOrganizeModelFileOrganizerType(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static AutoOrganizeModelFileOrganizerType fromValue(String input) {
    for (AutoOrganizeModelFileOrganizerType b : AutoOrganizeModelFileOrganizerType.values()) {
      if (b.value.equals(input)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<AutoOrganizeModelFileOrganizerType> {
    @Override
    public void write(final JsonWriter jsonWriter, final AutoOrganizeModelFileOrganizerType enumeration) throws IOException {
      jsonWriter.value(String.valueOf(enumeration.getValue()));
    }

    @Override
    public AutoOrganizeModelFileOrganizerType read(final JsonReader jsonReader) throws IOException {
      Object value = jsonReader.nextString();
      return AutoOrganizeModelFileOrganizerType.fromValue((String)(value));
    }
  }
}
