/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Gets or Sets AutoOrganize.Model.FileSortingStatus
 */
@JsonAdapter(AutoOrganizeModelFileSortingStatus.Adapter.class)
public enum AutoOrganizeModelFileSortingStatus {
  SUCCESS("Success"),
  FAILURE("Failure"),
  SKIPPEDEXISTING("SkippedExisting");

  private String value;

  AutoOrganizeModelFileSortingStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static AutoOrganizeModelFileSortingStatus fromValue(String input) {
    for (AutoOrganizeModelFileSortingStatus b : AutoOrganizeModelFileSortingStatus.values()) {
      if (b.value.equals(input)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<AutoOrganizeModelFileSortingStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final AutoOrganizeModelFileSortingStatus enumeration) throws IOException {
      jsonWriter.value(String.valueOf(enumeration.getValue()));
    }

    @Override
    public AutoOrganizeModelFileSortingStatus read(final JsonReader jsonReader) throws IOException {
      Object value = jsonReader.nextString();
      return AutoOrganizeModelFileSortingStatus.fromValue((String)(value));
    }
  }
}
