/*
 * Emby Server REST API (BETA)
 * 
 */

package embyclient.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import embyclient.model.AutoOrganizeModelFileOrganizerType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * AutoOrganizeModelSmartMatchInfo
 */


public class AutoOrganizeModelSmartMatchInfo {
  @SerializedName("ItemName")
  private String itemName = null;

  @SerializedName("DisplayName")
  private String displayName = null;

  @SerializedName("OrganizerType")
  private AutoOrganizeModelFileOrganizerType organizerType = null;

  @SerializedName("MatchStrings")
  private List<String> matchStrings = null;

  public AutoOrganizeModelSmartMatchInfo itemName(String itemName) {
    this.itemName = itemName;
    return this;
  }

   /**
   * Get itemName
   * @return itemName
  **/
  @Schema(description = "")
  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  public AutoOrganizeModelSmartMatchInfo displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @Schema(description = "")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public AutoOrganizeModelSmartMatchInfo organizerType(AutoOrganizeModelFileOrganizerType organizerType) {
    this.organizerType = organizerType;
    return this;
  }

   /**
   * Get organizerType
   * @return organizerType
  **/
  @Schema(description = "")
  public AutoOrganizeModelFileOrganizerType getOrganizerType() {
    return organizerType;
  }

  public void setOrganizerType(AutoOrganizeModelFileOrganizerType organizerType) {
    this.organizerType = organizerType;
  }

  public AutoOrganizeModelSmartMatchInfo matchStrings(List<String> matchStrings) {
    this.matchStrings = matchStrings;
    return this;
  }

  public AutoOrganizeModelSmartMatchInfo addMatchStringsItem(String matchStringsItem) {
    if (this.matchStrings == null) {
      this.matchStrings = new ArrayList<>();
    }
    this.matchStrings.add(matchStringsItem);
    return this;
  }

   /**
   * Get matchStrings
   * @return matchStrings
  **/
  @Schema(description = "")
  public List<String> getMatchStrings() {
    return matchStrings;
  }

  public void setMatchStrings(List<String> matchStrings) {
    this.matchStrings = matchStrings;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AutoOrganizeModelSmartMatchInfo autoOrganizeModelSmartMatchInfo = (AutoOrganizeModelSmartMatchInfo) o;
    return Objects.equals(this.itemName, autoOrganizeModelSmartMatchInfo.itemName) &&
        Objects.equals(this.displayName, autoOrganizeModelSmartMatchInfo.displayName) &&
        Objects.equals(this.organizerType, autoOrganizeModelSmartMatchInfo.organizerType) &&
        Objects.equals(this.matchStrings, autoOrganizeModelSmartMatchInfo.matchStrings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(itemName, displayName, organizerType, matchStrings);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AutoOrganizeModelSmartMatchInfo {\n");
    
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    organizerType: ").append(toIndentedString(organizerType)).append("\n");
    sb.append("    matchStrings: ").append(toIndentedString(matchStrings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
